/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.calculator.mod.client.gui.machines.GuiPowerCube;
import sonar.calculator.mod.common.tileentity.machines.TileEntityPowerCube;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyMode;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.utils.IGuiTile;
import sonar.core.utils.IMachineSides;
import sonar.core.utils.MachineSideConfig;
import sonar.core.utils.MachineSides;

public class TileEntityAdvancedPowerCube
extends TileEntityPowerCube
implements IGuiTile,
IMachineSides {
    public MachineSides sides = new MachineSides(MachineSideConfig.INPUT, (TileEntity)this, new Object[]{MachineSideConfig.NONE});

    public TileEntityAdvancedPowerCube() {
        this.syncList.addParts(new IDirtyPart[]{this.sides});
        this.storage.setCapacity(100000).setMaxTransfer(64000);
        this.maxTransfer = 100000;
        this.energyMode = EnergyMode.SEND_RECIEVE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        this.addEnergy();
    }

    public void addEnergy() {
        ArrayList facing = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        if (facing.isEmpty()) {
            return;
        }
        int transfer = this.maxTransfer / facing.size();
        for (EnumFacing dir : facing) {
            TileEntity entity = SonarHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)dir);
            SonarAPI.getEnergyHelper().transferEnergy((TileEntity)this, entity, dir, dir, (long)transfer);
        }
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side != null) {
            return this.sides.getSideConfig(side).isInput() ? EnergyMode.RECIEVE : (this.sides.getSideConfig(side).isOutput() ? EnergyMode.SEND : EnergyMode.BLOCKED);
        }
        return super.getModeForSide(side);
    }

    @Override
    public Object getGuiScreen(EntityPlayer player) {
        return new GuiPowerCube(player.field_71071_by, this);
    }

    public MachineSides getSideConfigs() {
        return this.sides;
    }
}

