/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.machines.GuiAtomicMultiplier;
import sonar.calculator.mod.common.containers.ContainerAtomicMultiplier;
import sonar.calculator.mod.utils.AtomicMultiplierBlacklist;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.energy.DischargeValues;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IGuiTile;

public class TileEntityAtomicMultiplier
extends TileEntityEnergyInventory
implements ISidedInventory,
IProcessMachine,
IGuiTile {
    public SyncTagType.INT cookTime = new SyncTagType.INT(0);
    public SyncTagType.INT active = new SyncTagType.INT(1);
    public static int furnaceSpeed = 1000;
    public static int requiredEnergy = 1500000000;
    private static final int[] input = new int[]{0};
    private static final int[] circuits = new int[]{1, 2, 3, 4, 5, 6, 7};
    private static final int[] output = new int[]{8};

    public TileEntityAtomicMultiplier() {
        this.storage.setCapacity(requiredEnergy).setMaxTransfer(requiredEnergy);
        this.inv = new SonarInventory((TileEntity)this, 10);
        this.energyMode = EnergyMode.RECIEVE;
        this.syncList.addParts(new IDirtyPart[]{this.cookTime, this.active, this.inv});
    }

    public void func_73660_a() {
        int energy;
        super.func_73660_a();
        this.discharge(9);
        if ((Integer)this.cookTime.getObject() > 0) {
            this.active.setObject((Object)1);
            this.cookTime.increaseBy(1);
            energy = requiredEnergy / furnaceSpeed;
            this.storage.modifyEnergyStored(-energy);
        }
        if (this.canCook()) {
            if (!this.field_145850_b.field_72995_K && (Integer)this.cookTime.getObject() == 0) {
                this.cookTime.increaseBy(1);
            }
            if ((Integer)this.cookTime.getObject() == furnaceSpeed) {
                this.cookTime.setObject((Object)0);
                this.cookItem();
                this.active.setObject((Object)0);
                energy = requiredEnergy / furnaceSpeed;
                this.storage.modifyEnergyStored(-energy);
                this.markBlockForUpdate();
            }
        } else if ((Integer)this.cookTime.getObject() != 0 || (Integer)this.active.getObject() != 0) {
            this.cookTime.setObject((Object)0);
            this.active.setObject((Object)0);
            this.markBlockForUpdate();
        }
        this.func_70296_d();
    }

    public boolean canCook() {
        if (this.storage.getEnergyStored() == 0) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (!((ItemStack)this.slots().get(i)).func_190926_b()) continue;
            return false;
        }
        if (!TileEntityAtomicMultiplier.isAllowed((ItemStack)this.slots().get(0))) {
            return false;
        }
        ItemStack output = (ItemStack)this.slots().get(8);
        if (!output.func_190926_b()) {
            if (output.func_190916_E() + 4 > 64) {
                return false;
            }
            if (!((ItemStack)this.slots().get(0)).func_77969_a(output)) {
                return false;
            }
        }
        if ((Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyStored() < requiredEnergy) {
            return false;
        }
        if (((ItemStack)this.slots().get(0)).func_77976_d() < 4) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (((ItemStack)this.slots().get(i)).func_77973_b() == Calculator.circuitBoard) continue;
            return false;
        }
        if ((Integer)this.cookTime.getObject() >= furnaceSpeed) {
            return true;
        }
        return true;
    }

    public static boolean isAllowed(ItemStack stack) {
        return AtomicMultiplierBlacklist.blacklist().isAllowed(stack.func_77973_b());
    }

    private void cookItem() {
        ItemStack itemstack = new ItemStack(((ItemStack)this.slots().get(0)).func_77973_b(), 4, ((ItemStack)this.slots().get(0)).func_77952_i());
        ItemStack output = (ItemStack)this.slots().get(8);
        if (output.func_190926_b()) {
            this.slots().set(8, itemstack);
        } else if (output.func_77969_a(itemstack)) {
            output.func_190917_f(4);
        }
        for (int i = 0; i < 8; ++i) {
            ((ItemStack)this.slots().get(i)).func_190918_g(1);
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return 0 < slot && slot < 8 ? stack.func_77973_b() == Calculator.circuitBoard : (slot == 0 ? stack.func_77976_d() >= 4 : slot == 9 && DischargeValues.getValueOf((ItemStack)stack) > 0);
    }

    public int[] func_180463_a(EnumFacing side) {
        return EnumFacing.DOWN == side ? output : (EnumFacing.UP == side ? input : (EnumFacing.field_82609_l[2] == side ? circuits : (EnumFacing.field_82609_l[3] == side ? circuits : (EnumFacing.field_82609_l[4] == side ? circuits : (EnumFacing.field_82609_l[5] == side ? circuits : input)))));
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot == 8;
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.markBlockForUpdate();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        super.getWailaInfo(currenttip, state);
        if ((Integer)this.cookTime.getObject() > 0) {
            String active = FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"locator.active");
            currenttip.add(active);
        } else {
            String idle = FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"locator.idle");
            currenttip.add(idle);
        }
        return currenttip;
    }

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        return furnaceSpeed;
    }

    public double getEnergyUsage() {
        return requiredEnergy / furnaceSpeed;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerAtomicMultiplier(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiAtomicMultiplier(player.field_71071_by, this);
    }

    public int getBaseProcessTime() {
        return furnaceSpeed;
    }
}

