/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.machines.IFlawlessGreenhouse;
import sonar.calculator.mod.client.gui.machines.GuiFlawlessGreenhouse;
import sonar.calculator.mod.common.containers.ContainerFlawlessGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.misc.TileEntityCO2Generator;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.utils.FailedCoords;
import sonar.core.utils.IGuiTile;

public class TileEntityFlawlessGreenhouse
extends TileEntityGreenhouse
implements ISidedInventory,
IFlawlessGreenhouse,
IGuiTile {
    public int plants;
    public int levelTicks;
    public int checkTicks;
    public int houseSize;
    public int growTicks;
    public int growTick;
    public int plantsGrown;

    public TileEntityFlawlessGreenhouse() {
        this.storage.setCapacity(500000).setMaxTransfer(64000);
        this.inv = new SonarInventory((TileEntity)this, 10);
        this.energyMode = EnergyMode.RECIEVE;
        this.type = 3;
        this.maxLevel = 100000;
        this.plantTick = 2;
        this.syncList.addPart((IDirtyPart)this.inv);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.houseState.getObject() != TileEntityGreenhouse.State.BUILDING) {
            this.checkTile();
        }
        if (this.houseState.getObject() == TileEntityGreenhouse.State.COMPLETED) {
            if (!this.field_145850_b.field_72995_K) {
                this.extraTicks();
            }
            if (this.isActive()) {
                this.plantCrops();
                this.grow();
                this.harvestCrops();
            }
        }
        this.discharge(0);
    }

    public void grow() {
        if (this.growTicks == 0) {
            this.growTick = GreenhouseHelper.getGrowTicks(this.getOxygen(), 3);
            ++this.growTicks;
        }
        if (this.growTick != 0 && this.growTicks >= 0 && this.growTicks != this.growTick) {
            ++this.growTicks;
        }
        if (this.growTicks == this.growTick) {
            this.growCrops(this.houseSize);
            this.growTicks = 0;
        }
    }

    @Override
    public ArrayList<BlockPos> getPlantArea() {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        int hX = this.horizontal.func_82601_c();
        int hZ = this.horizontal.func_82599_e();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 1; XZ <= 2; ++XZ) {
                coords.add(this.field_174879_c.func_177982_a(hX * XZ + fX * (1 + i), 0, hZ * XZ + fZ * (1 + i)));
            }
        }
        return coords;
    }

    public void extraTicks() {
        if (this.levelTicks == 15) {
            this.getPlants();
        }
        if (this.levelTicks >= 0 && this.levelTicks != 20) {
            ++this.levelTicks;
        }
        if (this.levelTicks == 20) {
            this.levelTicks = 0;
            SonarAPI.getItemHelper().transferItems(this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(this.forward.func_176734_d())), (TileEntity)this, EnumFacing.func_82600_a((int)0), EnumFacing.func_82600_a((int)0), (InventoryHelper.IInventoryFilter)new TileEntityGreenhouse.PlantableFilter());
            this.gasLevels();
        }
    }

    @Override
    public FailedCoords checkStructure(TileEntityGreenhouse.GreenhouseAction action) {
        if (SonarHelper.getHorizontal((EnumFacing)this.forward) != null) {
            int fZ;
            int fX;
            int hoZ;
            int hoX;
            int hZ;
            int hX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c();
            FailedCoords size = this.checkSize(true, this.field_145850_b, hX, hZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e(), hoX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82601_c(), hoZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82599_e(), fX = this.forward.func_82601_c(), fZ = this.forward.func_82599_e(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            if (!size.getBoolean()) {
                return size;
            }
            return new FailedCoords(true, BlockCoords.EMPTY, FontHelper.translate((String)"locator.none"));
        }
        return new FailedCoords(false, BlockCoords.EMPTY, "Something went wrong...");
    }

    public void gasLevels() {
        int add;
        boolean day = this.field_145850_b.func_72935_r();
        int gasAdd = this.getGasAdd();
        if (day) {
            add = this.plants * 8 - gasAdd * 2;
            this.addGas(-add);
        }
        if (!day) {
            add = this.plants * 2 + gasAdd * 2;
            this.addGas(add);
        }
    }

    private int getGasAdd() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c() * 3, 0, SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e() * 3));
        if (tile != null && tile instanceof TileEntityCO2Generator) {
            TileEntityCO2Generator generator = (TileEntityCO2Generator)tile;
            return generator.gasAdd;
        }
        return 0;
    }

    private void getPlants() {
        int hX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c();
        int hZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e();
        int hoX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82601_c();
        int hoZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82599_e();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        this.plants = 0;
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 1; XZ <= 2; ++XZ) {
                BlockPos pos = this.field_174879_c.func_177982_a(hX * XZ + fX * (1 + i), 0, hZ * XZ + fZ * (1 + i));
                if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof IGrowable)) continue;
                ++this.plants;
            }
        }
    }

    @Override
    public void addFarmland() {
        int hX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82601_c();
        int hZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_82599_e();
        int hoX = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82601_c();
        int hoZ = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d().func_82599_e();
        int fX = this.forward.func_82601_c();
        int fZ = this.forward.func_82599_e();
        for (int i = 0; i <= this.houseSize; ++i) {
            for (int XZ = 0; XZ <= 3; ++XZ) {
                BlockPos pos = this.field_174879_c.func_177982_a(hX * XZ + fX * (1 + i), 0, hZ * XZ + fZ * (1 + i));
                if (XZ != 1 && XZ != 2) {
                    if (this.storage.getEnergyStored() < this.waterRF || !GreenhouseHelper.applyWater(this.field_145850_b, pos)) continue;
                    this.storage.modifyEnergyStored(-this.waterRF);
                    continue;
                }
                if (this.storage.getEnergyStored() < this.farmlandRF || !GreenhouseHelper.applyFarmland(this.field_145850_b, pos)) continue;
                this.storage.modifyEnergyStored(-this.farmlandRF);
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.plantsHarvested = nbt.func_74762_e("plantsHarvested");
            this.plantsGrown = nbt.func_74762_e("plantsGrown");
            this.houseSize = nbt.func_74762_e("houseSize");
            if (type == NBTHelper.SyncType.SAVE) {
                this.planting = nbt.func_74762_e("planting");
                this.plants = nbt.func_74762_e("Plants");
                this.levelTicks = nbt.func_74762_e("Level");
                this.plantTicks = nbt.func_74762_e("Plant");
                this.checkTicks = nbt.func_74762_e("Check");
                this.growTick = nbt.func_74762_e("growTick");
                this.growTicks = nbt.func_74762_e("growTicks");
            }
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            nbt.func_74768_a("plantsHarvested", this.plantsHarvested);
            nbt.func_74768_a("plantsGrown", this.plantsGrown);
            nbt.func_74768_a("houseSize", this.houseSize);
            if (type == NBTHelper.SyncType.SAVE) {
                nbt.func_74768_a("planting", this.planting);
                nbt.func_74768_a("Plants", this.plants);
                nbt.func_74768_a("Level", this.levelTicks);
                nbt.func_74768_a("Check", this.checkTicks);
                nbt.func_74768_a("Plant", this.plantTicks);
                nbt.func_74768_a("growTicks", this.growTicks);
                nbt.func_74768_a("growTick", this.growTick);
            }
        }
        return nbt;
    }

    public boolean stableStone(int x, int y, int z) {
        Block block = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        return block != null && !GreenhouseHelper.stableStone(block);
    }

    public boolean flawlessGlass(int x, int y, int z) {
        Block block = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        return block != null && !GreenhouseHelper.flawlessGlass(block);
    }

    public boolean slabQuartz(int x, int y, int z) {
        return !GreenhouseHelper.slabQuartz(this.field_145850_b, new BlockPos(x, y, z));
    }

    public FailedCoords checkSize(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        this.houseSize = 0;
        FailedCoords start = this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x, y, z);
        if (start.getBoolean()) {
            for (int i = 1; i <= 65; ++i) {
                if (i == 65) {
                    return this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                }
                FailedCoords middle = this.middle(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                if (!middle.getBoolean()) {
                    if (this.houseSize > 0) {
                        return this.end(check, w, hX, hZ, hoX, hoZ, fX, fZ, x + fX * i, y, z + fZ * i);
                    }
                    return middle;
                }
                if (!middle.getBoolean()) continue;
                ++this.houseSize;
            }
        } else {
            return start;
        }
        return new FailedCoords(true, BlockCoords.EMPTY, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords middle(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = 0; i <= 3; ++i) {
            if (!this.slabQuartz(x + hX * i, y + 2, z + hZ * i)) continue;
            return new FailedCoords(false, x + hX * i, y + 2, z + hZ * i, FontHelper.translate((String)"greenhouse.quartz"));
        }
        for (i = 0; i <= 1; ++i) {
            if (this.flawlessGlass(x + hX * 3, y + i, z + hZ * 3)) {
                return new FailedCoords(false, x + hX * 3, y + i, z + hZ * 3, FontHelper.translate((String)"greenhouse.glass"));
            }
            if (!this.flawlessGlass(x, y + i, z)) continue;
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.glass"));
        }
        return new FailedCoords(true, BlockCoords.EMPTY, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords end(boolean check, World w, int hX, int hZ, int hoX, int hoZ, int fX, int fZ, int x, int y, int z) {
        int i;
        for (i = 0; i <= 3; ++i) {
            if (this.stableStone(x + hX * i, y - 1, z + hZ * i)) {
                return new FailedCoords(false, x + hX * i, y - 1, z + hZ * i, FontHelper.translate((String)"greenhouse.stable"));
            }
            if (!this.slabQuartz(x + hX * i, y + 2, z + hZ * i)) continue;
            return new FailedCoords(false, x + hX * i, y + 2, z + hZ * i, FontHelper.translate((String)"greenhouse.quartz"));
        }
        for (i = 0; i <= 1; ++i) {
            if (this.stableStone(x + hX * 3, y + i, z + hZ * 3)) {
                return new FailedCoords(false, x + hX * 3, y + i, z + hZ * 3, FontHelper.translate((String)"greenhouse.stable"));
            }
            if (!this.stableStone(x, y + i, z)) continue;
            return new FailedCoords(false, x, y + i, z, FontHelper.translate((String)"greenhouse.stable"));
        }
        return new FailedCoords(true, BlockCoords.EMPTY, FontHelper.translate((String)"locator.none"));
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return stack != null && stack.func_77973_b() instanceof IPlantable;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add(FontHelper.translate((String)"greenhouse.size") + ": " + this.houseSize);
        return super.getWailaInfo(currenttip, state);
    }

    @Override
    public int getPlantsHarvested() {
        return this.plantsHarvested;
    }

    @Override
    public int getPlantsGrown() {
        return this.plantsGrown;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFlawlessGreenhouse(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFlawlessGreenhouse(player.field_71071_by, this);
    }
}

