/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.client.gui.machines.GuiStorageChamber;
import sonar.calculator.mod.common.containers.ContainerStorageChamber;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.common.tileentity.TileEntityLargeInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.ILargeInventory;
import sonar.core.inventory.SonarLargeInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.utils.IGuiTile;

public class TileEntityStorageChamber
extends TileEntityLargeInventory
implements IGuiTile,
ILargeInventory {
    public CircuitType circuitType = CircuitType.None;

    public void func_73660_a() {
        super.func_73660_a();
        this.resetCircuitType();
    }

    public TileEntityStorageChamber() {
        this.inv = new SonarLargeInventory(14, 1024){

            public boolean isItemValidForPos(int slot, ItemStack item) {
                if (!item.func_190926_b() && item.func_77960_j() == slot) {
                    CircuitType stackType = TileEntityStorageChamber.getCircuitType(item);
                    if (stackType == null) {
                        return false;
                    }
                    if (((TileEntityStorageChamber)this.listener).circuitType != CircuitType.None && ((TileEntityStorageChamber)this.listener).circuitType != stackType) {
                        return false;
                    }
                    return super.isItemValidForPos(slot, item);
                }
                return false;
            }
        };
        this.syncList.addParts(new IDirtyPart[]{this.inv});
    }

    public SonarLargeInventory getTileInv() {
        return this.inv;
    }

    public void resetCircuitType() {
        if (this.isServer()) {
            StoredItemStack[] slots;
            for (StoredItemStack stack : slots = this.inv.slots) {
                CircuitType type;
                if (stack == null || stack.getStackSize() == 0L || (type = TileEntityStorageChamber.getCircuitType(stack.item)) == null || type == CircuitType.None) continue;
                this.circuitType = type;
                return;
            }
            this.circuitType = CircuitType.None;
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.circuitType = CircuitType.values()[nbt.func_74762_e("type")];
            if (this.circuitType == null) {
                this.circuitType = CircuitType.None;
            }
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            this.inv.readData(nbt, NBTHelper.SyncType.SAVE);
            this.circuitType = CircuitType.values()[nbt.func_74762_e("type")];
            if (this.circuitType == null) {
                this.circuitType = CircuitType.None;
            }
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74768_a("type", this.circuitType.ordinal());
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            this.inv.writeData(nbt, NBTHelper.SyncType.SAVE);
            nbt.func_74768_a("type", this.circuitType.ordinal());
        }
        return nbt;
    }

    public static CircuitType getCircuitType(ItemStack stack) {
        if (stack.func_77973_b() == Calculator.circuitBoard && stack.func_77973_b() instanceof IStability) {
            IStability stability = (IStability)stack.func_77973_b();
            if (stability.getStability(stack) && stack.func_77942_o()) {
                if (stack.func_77978_p().func_74767_n("Analysed")) {
                    return CircuitType.Stable;
                }
            } else {
                if (!stack.func_77942_o()) {
                    return CircuitType.Analysed;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Analysed")) {
                    return CircuitType.Analysed;
                }
            }
        } else {
            if (stack.func_77973_b() == Calculator.circuitDamaged) {
                return CircuitType.Damaged;
            }
            if (stack.func_77973_b() == Calculator.circuitDirty) {
                return CircuitType.Dirty;
            }
        }
        return null;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerStorageChamber(player, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiStorageChamber(player, this);
    }

    public static enum CircuitType {
        Analysed,
        Stable,
        Damaged,
        Dirty,
        None;


        public boolean isProcessed() {
            return this == Analysed || this == Stable;
        }

        public boolean isStable() {
            return this == Stable;
        }
    }
}

