/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import sonar.calculator.mod.common.tileentity.generators.TileEntityConductorMast;
import sonar.core.common.tileentity.TileEntitySonar;

public class TileEntityWeatherStation
extends TileEntitySonar
implements ITickable {
    public double angle;
    public boolean loaded;
    public int x;
    public int z;
    public int ticks;

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.loaded) {
            this.setAngle();
            this.loaded = true;
        } else if (this.ticks < 25) {
            ++this.ticks;
        } else if (this.ticks >= 25) {
            this.ticks = 0;
            this.setAngle();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.angle = nbt.func_74769_h("angle");
        this.x = nbt.func_74762_e("xMAST");
        this.z = nbt.func_74762_e("zMAST");
        this.ticks = nbt.func_74762_e("ticks");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("angle", this.angle);
        nbt.func_74768_a("xMAST", this.x);
        nbt.func_74768_a("zMAST", this.z);
        nbt.func_74768_a("ticks", this.ticks);
        return nbt;
    }

    public void setAngle() {
        double distance = 0.0;
        TileEntityConductorMast mast = null;
        for (int X = -10; X <= 10; ++X) {
            for (int Z = -10; Z <= 10; ++Z) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(X, 0, Z));
                if (target == null || !(target instanceof TileEntityConductorMast)) continue;
                TileEntityConductorMast tile = (TileEntityConductorMast)target;
                double mastDist = target.func_145835_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
                if (distance != 0.0 && !(distance > mastDist) && (mastDist != distance || mast == null || mast.lastStations < tile.lastStations)) continue;
                distance = mastDist;
                this.angle = Math.toDegrees(Math.atan2(Z, X)) - 90.0;
                mast = tile;
            }
        }
        if (mast == null) {
            this.angle = 1000.0;
        } else {
            this.x = mast.func_174877_v().func_177958_n();
            this.z = mast.func_174877_v().func_177952_p();
        }
        this.markBlockForUpdate();
    }

    public boolean maxRender() {
        return true;
    }
}

