/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.network.packets.PacketCalculatorScreen;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.ISonarEnergyHandler;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;

public class TileEntityCalculatorScreen
extends TileEntitySonar {
    public long latestMax;
    public long latestEnergy;
    public long lastMax;
    public long lastEnergy;

    public void func_73660_a() {
        ISonarEnergyHandler handler;
        EnumFacing front;
        TileEntity target;
        super.func_73660_a();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (target = SonarHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)(front = EnumFacing.func_82600_a((int)this.func_145832_p()).func_176734_d()))) != null && (handler = SonarAPI.getEnergyHelper().canTransferEnergy(target, front)) != null) {
            StoredEnergyStack stack = new StoredEnergyStack(handler.getProvidedType());
            handler.getEnergy(stack, target, front);
            long max = stack.capacity;
            long current = stack.stored;
            if (max != this.lastMax) {
                this.sendMax(max);
            }
            if (current != this.lastEnergy) {
                this.sendEnergy(current);
                this.markBlockForUpdate();
            }
        }
    }

    public void sendMax(long max) {
        this.func_70296_d();
        this.lastMax = this.latestMax;
        this.latestMax = max;
        if (!this.field_145850_b.field_72995_K) {
            Calculator.network.sendToAllAround((IMessage)new PacketCalculatorScreen(this.field_174879_c, 0, max), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
    }

    public void sendEnergy(long energy) {
        this.func_70296_d();
        this.lastEnergy = this.latestEnergy;
        this.latestEnergy = energy;
        if (!this.field_145850_b.field_72995_K) {
            Calculator.network.sendToAllAround((IMessage)new PacketCalculatorScreen(this.field_174879_c, 1, energy), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.latestMax = nbt.func_74763_f("latestMax");
            this.latestEnergy = nbt.func_74763_f("latestEnergy");
            this.lastMax = nbt.func_74763_f("lastMax");
            this.lastEnergy = nbt.func_74763_f("lastEnergy");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            nbt.func_74772_a("latestMax", this.latestMax);
            nbt.func_74772_a("latestEnergy", this.latestEnergy);
            nbt.func_74772_a("lastMax", this.lastMax);
            nbt.func_74772_a("lastEnergy", this.lastEnergy);
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

