/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.machines.ITeleport;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.client.gui.misc.GuiTeleporter;
import sonar.calculator.mod.utils.TeleporterRegistry;
import sonar.calculator.mod.utils.helpers.TeleporterHelper;
import sonar.core.SonarCore;
import sonar.core.common.block.StableStone;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.ContainerEmpty;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.IGuiTile;

public class TileEntityTeleporter
extends TileEntitySonar
implements ITeleport,
IByteBufTile,
IGuiTile {
    public int teleporterID;
    public SyncTagType.STRING name = (SyncTagType.STRING)new SyncTagType.STRING(0).setDefault((Object)"LINK NAME");
    public SyncTagType.STRING destinationName = (SyncTagType.STRING)new SyncTagType.STRING(1).setDefault((Object)"DESTINATION");
    public SyncTagType.STRING password = (SyncTagType.STRING)new SyncTagType.STRING(2).setDefault((Object)"");
    public SyncTagType.STRING linkPassword = (SyncTagType.STRING)new SyncTagType.STRING(3).setDefault((Object)"");
    public boolean coolDown;
    public boolean passwordMatch;
    public int coolDownTicks;
    public int linkID;
    public List<TeleportLink> links;

    public TileEntityTeleporter() {
        this.syncList.addParts(new IDirtyPart[]{this.name, this.destinationName, this.linkPassword, this.password});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.coolDownTicks != 0) {
            --this.coolDownTicks;
        } else if (!this.coolDown) {
            if (this.teleporterID == 0) {
                return;
            }
            this.startTeleportation();
        } else {
            List<EntityPlayer> players = this.getPlayerList();
            if (players == null || players.size() == 0) {
                this.coolDown = false;
            }
        }
    }

    public void startTeleportation() {
        List<ITeleport> links = TeleporterRegistry.getTeleporters();
        if (links != null && links.size() != 1) {
            for (ITeleport teleport : links) {
                TileEntityTeleporter tile = TeleporterRegistry.getTile(teleport);
                if (tile == null) {
                    TeleporterRegistry.removeTeleporter(teleport);
                    return;
                }
                if (tile.teleporterID != 0 && tile.teleporterID == this.linkID) {
                    if (TeleporterHelper.canTeleport(tile, this) && this.canTeleportPlayer() && tile.canTeleportPlayer()) {
                        this.passwordMatch = true;
                        TeleporterHelper.travelToDimension(this.getPlayerList(), tile);
                        this.updateDimensionName((String)tile.name.getObject());
                        continue;
                    }
                    this.passwordMatch = false;
                    continue;
                }
                if (tile.teleporterID != 0) continue;
                tile.resetFrequency();
            }
        } else {
            this.passwordMatch = false;
        }
    }

    public void updateDimensionName(String name) {
        if (!((String)this.destinationName.getObject()).equals(name)) {
            this.destinationName.setObject((Object)name);
            SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
        }
    }

    public boolean canTeleportPlayer() {
        boolean flag = true;
        for (int i = 1; i < 3; ++i) {
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.DOWN, i)).func_177230_c();
            if (block == Blocks.field_150350_a || block == null) continue;
            flag = false;
        }
        EnumFacing[] dirs = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
        int stable = 0;
        for (EnumFacing dir : dirs) {
            int blocks = 0;
            for (int j = 0; j < 3; ++j) {
                Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(dir.func_82601_c(), -j, dir.func_82599_e())).func_177230_c();
                if (!(block instanceof StableStone)) continue;
                ++blocks;
            }
            if (blocks != 3) continue;
            blocks = 0;
            ++stable;
        }
        return stable >= 3 && flag && this.field_174879_c.func_177956_o() - 2 > 0;
    }

    public List<EntityPlayer> getPlayerList() {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)(this.field_174879_c.func_177956_o() - 2), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() - 1), (double)(this.field_174879_c.func_177952_p() + 1));
        return this.field_145850_b.func_175647_a(EntityPlayer.class, aabb, null);
    }

    public void resetFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
            this.addToFrequency();
        }
    }

    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.teleporterID == 0) {
                this.teleporterID = TeleporterRegistry.nextID();
            }
            TeleporterRegistry.addTeleporter(this);
        }
    }

    public void removeFromFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            TeleporterRegistry.removeTeleporter(this);
        }
    }

    public void setFrequency(int freq) {
        this.removeFromFrequency();
        this.teleporterID = freq;
        this.addToFrequency();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.teleporterID = nbt.func_74762_e("freq");
            this.linkID = nbt.func_74762_e("linkID");
            this.coolDown = nbt.func_74767_n("coolDown");
            this.passwordMatch = nbt.func_74767_n("passwordMatch");
            this.coolDownTicks = nbt.func_74762_e("coolDownTicks");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            nbt.func_74768_a("freq", this.teleporterID);
            nbt.func_74768_a("linkID", this.linkID);
            nbt.func_74757_a("coolDown", this.coolDown);
            nbt.func_74757_a("passwordMatch", this.passwordMatch);
            nbt.func_74768_a("coolDownTicks", this.coolDownTicks);
        }
        return nbt;
    }

    public void onChunkUnload() {
        this.removeFromFrequency();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            this.addToFrequency();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add("Link Name: " + this.name);
        if (!((String)this.destinationName.getObject()).equals("DESTINATION")) {
            currenttip.add("Destination: " + (String)this.destinationName.getObject());
        }
        return currenttip;
    }

    @Override
    public int teleporterID() {
        return this.teleporterID;
    }

    @Override
    public String name() {
        return (String)this.name.getObject();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeInt(this.linkID);
                break;
            }
            case 1: {
                this.name.writeToBuf(buf);
                break;
            }
            case 2: {
                this.password.writeToBuf(buf);
                break;
            }
            case 3: {
                this.linkPassword.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.removeFromFrequency();
                this.linkID = buf.readInt();
                this.addToFrequency();
                break;
            }
            case 1: {
                this.name.readFromBuf(buf);
                break;
            }
            case 2: {
                this.password.readFromBuf(buf);
                break;
            }
            case 3: {
                this.linkPassword.readFromBuf(buf);
            }
        }
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerEmpty(player.field_71071_by, (TileEntitySonar)this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiTeleporter(player.field_71071_by, this);
    }
}

