/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.calculator.mod.api.items.IModuleProvider;
import sonar.core.SonarCore;
import sonar.core.api.SonarAPI;
import sonar.core.api.utils.ActionType;

public class PacketJumpModule
implements IMessage {
    public BlockPos pos;

    public PacketJumpModule() {
    }

    public PacketJumpModule(BlockPos pos) {
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<PacketJumpModule, IMessage> {
        public IMessage onMessage(PacketJumpModule message, MessageContext ctx) {
            EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
            if (player != null && ctx.side == Side.SERVER) {
                ItemStack held = player.func_184614_ca();
                if (message.pos.func_177956_o() <= 0) {
                    return null;
                }
                if (!held.func_190926_b() && held.func_77973_b() instanceof IModuleProvider && SonarAPI.getEnergyHelper().canTransferEnergy(held) != null) {
                    long maxRemove = SonarAPI.getEnergyHelper().extractEnergy(held, 1000L, ActionType.SIMULATE);
                    if (player.field_71075_bZ.field_75098_d || maxRemove >= 1000L) {
                        player.func_70634_a((double)message.pos.func_177958_n() + 0.5, (double)(message.pos.func_177956_o() + 1), (double)message.pos.func_177952_p() + 0.5);
                        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 0.5f, 0.8f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            SonarAPI.getEnergyHelper().extractEnergy(held, 1000L, ActionType.PERFORM);
                        }
                        return new PacketJumpModule(message.pos);
                    }
                }
            } else if (player != null && ctx.side == Side.CLIENT) {
                Random rand = new Random();
                for (int i = 0; i < 32; ++i) {
                    player.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u + rand.nextDouble() * 2.0, player.field_70161_v, rand.nextGaussian(), 0.0, rand.nextGaussian(), new int[0]);
                }
            }
            return null;
        }
    }
}

