/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.entity;

import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.core.ChunkLoadHandler;
import me.ichun.mods.portalgun.common.core.SoundIndex;
import me.ichun.mods.portalgun.common.portal.PortalGunHelper;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPortalProjectile
extends Entity {
    private static final DataParameter<Integer> COLOUR = EntityDataManager.func_187226_a(EntityPortalProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHOOTER = EntityDataManager.func_187226_a(EntityPortalProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DISTANCE = EntityDataManager.func_187226_a(EntityPortalProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Rotations> SPAWN_POS = EntityDataManager.func_187226_a(EntityPortalProjectile.class, (DataSerializer)DataSerializers.field_187199_i);
    private static final DataParameter<Rotations> VELOCITY = EntityDataManager.func_187226_a(EntityPortalProjectile.class, (DataSerializer)DataSerializers.field_187199_i);
    public double startX;
    public double startY;
    public double startZ;
    public int age;
    public int portalWidth;
    public int portalHeight;
    public PortalInfo portalInfo;
    public EntityLivingBase shooter;

    public EntityPortalProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.3f);
        this.portalWidth = 1;
        this.portalHeight = 2;
        this.portalInfo = null;
    }

    public EntityPortalProjectile(World worldIn, Entity shooter, int width, int height, PortalInfo info, int distance) {
        this(worldIn);
        if (shooter instanceof EntityLivingBase) {
            this.func_184212_Q().func_187227_b(SHOOTER, (Object)shooter.func_145782_y());
            this.shooter = (EntityLivingBase)shooter;
        }
        this.portalWidth = width;
        this.portalHeight = height;
        this.portalInfo = info;
        this.func_184212_Q().func_187227_b(COLOUR, (Object)this.portalInfo.colour);
        this.func_184212_Q().func_187227_b(DISTANCE, (Object)distance);
        Vec3d location = EntityHelper.getEntityPositionEyes((Entity)shooter, (float)1.0f);
        Vec3d look = shooter.func_70676_i(1.0f).func_72432_b();
        this.func_70012_b(location.field_72450_a, location.field_72448_b, location.field_72449_c, shooter.field_70177_z, 0.0f);
        double velo = 4.98 + Math.random() * 0.02;
        EntityHelper.setVelocity((Entity)this, (double)(look.field_72450_a * velo), (double)(look.field_72448_b * velo), (double)(look.field_72449_c * velo));
        this.func_184212_Q().func_187227_b(SPAWN_POS, (Object)new Rotations((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        this.func_184212_Q().func_187227_b(VELOCITY, (Object)new Rotations((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y));
    }

    public void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOUR, (Object)0xFFFFFF);
        this.func_184212_Q().func_187214_a(SHOOTER, (Object)-1);
        this.func_184212_Q().func_187214_a(DISTANCE, (Object)10000);
        this.func_184212_Q().func_187214_a(SPAWN_POS, (Object)new Rotations(0.0f, -100000.0f, 0.0f));
        this.func_184212_Q().func_187214_a(VELOCITY, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    public void setColour(int i) {
        this.func_184212_Q().func_187227_b(COLOUR, (Object)i);
    }

    public int getColour() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOUR);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 20.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityPortalProjectile.func_184183_bd()) * d0;
    }

    public void func_70071_h_() {
        Vec3d vec3;
        Vec3d vec31;
        RayTraceResult mop;
        super.func_70071_h_();
        if ((double)this.age > (double)PortalGun.config.maxShootDistance / 5.0 + 10.0 || this.func_70011_f(this.startX, this.startY, this.startZ) > (double)(PortalGun.config.maxShootDistance + 5) || this.field_70163_u < -25.0 || this.field_70163_u + 25.0 > (double)this.field_70170_p.func_72800_K()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.age == 0) {
                this.func_70012_b(((Rotations)this.func_184212_Q().func_187225_a(SPAWN_POS)).func_179415_b(), ((Rotations)this.func_184212_Q().func_187225_a(SPAWN_POS)).func_179416_c(), ((Rotations)this.func_184212_Q().func_187225_a(SPAWN_POS)).func_179413_d(), this.field_70177_z, this.field_70125_A);
                this.field_70159_w = ((Rotations)this.func_184212_Q().func_187225_a(VELOCITY)).func_179415_b();
                this.field_70181_x = ((Rotations)this.func_184212_Q().func_187225_a(VELOCITY)).func_179416_c();
                this.field_70179_y = ((Rotations)this.func_184212_Q().func_187225_a(VELOCITY)).func_179413_d();
            }
            if (this.shooter == null && (Integer)this.func_184212_Q().func_187225_a(SHOOTER) >= 0) {
                Entity ent = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(SHOOTER)).intValue());
                if (ent instanceof EntityLivingBase) {
                    this.shooter = (EntityLivingBase)ent;
                } else {
                    this.func_184212_Q().func_187227_b(SHOOTER, (Object)-1);
                }
            }
        }
        if ((mop = EntityHelper.rayTraceBlocks((World)this.field_70170_p, (double)5.0, (Vec3d)(vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)), (Vec3d)(vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y)), (PortalGun.config.canFireThroughLiquid == 0 ? 1 : 0) != 0, (boolean)false, (boolean)true, (boolean)false)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = mop.func_178782_a();
            IBlockState iblockstate1 = this.field_70170_p.func_180495_p(pos);
            Block block = iblockstate1.func_177230_c();
            if (iblockstate1.func_185904_a() != Material.field_151579_a) {
                block.func_180634_a(this.field_70170_p, pos, iblockstate1, (Entity)this);
            }
            if (iblockstate1.func_185904_a() == Material.field_151592_s && PortalGun.config.canFireThroughGlass == 1) {
                this.func_70107_b(mop.field_72307_f.field_72450_a - this.field_70159_w * (double)0.98f, mop.field_72307_f.field_72448_b - this.field_70181_x * (double)0.98f, mop.field_72307_f.field_72449_c - this.field_70179_y * (double)0.98f);
            } else {
                Vec3d lookDir = new Vec3d(EnumFacing.func_176733_a((double)this.field_70177_z).func_176730_m());
                EnumFacing lookEF = EnumFacing.func_176737_a((float)((float)lookDir.field_72450_a), (float)0.0f, (float)((float)lookDir.field_72449_c));
                if (!this.field_70170_p.field_72995_K) {
                    if (PortalGunHelper.spawnPortal(this.field_70170_p, pos, mop.field_178784_b, lookEF, this.portalInfo, this.portalWidth, this.portalHeight, PortalGun.config.canPortalsResizeWhenCreated == 1)) {
                        if (this.shooter != null) {
                            ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)this.shooter);
                            if (is.func_77978_p() != null) {
                                NBTTagCompound tag = is.func_77978_p();
                                tag.func_74757_a("lastFired", this.portalInfo.isTypeA);
                                if (this.shooter instanceof EntityPlayer) {
                                    ((EntityPlayer)this.shooter).field_71071_by.func_70296_d();
                                } else {
                                    this.shooter.func_184201_a(this.shooter.func_184586_b(EnumHand.MAIN_HAND) == is ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, is);
                                }
                            }
                            EntityHelper.playSoundAtEntity((Entity)this.shooter, (SoundEvent)(this.portalInfo.isTypeA ? SoundIndex.p_portal_open_blue : SoundIndex.p_portal_open_red), (SoundCategory)this.shooter.func_184176_by(), (float)0.2f, (float)(1.0f + (this.shooter.func_70681_au().nextFloat() - this.shooter.func_70681_au().nextFloat()) * 0.1f));
                        }
                    } else {
                        if (this.shooter != null) {
                            EntityHelper.playSoundAtEntity((Entity)this.shooter, (SoundEvent)SoundIndex.pg_portal_invalid_surface_swt, (SoundCategory)this.shooter.func_184176_by(), (float)0.2f, (float)(1.0f + (this.shooter.func_70681_au().nextFloat() - this.shooter.func_70681_au().nextFloat()) * 0.1f));
                        }
                        EntityHelper.playSoundAtEntity((Entity)this, (SoundEvent)SoundIndex.p_portal_invalid_surface, (SoundCategory)SoundCategory.BLOCKS, (float)0.4f, (float)(1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f));
                    }
                }
                this.func_70106_y();
                return;
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if (this.func_70090_H()) {
            for (int i1 = 0; i1 < 4; ++i1) {
                float f8 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f8, this.field_70163_u - this.field_70181_x * (double)f8, this.field_70161_v - this.field_70179_y * (double)f8, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
        ++this.age;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            ChunkLoadHandler.removeTicket(this);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.setColour(tag.func_74762_e("colour"));
        this.portalWidth = tag.func_74762_e("portalWidth");
        this.portalHeight = tag.func_74762_e("portalHeight");
        this.portalInfo = new PortalInfo().readFromNBT(tag.func_74775_l("portalInfo"));
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("colour", this.getColour());
        tag.func_74768_a("portalWidth", this.portalWidth);
        tag.func_74768_a("portalHeight", this.portalHeight);
        tag.func_74782_a("portalInfo", (NBTBase)this.portalInfo.writeToNBT(new NBTTagCompound()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

