/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.SourceProductMapping;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.client.gui.GuiReactorAccessPort;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.ItemHandlerWrapper;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.data.StandardReactants;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerReactorAccessPort;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.item.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityReactorAccessPort
extends TileEntityReactorPart
implements IInputOutputPort {
    protected TileEntityItemStackHandler _fuelInventory;
    protected TileEntityItemStackHandler _wasteInventory;
    protected IItemHandler _fuelInventoryWrapper = null;
    protected IItemHandler _wasteInventoryWrapper = null;
    protected IInputOutputPort.Direction _direction = IInputOutputPort.Direction.Input;

    public TileEntityReactorAccessPort() {
        this._fuelInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
        this._wasteInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
    }

    public ItemStackHandler getItemStackHandler(boolean fuel) {
        return fuel ? this._fuelInventory : this._wasteInventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return null != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability) {
            if (IInputOutputPort.Direction.Input == this._direction) {
                if (null == this._fuelInventoryWrapper) {
                    this._fuelInventoryWrapper = new ItemHandlerWrapper(this._fuelInventory){

                        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                            return ItemHelper.stackIsValid((ItemStack)stack) && Reactants.isFuel(stack) ? this._handler.insertItem(slot, stack, simulate) : stack;
                        }
                    };
                }
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this._fuelInventoryWrapper);
            }
            if (null == this._wasteInventoryWrapper) {
                this._wasteInventoryWrapper = new ItemHandlerWrapper(this._wasteInventory){

                    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                        return stack;
                    }
                };
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this._wasteInventoryWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return true;
    }

    public String getInputReactantType() {
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = ItemHelper.stackIsValid((ItemStack)inputItem) ? Reactants.getSolidToReactant(inputItem) : null;
        return null != mapping ? mapping.getProduct() : null;
    }

    public int getInputReactantAmount() {
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = ItemHelper.stackIsValid((ItemStack)inputItem) ? Reactants.getSolidToReactant(inputItem) : null;
        return null != mapping ? mapping.getProductAmount(ItemHelper.stackGetSize((ItemStack)inputItem)) : 0;
    }

    public int consumeReactantItem(int reactantDesired) {
        int sourceItemsToConsume;
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = ItemHelper.stackIsValid((ItemStack)inputItem) ? Reactants.getSolidToReactant(inputItem) : null;
        int n = sourceItemsToConsume = null != mapping ? Math.min(ItemHelper.stackGetSize((ItemStack)inputItem), mapping.getSourceAmount(reactantDesired)) : 0;
        if (sourceItemsToConsume <= 0) {
            return 0;
        }
        this._fuelInventory.extractItem(0, sourceItemsToConsume, false);
        return mapping.getProductAmount(sourceItemsToConsume);
    }

    public int emitReactant(String reactantType, int amount) {
        int itemsToProduce;
        int outputItemMaxSize;
        if (reactantType == null || amount <= 0) {
            return 0;
        }
        ItemStack outputItem = this._wasteInventory.getStackInSlot(0);
        boolean outputItemValid = ItemHelper.stackIsValid((ItemStack)outputItem);
        int n = outputItemMaxSize = outputItemValid ? outputItem.func_77976_d() : 64;
        if (outputItemValid && ItemHelper.stackGetSize((ItemStack)outputItem) >= outputItemMaxSize) {
            return 0;
        }
        if (outputItemValid) {
            OreDictToReactantMapping mapping = Reactants.getSolidToReactant(outputItem);
            if (mapping == null || !reactantType.equals(mapping.getProduct())) {
                return 0;
            }
            int amtToProduce = mapping.getSourceAmount(amount);
            if ((amtToProduce = Math.min(amtToProduce, outputItemMaxSize - ItemHelper.stackGetSize((ItemStack)outputItem))) <= 0) {
                return 0;
            }
            int reactantToConsume = mapping.getProductAmount(amtToProduce);
            if (reactantToConsume <= 0) {
                return 0;
            }
            ItemHelper.stackAdd((ItemStack)outputItem, (int)amtToProduce);
            this.onItemsReceived();
            return reactantToConsume;
        }
        SourceProductMapping bestMapping = null;
        List<SourceProductMapping> mappings = Reactants.getReactantToSolids(reactantType);
        if (mappings != null) {
            int bestReactantAmount = 0;
            for (SourceProductMapping mapping : mappings) {
                int potentialProducts = mapping.getProductAmount(amount);
                int potentialReactant = mapping.getSourceAmount(potentialProducts);
                if (bestMapping != null && bestReactantAmount >= potentialReactant) continue;
                bestMapping = mapping;
                bestReactantAmount = potentialReactant;
            }
        }
        if (bestMapping == null) {
            BRLog.warning("There are no mapped item types for reactant %s. Using cyanite instead.", reactantType);
            bestMapping = StandardReactants.cyaniteMapping;
        }
        if ((itemsToProduce = Math.min(bestMapping.getProductAmount(amount), outputItemMaxSize)) <= 0) {
            return 0;
        }
        int reactantConsumed = bestMapping.getSourceAmount(itemsToProduce);
        itemsToProduce = bestMapping.getProductAmount(reactantConsumed);
        ItemStack newItem = OreDictionaryHelper.getOre((String)bestMapping.getProduct());
        if (ItemHelper.stackIsEmpty((ItemStack)newItem)) {
            BRLog.warning("Could not find item for oredict entry %s, using cyanite instead.", bestMapping.getSource());
            newItem = BrItems.ingotMetals.createItemStack(MetalType.Cyanite, 1);
        } else {
            newItem = ItemHelper.stackFrom((ItemStack)newItem);
        }
        ItemHelper.stackSetSize((ItemStack)newItem, (int)itemsToProduce);
        this._wasteInventory.setStackInSlot(0, newItem);
        this.onItemsReceived();
        return reactantConsumed;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this._direction = IInputOutputPort.Direction.from(!data.func_74764_b("isInlet") || data.func_74767_n("isInlet"));
            if (data.func_74764_b("invI")) {
                this._fuelInventory.deserializeNBT((NBTTagCompound)data.func_74781_a("invI"));
            }
            if (data.func_74764_b("invO")) {
                this._wasteInventory.deserializeNBT((NBTTagCompound)data.func_74781_a("invO"));
            }
        } else if (data.func_74764_b("inlet")) {
            this.setDirection(IInputOutputPort.Direction.from(data.func_74767_n("inlet")), true);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            data.func_74757_a("isInlet", IInputOutputPort.Direction.Input == this._direction);
            data.func_74782_a("invI", (NBTBase)this._fuelInventory.serializeNBT());
            data.func_74782_a("invO", (NBTBase)this._wasteInventory.serializeNBT());
        } else {
            data.func_74757_a("inlet", IInputOutputPort.Direction.Input == this._direction);
        }
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return new ContainerReactorAccessPort(this, player.field_71071_by);
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return new GuiReactorAccessPort(new ContainerReactorAccessPort(this, player.field_71071_by), this);
    }

    public void onItemsReceived() {
        this.distributeItems();
        this.markChunkDirty();
    }

    @Override
    public IInputOutputPort.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setDirection(IInputOutputPort.Direction direction, boolean markForUpdate) {
        if (direction == this._direction) {
            return;
        }
        World world = this.func_145831_w();
        this._direction = direction;
        WorldHelper.notifyBlockUpdate((World)world, (BlockPos)this.getWorldPosition(), null, null);
        if (!world.field_72995_K) {
            this.distributeItems();
            this.func_70296_d();
        }
        this.notifyNeighborsOfTileChange();
    }

    @Override
    public void toggleDirection(boolean markForUpdate) {
        this.setDirection(this._direction.opposite(), markForUpdate);
    }

    protected void distributeItems() {
        IItemHandler adjacentInventory;
        World world = this.func_145831_w();
        EnumFacing facing = this.getOutwardFacing();
        if (WorldHelper.calledByLogicalClient((World)world) || null == facing || this.getDirection().isInput()) {
            return;
        }
        TileEntity te = world.func_175625_s(this.getWorldPosition().func_177972_a(facing));
        EnumFacing targetFacing = facing.func_176734_d();
        if (null != te && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetFacing) && null != (adjacentInventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetFacing))) {
            this._wasteInventory.setStackInSlot(0, ItemHandlerHelper.insertItem((IItemHandler)adjacentInventory, (ItemStack)this._wasteInventory.getStackInSlot(0), (boolean)false));
            this.markChunkDirty();
        }
    }
}

