/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.compat.CompatManager;
import erogenousbeef.bigreactors.common.multiblock.computer.TurbineComputer;
import erogenousbeef.bigreactors.common.multiblock.computer.TurbineComputerCC;
import erogenousbeef.bigreactors.common.multiblock.computer.TurbineComputerOC;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart", modid="opencomputers")})
public class TileEntityTurbineComputerPort
extends TileEntityTurbinePart {
    private final TurbineComputer _ccComputer = CompatManager.isModLoaded("computercraft") ? TurbineComputerCC.create(this) : null;
    private final TurbineComputer _ocComputer = CompatManager.isModLoaded("opencomputers") ? TurbineComputerOC.create(this) : null;

    @Optional.Method(modid="opencomputers")
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return null != this._ocComputer && TurbineComputerOC.isComputerCapability(capability) || super.hasCapability(capability, facing);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (null != this._ocComputer && TurbineComputerOC.isComputerCapability(capability)) {
            return (T)this._ocComputer;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="computercraft")
    public TurbineComputer getComputerCraftPeripheral() {
        return this._ccComputer;
    }

    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        if (null != this._ccComputer) {
            this._ccComputer.onAttachedToController();
        }
        if (null != this._ocComputer) {
            this._ocComputer.onAttachedToController();
        }
    }

    public void onDetached(MultiblockControllerBase oldController) {
        super.onDetached(oldController);
        if (null != this._ccComputer) {
            this._ccComputer.onDetachedFromController();
        }
        if (null != this._ocComputer) {
            this._ocComputer.onDetachedFromController();
        }
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (null != this._ccComputer) {
            this._ccComputer.syncDataFrom(data, syncReason);
        }
        if (null != this._ocComputer) {
            this._ocComputer.syncDataFrom(data, syncReason);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (null != this._ccComputer) {
            this._ccComputer.syncDataTo(data, syncReason);
        }
        if (null != this._ocComputer) {
            this._ocComputer.syncDataTo(data, syncReason);
        }
    }
}

