/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.ReflectionExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelIllager;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelVex;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;

public class LayerChiseledArmor
implements LayerRenderer<EntityLivingBase> {
    private final Map<NBTTagCompound, Integer[]> movingPartsDisplayListsMap = new HashMap<NBTTagCompound, Integer[]>();
    private final ModelRenderer head;
    private final ModelRenderer body;
    private final ModelRenderer villagerArms;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;
    private final ModelBase model;
    private boolean smallArms;
    private boolean isVindicator;
    private boolean isVex;

    public LayerChiseledArmor(RenderLivingBase<? extends EntityLivingBase> livingEntityRenderer) {
        this.model = livingEntityRenderer.func_177087_b();
        if (this.model instanceof ModelVillager) {
            ModelVillager modelVillager = (ModelVillager)this.model;
            this.head = modelVillager.field_78191_a;
            this.body = modelVillager.field_78189_b;
            this.rightLeg = modelVillager.field_78187_d;
            this.leftLeg = modelVillager.field_78188_e;
            this.villagerArms = modelVillager.field_78190_c;
        } else if (this.model instanceof ModelIllager) {
            ModelIllager modelVillager = (ModelIllager)this.model;
            this.head = modelVillager.field_191217_a;
            this.body = modelVillager.field_191218_b;
            this.rightLeg = modelVillager.field_191220_d;
            this.leftLeg = modelVillager.field_191221_e;
            this.villagerArms = modelVillager.field_191219_c;
            this.isVindicator = true;
        } else {
            ModelBiped modelBiped = (ModelBiped)this.model;
            this.head = modelBiped.field_78116_c;
            this.body = modelBiped.field_78115_e;
            this.rightLeg = modelBiped.field_178721_j;
            this.leftLeg = modelBiped.field_178722_k;
            this.villagerArms = null;
            if (this.model instanceof ModelPlayer) {
                this.smallArms = ReflectionExtraBitManipulation.areArmsSmall((ModelPlayer)this.model);
            }
            this.isVex = this.model instanceof ModelVex;
        }
    }

    public void clearDisplayListsMap() {
        for (Integer[] displayLists : this.movingPartsDisplayListsMap.values()) {
            this.deleteDisplayLists(displayLists);
        }
        this.movingPartsDisplayListsMap.clear();
    }

    public void removeFromDisplayListsMap(NBTTagCompound nbt) {
        this.deleteDisplayLists(this.movingPartsDisplayListsMap.remove(nbt));
    }

    private void deleteDisplayLists(Integer[] displayLists) {
        if (displayLists != null) {
            for (Integer displayList : displayLists) {
                GLAllocation.func_74523_b((int)displayList);
            }
        }
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientHelper.bindTexture(TextureMap.field_110575_b);
        IChiseledArmorSlotsHandler cap = entity instanceof EntityPlayer ? ChiseledArmorSlotsHandler.getCapability((EntityPlayer)entity) : null;
        Integer[] displayListsHelmet = this.getStackDisplayLists(entity, scale, EntityEquipmentSlot.HEAD, ItemChiseledArmor.ArmorType.HELMET);
        Integer[] displayListsSlotHelmet = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.HELMET);
        if (displayListsHelmet != null || displayListsSlotHelmet != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            if (entity.func_70631_g_() && !(entity instanceof EntityVillager)) {
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.head.func_78794_c(scale);
            GlStateManager.func_179109_b((float)0.0f, (float)(-scale * (8.0f + Configs.armorZFightingBufferScale)), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (entity instanceof EntityVillager || entity instanceof EntityZombieVillager || entity instanceof EntityVindicator) {
                GlStateManager.func_179109_b((float)0.0f, (float)(scale * 2.0f), (float)0.0f);
            }
            GlStateManager.func_179094_E();
            if (displayListsHelmet != null) {
                GlStateManager.func_179148_o((int)displayListsHelmet[0]);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotHelmet != null) {
                GlStateManager.func_179148_o((int)displayListsSlotHelmet[0]);
            }
            GlStateManager.func_179121_F();
        }
        Integer[] displayListsChestplate = this.getStackDisplayLists(entity, scale, EntityEquipmentSlot.CHEST, ItemChiseledArmor.ArmorType.CHESTPLATE);
        Integer[] displayListsSlotChestplate = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.CHESTPLATE);
        if (displayListsChestplate != null || displayListsSlotChestplate != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            boolean isPassive = !this.isVindicator || !((EntityVindicator)entity).func_190639_o();
            GlStateManager.func_179094_E();
            if (displayListsChestplate != null) {
                this.renderArmorPiece(this.body, displayListsChestplate[0], scale, 8.0f);
                this.renderSleeve(displayListsChestplate[1], EnumHandSide.RIGHT, scale, isPassive);
                this.renderSleeve(displayListsChestplate[2], EnumHandSide.LEFT, scale, isPassive);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotChestplate != null) {
                this.renderArmorPiece(this.body, displayListsSlotChestplate[0], scale, 8.0f);
                this.renderSleeve(displayListsSlotChestplate[1], EnumHandSide.RIGHT, scale, isPassive);
                this.renderSleeve(displayListsSlotChestplate[2], EnumHandSide.LEFT, scale, isPassive);
            }
            GlStateManager.func_179121_F();
        }
        Integer[] displayListsLeggings = this.getStackDisplayLists(entity, scale, EntityEquipmentSlot.LEGS, ItemChiseledArmor.ArmorType.LEGGINGS);
        Integer[] displayListsSlotLeggings = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.LEGGINGS);
        if (displayListsLeggings != null || displayListsSlotLeggings != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            GlStateManager.func_179094_E();
            if (displayListsLeggings != null) {
                this.renderArmorPiece(this.body, displayListsLeggings[0], scale, 4.0f);
                this.renderLegPieces(displayListsLeggings[1], displayListsLeggings[2], scale, 8.0f);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotLeggings != null) {
                this.renderArmorPiece(this.body, displayListsSlotLeggings[0], scale, 4.0f);
                this.renderLegPieces(displayListsSlotLeggings[1], displayListsSlotLeggings[2], scale, 8.0f);
            }
            GlStateManager.func_179121_F();
        }
        Integer[] displayListsBoots = this.getStackDisplayLists(entity, scale, EntityEquipmentSlot.FEET, ItemChiseledArmor.ArmorType.BOOTS);
        Integer[] displayListsSlotBoots = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.BOOTS);
        if (displayListsBoots != null || displayListsSlotBoots != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            GlStateManager.func_179109_b((float)0.0f, (float)(scale * Configs.armorZFightingBufferTranslationFeet), (float)0.0f);
            GlStateManager.func_179094_E();
            if (displayListsBoots != null) {
                this.renderLegPieces(displayListsBoots[0], displayListsBoots[1], scale, 4.0f);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotBoots != null) {
                this.renderLegPieces(displayListsSlotBoots[0], displayListsSlotBoots[1], scale, 4.0f);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
    }

    private Integer[] getStackDisplayLists(EntityLivingBase entity, float scale, EntityEquipmentSlot slot, ItemChiseledArmor.ArmorType armorType) {
        return this.getDisplayLists(entity, scale, armorType, entity.func_184582_a(slot));
    }

    private Integer[] getSlotStackDisplayLists(EntityLivingBase entity, float scale, IChiseledArmorSlotsHandler cap, ItemChiseledArmor.ArmorType armorType) {
        return cap == null ? null : this.getDisplayLists(entity, scale, armorType, cap.getStackInSlot(armorType.ordinal()));
    }

    private Integer[] getDisplayLists(EntityLivingBase entity, float scale, ItemChiseledArmor.ArmorType armorType, ItemStack stack) {
        NBTTagCompound nbt;
        Integer[] displayLists = null;
        if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemChiseledArmor && (displayLists = this.movingPartsDisplayListsMap.get(ItemStackHelper.getArmorData(nbt = stack.func_77978_p()))) == null) {
            displayLists = this.addMovingPartsDisplayListsToMap(entity, scale, nbt, armorType);
        }
        return displayLists;
    }

    private void adjustForSneaking(EntityLivingBase entity) {
        if (entity.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
    }

    private void adjustForChildModel() {
        if (this.model.field_78091_s) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    private Integer[] addMovingPartsDisplayListsToMap(EntityLivingBase entity, float scale, NBTTagCompound armorNbt, ItemChiseledArmor.ArmorType armorType) {
        Integer[] movingPartsDisplayLists = new Integer[armorType.getMovingpartCount()];
        for (int i = 0; i < movingPartsDisplayLists.length; ++i) {
            movingPartsDisplayLists[i] = new DataChiseledArmorPiece(armorNbt, armorType).generateDisplayList(i, entity, scale);
        }
        this.movingPartsDisplayListsMap.put(ItemStackHelper.getArmorData(armorNbt), movingPartsDisplayLists);
        return movingPartsDisplayLists;
    }

    private void renderLegPieces(int displayListRight, int displayListLeft, float scale, float offsetY) {
        this.renderArmorPiece(this.rightLeg, displayListRight, scale, this.isVex ? -scale * 2.0f : 0.0f, offsetY);
        if (!this.isVex) {
            this.renderArmorPiece(this.leftLeg, displayListLeft, scale, offsetY);
        }
    }

    private void renderArmorPiece(ModelRenderer modelArmorPiece, int displayList, float scale, float offsetX, float offsetY) {
        GlStateManager.func_179094_E();
        modelArmorPiece.func_78794_c(scale);
        this.renderArmorPiece(displayList, scale, offsetX, offsetY);
    }

    private void renderArmorPiece(ModelRenderer modelArmorPiece, int displayList, float scale, float offsetY) {
        this.renderArmorPiece(modelArmorPiece, displayList, scale, 0.0f, offsetY);
    }

    private void renderArmorPiece(int displayList, float scale, float offsetX, float offsetY) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)offsetX, (float)(-scale * offsetY), (float)0.0f);
        GlStateManager.func_179148_o((int)displayList);
        GlStateManager.func_179121_F();
    }

    private void renderSleeve(int displayList, EnumHandSide handSide, float scale, boolean isPassive) {
        int armOffset;
        GlStateManager.func_179094_E();
        if (this.villagerArms != null && isPassive) {
            this.villagerArms.func_78794_c(scale);
            armOffset = 6;
        } else {
            if (this.smallArms) {
                ModelRenderer modelArm;
                ModelBiped modelBiped = (ModelBiped)this.model;
                float f = 0.5f;
                if (handSide == EnumHandSide.RIGHT) {
                    modelArm = modelBiped.field_178723_h;
                    f *= -1.0f;
                } else {
                    modelArm = modelBiped.field_178724_i;
                }
                modelArm.field_78800_c += f;
                modelBiped.func_187073_a(scale, handSide);
                modelArm.field_78800_c -= f;
            } else if (this.isVindicator) {
                ((ModelIllager)this.model).func_191216_a(handSide).func_78794_c(scale);
            } else {
                ((ModelBiped)this.model).func_187073_a(scale, handSide);
            }
            armOffset = 1;
        }
        this.renderArmorPiece(displayList, scale, (float)(handSide == EnumHandSide.LEFT ? -armOffset : armOffset) * scale, 6.0f);
    }

    public boolean func_177142_b() {
        return false;
    }
}

