/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.GuiBitToolSettingsMenu;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketSetWrechMode;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ButtonsSetting {
    protected List<GuiBitToolSettingsMenu.GuiButtonSetting> buttons = new ArrayList<GuiBitToolSettingsMenu.GuiButtonSetting>();

    public List<GuiBitToolSettingsMenu.GuiButtonSetting> getButtons() {
        return this.buttons;
    }

    public void addButton(GuiBitToolSettingsMenu.GuiButtonSetting button) {
        button.selected = this.buttons.size() == this.getValue();
        this.buttons.add(button);
    }

    public void initButtons() {
        for (GuiBitToolSettingsMenu.GuiButtonSetting button : this.buttons) {
            button.setButtonList(this.buttons);
        }
    }

    protected int getValue() {
        return 0;
    }

    protected abstract void setValue(EntityPlayer var1, int var2);

    public void setValueIfDiffrent() {
        int value = this.buttons.indexOf((Object)this.getTargetButton());
        if (value != this.getValue()) {
            this.setValue(ClientHelper.getPlayer(), value);
        }
    }

    protected GuiBitToolSettingsMenu.GuiButtonSetting getTargetButton() {
        GuiBitToolSettingsMenu.GuiButtonSetting buttonTarget = null;
        for (GuiBitToolSettingsMenu.GuiButtonSetting button : this.buttons) {
            if (!button.func_146115_a()) continue;
            buttonTarget = button;
        }
        if (buttonTarget == null) {
            for (GuiBitToolSettingsMenu.GuiButtonSetting button : this.buttons) {
                if (!button.selected) continue;
                buttonTarget = button;
            }
        }
        return buttonTarget;
    }

    protected NBTTagCompound getHeldStackNBT() {
        return ItemStackHelper.getNBTOrNew(ClientHelper.getHeldItemMainhand());
    }

    private static ItemSculptingTool getSculptingTool() {
        ItemStack stack = ClientHelper.getHeldItemMainhand();
        return stack.func_190926_b() ? null : (ItemSculptingTool)stack.func_77973_b();
    }

    private static ItemChiseledArmor getChiseledArmor() {
        ItemStack stack = ClientHelper.getHeldItemMainhand();
        return stack.func_190926_b() ? null : (ItemChiseledArmor)stack.func_77973_b();
    }

    public static class ArmorGridTarget
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.areArmorBitsTargeted(this.getHeldStackNBT()) ? 1 : 0;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setArmorBitsTargeted(player, player.func_184614_ca(), value == 1, Configs.armorTargetBits);
        }
    }

    public static class ArmorMovingPart
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            ItemChiseledArmor armorPiece = ButtonsSetting.getChiseledArmor();
            if (armorPiece == null) {
                return 0;
            }
            return BitToolSettingsHelper.getArmorMovingPart(this.getHeldStackNBT(), armorPiece).getPartIndex();
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            ItemChiseledArmor armorPiece = ButtonsSetting.getChiseledArmor();
            if (armorPiece != null) {
                BitToolSettingsHelper.setArmorMovingPart(player, player.func_184614_ca(), armorPiece, value);
            }
        }
    }

    public static class ArmorScale
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getArmorScale(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setArmorScale(player, player.func_184614_ca(), value, Configs.armorScale);
        }
    }

    public static class ArmorMode
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getArmorMode(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setArmorMode(player, player.func_184614_ca(), value, Configs.armorMode);
        }
    }

    public static class OffsetShape
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.isShapeOffset(this.getHeldStackNBT()) ? 0 : 1;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setShapeOffset(player, player.func_184614_ca(), value == 0, Configs.sculptOffsetShape);
        }
    }

    public static class OpenEnds
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.areEndsOpen(this.getHeldStackNBT()) ? 0 : 1;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setEndsOpen(player, player.func_184614_ca(), value == 0, Configs.sculptOpenEnds);
        }
    }

    public static class HollowShape
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            ItemSculptingTool tool = ButtonsSetting.getSculptingTool();
            return tool == null ? 0 : (BitToolSettingsHelper.isHollowShape(this.getHeldStackNBT(), tool.removeBits()) ? 0 : 1);
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            ItemSculptingTool tool = ButtonsSetting.getSculptingTool();
            if (tool != null) {
                BitToolSettingsHelper.setHollowShape(player, player.func_184614_ca(), tool.removeBits(), value == 0, tool.removeBits() ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade);
            }
        }
    }

    public static class BitGridTargeted
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.isBitGridTargeted(this.getHeldStackNBT()) ? 1 : 0;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setBitGridTargeted(player, player.func_184614_ca(), value == 1, Configs.sculptTargetBitGridVertexes);
        }
    }

    public static class ShapeType
    extends ButtonsSetting {
        @Override
        public void setValueIfDiffrent() {
            ItemSculptingTool tool = ButtonsSetting.getSculptingTool();
            if (tool == null) {
                return;
            }
            int value = this.buttons.indexOf((Object)this.getTargetButton());
            if (!tool.isCurved()) {
                value = value * 3 + 3;
            }
            if (value != this.getValue()) {
                this.setValue(ClientHelper.getPlayer(), value);
            }
        }

        @Override
        protected int getValue() {
            ItemSculptingTool tool = ButtonsSetting.getSculptingTool();
            if (tool == null) {
                return 0;
            }
            int shapeType = BitToolSettingsHelper.getShapeType(this.getHeldStackNBT(), tool.isCurved());
            return tool.isCurved() ? shapeType : shapeType / 3 - 1;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            ItemSculptingTool tool = ButtonsSetting.getSculptingTool();
            if (tool != null) {
                BitToolSettingsHelper.setShapeType(player, player.func_184614_ca(), tool.isCurved(), value, tool.isCurved() ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat);
            }
        }
    }

    public static class Direction
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getDirection(this.getHeldStackNBT()) % 6;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setDirection(player, player.func_184614_ca(), value % 6, Configs.sculptDirection);
        }
    }

    public static class SculptMode
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getSculptMode(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setSculptMode(player, player.func_184614_ca(), value, Configs.sculptMode);
        }
    }

    public static class ModelGuiOpen
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getModelGuiOpen(this.getHeldStackNBT()) ? 0 : 1;
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setModelGuiOpen(player, player.func_184614_ca(), value == 0, Configs.modelGuiOpen);
        }
    }

    public static class ModelSnapMode
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getModelSnapMode(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setModelSnapMode(player, player.func_184614_ca(), value, Configs.modelSnapMode);
        }
    }

    public static class ModelAreaMode
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getModelAreaMode(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setModelAreaMode(player, player.func_184614_ca(), value, Configs.modelAreaMode);
        }
    }

    public static class WrenchMode
    extends ButtonsSetting {
        @Override
        protected int getValue() {
            return this.getHeldStackNBT().func_74762_e("wrenchMode");
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetWrechMode(value));
        }
    }
}

