/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import com.phylogeny.extrabitmanipulation.client.gui.GuiListBitMapping;
import com.phylogeny.extrabitmanipulation.client.gui.GuiListBitMappingEntry;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonBase;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonGradient;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonSelect;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonTab;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonTextured;
import com.phylogeny.extrabitmanipulation.client.render.RenderState;
import com.phylogeny.extrabitmanipulation.config.ConfigHandlerExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.SoundsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketAddBitMapping;
import com.phylogeny.extrabitmanipulation.packet.PacketBitMappingsPerTool;
import com.phylogeny.extrabitmanipulation.packet.PacketClearStackBitMappings;
import com.phylogeny.extrabitmanipulation.packet.PacketCursorStack;
import com.phylogeny.extrabitmanipulation.packet.PacketOverwriteStackBitMappings;
import com.phylogeny.extrabitmanipulation.packet.PacketSetDesign;
import com.phylogeny.extrabitmanipulation.packet.PacketSetTabAndStateBlockButton;
import com.phylogeny.extrabitmanipulation.proxy.ProxyCommon;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiBitMapping
extends GuiContainer {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("extrabitmanipulation", "textures/guis/modeling_tool.png");
    public static final ResourceLocation BOX_CHECKED = new ResourceLocation("extrabitmanipulation", "textures/guis/box_checked.png");
    public static final ResourceLocation BOX_UNCHECKED = new ResourceLocation("extrabitmanipulation", "textures/guis/box_unchecked.png");
    public static final ResourceLocation SETTINGS_MAIN = new ResourceLocation("extrabitmanipulation", "textures/guis/settings_main.png");
    public static final ResourceLocation SETTINGS_BACK = new ResourceLocation("extrabitmanipulation", "textures/guis/settings_back.png");
    private IChiselAndBitsAPI api;
    private GuiListBitMapping bitMappingList;
    private ItemStack previewStack;
    private ItemStack previewResultStack;
    private IBlockState[][][] stateArray;
    private Map<IBlockState, Integer> stateMap;
    private Map<IBlockState, ArrayList<ItemModelingTool.BitCount>> stateToBitCountArray;
    private Map<IBlockState, IBitBrush> stateToBitMapPermanent;
    private Map<IBlockState, IBitBrush> stateToBitMapManual;
    private Map<IBlockState, IBitBrush> blockToBitMapPermanent;
    private Map<IBlockState, IBitBrush> blockToBitMapManual;
    private Map<IBlockState, IBitBrush> blockToBitMapAllBlocks;
    private GuiButtonSelect buttonStates;
    private GuiButtonSelect buttonBlocks;
    private GuiButtonTextured buttonSettings;
    private GuiButtonTextured buttonBitMapPerTool;
    private GuiButtonGradient buttonOverwriteStackMapsWithConfig;
    private GuiButtonGradient buttonOverwriteConfigMapsWithStack;
    private GuiButtonGradient buttonRestoreConfigMaps;
    private GuiButtonGradient buttonClearStackMaps;
    private GuiButtonTab[] tabButtons = new GuiButtonTab[4];
    private static final String[] TAB_HOVER_TEXT = new String[]{"Current Model", "All Saved Mappings", "All Minecraft Blocks", "Model Result"};
    private int savedTab;
    private int mouseInitialX;
    private int mouseInitialY;
    private boolean stateMauallySelected;
    private boolean showSettings;
    private boolean bitMapPerTool;
    private boolean designMode;
    private boolean previewStackBoxClicked;
    private String searchText = "";
    private GuiTextField searchField;
    private float previewStackScale;
    private Vec3d previewStackRotation;
    private Vec3d previewStackTranslation;
    private Vec3d previewStackTranslationInitial;
    private AxisAlignedBB previewStackBox;

    public GuiBitMapping(EntityPlayer player, boolean designMode) {
        super((Container)ProxyCommon.createBitMappingContainer(player));
        this.designMode = designMode;
        this.api = ChiselsAndBitsAPIAccess.apiInstance;
        this.field_146999_f = 254;
        this.field_147000_g = 219;
        this.previewStackScale = 3.8f;
        this.previewStackRotation = new Vec3d(30.0, 225.0, 0.0);
        this.previewStackTranslation = Vec3d.field_186680_a;
        this.previewStackTranslationInitial = Vec3d.field_186680_a;
        if (designMode) {
            return;
        }
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(player.field_71071_by.func_70448_g());
        this.stateMauallySelected = nbt.func_74767_n("buttonStateBlockSetting");
        this.savedTab = nbt.func_74762_e("tabSetting");
        this.bitMapPerTool = nbt.func_74767_n("bitMapsPerTool");
        this.previewStack = this.previewResultStack = ItemStack.field_190927_a;
    }

    private void constructManualMaps() {
        this.stateToBitMapManual = new LinkedHashMap<IBlockState, IBitBrush>();
        this.blockToBitMapManual = new LinkedHashMap<IBlockState, IBitBrush>();
        this.blockToBitMapAllBlocks = new LinkedHashMap<IBlockState, IBitBrush>();
        if (this.stateMap.isEmpty()) {
            return;
        }
        if (!this.designMode && this.tabButtons[2].selected) {
            for (Block block : Block.field_149771_c) {
                ItemType itemType;
                Item item;
                ResourceLocation regName = block.getRegistryName();
                if (regName == null || regName.func_110624_b().equals("chiselsandbits") && (item = Item.func_150898_a((Block)block)) != Items.field_190931_a && (itemType = this.api.getItemType(new ItemStack(item))) != null && itemType == ItemType.CHISLED_BLOCK || BitIOHelper.isAir(block)) continue;
                IBlockState state = block.func_176223_P();
                this.addBitToManualMap(state.func_177230_c().func_176223_P(), this.blockToBitMapPermanent, this.blockToBitMapAllBlocks);
            }
            this.blockToBitMapAllBlocks = this.getSortedLinkedBitMap(this.blockToBitMapAllBlocks);
        }
        for (IBlockState state : this.stateMap.keySet()) {
            this.addBitToManualMap(state, this.stateToBitMapPermanent, this.stateToBitMapManual);
            if (this.designMode) continue;
            this.addBitToManualMap(state.func_177230_c().func_176223_P(), this.blockToBitMapPermanent, this.blockToBitMapManual);
        }
        this.stateToBitMapManual = this.getSortedLinkedBitMap(this.stateToBitMapManual);
        this.blockToBitMapManual = this.getSortedLinkedBitMap(this.blockToBitMapManual);
    }

    private void addBitToManualMap(IBlockState state, Map<IBlockState, IBitBrush> bitMapPermanent, Map<IBlockState, IBitBrush> bitMapManual) {
        IBitBrush bit = null;
        if (bitMapPermanent.containsKey(state)) {
            bit = bitMapPermanent.get(state);
        } else {
            try {
                bit = this.api.createBrushFromState(state);
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        bitMapManual.put(state, bit);
    }

    public void addPermanentMapping(IBlockState state, IBitBrush bit) {
        Map<IBlockState, IBitBrush> bitMapPermanent = this.getBitMapPermanent();
        if (bit != null) {
            bitMapPermanent.put(state, bit);
            Map<IBlockState, IBitBrush> blockToBitMap = this.getBitMapManual();
            if (blockToBitMap.containsKey(state)) {
                blockToBitMap.put(state, bit);
            }
        } else {
            bitMapPermanent.remove(state);
            this.constructManualMaps();
        }
        if (this.designMode) {
            this.refreshList();
            return;
        }
        if (this.bitMapPerTool) {
            String nbtKey = this.buttonStates.selected ? "stateToBitMapPermanent" : "blockToBitMapPermanent";
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketAddBitMapping(nbtKey, state, bit, Configs.saveStatesById));
        } else {
            Map<IBlockState, IBitBrush> bitMap;
            Map<IBlockState, IBitBrush> map = bitMap = this.buttonStates.selected ? Configs.modelStateToBitMap : Configs.modelBlockToBitMap;
            if (bit != null) {
                bitMap.put(state, bit);
            } else {
                bitMap.remove(state);
            }
            String[] entryStrings = BitIOHelper.getEntryStringsFromModelBitMap(bitMap);
            if (this.buttonStates.selected) {
                Configs.modelStateToBitMapEntryStrings = entryStrings;
            } else {
                Configs.modelBlockToBitMapEntryStrings = entryStrings;
            }
            BitToolSettingsHelper.setBitMapProperty(this.buttonStates.selected, entryStrings);
        }
        this.refreshList();
    }

    private void refreshList() {
        this.constructStateToBitCountArray();
        Map<IBlockState, IBitBrush> bitMapPermanent = this.getBitMapPermanent();
        this.bitMappingList.refreshList((Map<IBlockState, IBitBrush>)(this.designMode || this.tabButtons[0].selected || this.tabButtons[2].selected ? this.getBitMapManual() : (this.isResultsTabSelected() ? null : bitMapPermanent)), bitMapPermanent, this.isResultsTabSelected() ? this.stateToBitCountArray : null, this.searchField.func_146179_b(), this.designMode || this.buttonStates.selected);
        this.setPreviewStack();
        if (!this.designMode) {
            this.tabButtons[0].setIconStack(this.previewStack);
        }
    }

    private void constructStateToBitCountArray() {
        this.stateToBitCountArray = new LinkedHashMap<IBlockState, ArrayList<ItemModelingTool.BitCount>>();
        if (this.designMode) {
            for (Map.Entry<IBlockState, Integer> entry : this.stateMap.entrySet()) {
                ArrayList<ItemModelingTool.BitCount> bitCountArray = new ArrayList<ItemModelingTool.BitCount>();
                try {
                    bitCountArray.add(new ItemModelingTool.BitCount(this.api.createBrushFromState(entry.getKey()), entry.getValue()));
                    this.stateToBitCountArray.put(entry.getKey(), bitCountArray);
                }
                catch (APIExceptions.InvalidBitItem invalidBitItem) {}
            }
            return;
        }
        HashMap<IBitBrush, Integer> bitMap = new HashMap<IBitBrush, Integer>();
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        ItemModelingTool itemModelingTool = (ItemModelingTool)this.getHeldStack().func_77973_b();
        if (itemModelingTool.mapBitsToStates(this.api, Configs.replacementBitsUnchiselable, Configs.replacementBitsInsufficient, BitInventoryHelper.getInventoryBitCounts(this.api, (EntityPlayer)player), this.stateMap, this.stateToBitCountArray, this.stateToBitMapPermanent, this.blockToBitMapPermanent, bitMap, player.field_71075_bZ.field_75098_d).isEmpty()) {
            this.stateToBitCountArray = this.getSortedLinkedBitMap(this.stateToBitCountArray);
            IBitAccess bitAccess = this.api.createBitItem(ItemStack.field_190927_a);
            HashMap<IBlockState, ArrayList<ItemModelingTool.BitCount>> stateToBitCountArrayCopy = new HashMap<IBlockState, ArrayList<ItemModelingTool.BitCount>>();
            for (Map.Entry<IBlockState, ArrayList<ItemModelingTool.BitCount>> entry : this.stateToBitCountArray.entrySet()) {
                ArrayList<ItemModelingTool.BitCount> bitCountArray = new ArrayList<ItemModelingTool.BitCount>();
                for (ItemModelingTool.BitCount bitCount : entry.getValue()) {
                    bitCountArray.add(new ItemModelingTool.BitCount(bitCount.getBit(), bitCount.getCount()));
                }
                stateToBitCountArrayCopy.put(entry.getKey(), bitCountArray);
            }
            this.previewResultStack = itemModelingTool.createModel(null, null, this.getHeldStack(), this.stateArray, stateToBitCountArrayCopy, bitAccess) ? bitAccess.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false) : ItemStack.field_190927_a;
        } else {
            this.previewResultStack = ItemStack.field_190927_a;
        }
    }

    private Map<IBlockState, IBitBrush> getBitMapManual() {
        if (this.designMode) {
            return this.stateToBitMapManual;
        }
        return this.tabButtons[2].selected ? this.blockToBitMapAllBlocks : (this.buttonStates.selected ? this.stateToBitMapManual : this.blockToBitMapManual);
    }

    private Map<IBlockState, IBitBrush> getBitMapPermanent() {
        return this.designMode || this.buttonStates.selected ? this.stateToBitMapPermanent : this.blockToBitMapPermanent;
    }

    public void setPreviewStack() {
        IBitAccess bitAccess = this.api.createBitItem(ItemStack.field_190927_a);
        IBitBrush defaultBit = null;
        try {
            defaultBit = this.api.createBrushFromState(Configs.replacementBitsUnchiselable.getDefaultReplacementBit().getDefaultState());
        }
        catch (APIExceptions.InvalidBitItem invalidBitItem) {
            // empty catch block
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    IBlockState state = this.stateArray[i][j][k];
                    if (this.designMode) {
                        try {
                            bitAccess.setBitAt(i, j, k, this.stateToBitMapManual.get(state));
                        }
                        catch (APIExceptions.SpaceOccupied spaceOccupied) {}
                        continue;
                    }
                    IBlockState state2 = state.func_177230_c().func_176223_P();
                    boolean stateFound = this.stateToBitMapManual.containsKey(state);
                    boolean savedStateFound = this.stateToBitMapPermanent.containsKey(state);
                    boolean savedBlockFound = this.blockToBitMapPermanent.containsKey(state2);
                    if (!stateFound && !savedBlockFound) continue;
                    IBitBrush bit = savedBlockFound && !savedStateFound ? this.blockToBitMapPermanent.get(state2) : this.stateToBitMapManual.get(state);
                    try {
                        bitAccess.setBitAt(i, j, k, bit != null ? bit : defaultBit);
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied spaceOccupied) {
                        // empty catch block
                    }
                }
            }
        }
        this.previewStack = bitAccess.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
    }

    public ItemStack getHeldStack() {
        return this.field_146297_k.field_71439_g.func_184614_ca();
    }

    public int getGuiLeft() {
        return this.field_147003_i + 24;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i -= 12;
        int l = this.field_147003_i + 128;
        int t = this.field_147009_r + 21;
        this.previewStackBox = new AxisAlignedBB((double)l, (double)t, -1.0, (double)(l + 107), (double)(t + 100), 1.0);
        this.searchField = new GuiTextField(6, this.field_146289_q, this.field_147003_i + 44, this.field_147009_r + 8, 65, 9);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(-1);
        this.searchField.func_146180_a(this.searchText);
        int slotHeight = 24;
        if (this.designMode) {
            this.stateToBitMapPermanent = new HashMap<IBlockState, IBitBrush>();
            this.blockToBitMapPermanent = new HashMap<IBlockState, IBitBrush>();
            this.initDesignMode();
            String buttonText = "Save Changes";
            int buttonWidth = this.field_146289_q.func_78256_a(buttonText) + 6;
            this.field_146292_n.add(new GuiButtonExt(0, this.field_147003_i + this.field_146999_f - buttonWidth - 5, this.field_147009_r + 5, buttonWidth, 14, buttonText));
        } else {
            boolean buttonStatesSlected;
            this.buttonSettings = new GuiButtonTextured(7, this.field_147003_i + 237, this.field_147009_r + 6, 12, 12, "Bit Mapping Settings", SETTINGS_BACK, SETTINGS_MAIN, null, null);
            this.buttonSettings.setHoverTextSelected("Back To Preview");
            this.buttonBitMapPerTool = new GuiButtonTextured(8, this.field_147003_i + 143, this.field_147009_r + 26, 12, 12, "Save/access mappings per tool or per client config", BOX_CHECKED, BOX_UNCHECKED, SoundsExtraBitManipulation.boxCheck, SoundsExtraBitManipulation.boxUncheck);
            if (this.showSettings) {
                this.buttonSettings.selected = true;
            }
            int y = this.field_147009_r + 44;
            int offsetY = 19;
            String hovertext = "Overwrite mappings saved in 1 with the mappings saved in 2";
            String stackText = "this Modeling Tool's NBT";
            String configText = "the client config file";
            this.buttonOverwriteStackMapsWithConfig = new GuiButtonGradient(9, this.field_147003_i + 130, y, 102, 14, "Write Config->Stack", hovertext.replace("1", stackText).replace("2", configText));
            this.buttonOverwriteConfigMapsWithStack = new GuiButtonGradient(10, this.field_147003_i + 130, y + offsetY, 102, 14, "Write Stack->Config", hovertext.replace("2", stackText).replace("1", configText));
            this.buttonRestoreConfigMaps = new GuiButtonGradient(11, this.field_147003_i + 130, y + offsetY * 2, 102, 14, "Reset Config Maps", "Reset " + configText + " mapping data to their default values");
            this.buttonClearStackMaps = new GuiButtonGradient(12, this.field_147003_i + 130, y + offsetY * 3, 102, 14, "Clear Stack Data", "Delete all saved mappping data from " + stackText);
            this.updateButtons();
            if (this.bitMapPerTool) {
                this.buttonBitMapPerTool.selected = true;
                this.stateToBitMapPermanent = BitIOHelper.readStateToBitMapFromNBT(this.api, this.getHeldStack(), "stateToBitMapPermanent");
                this.blockToBitMapPermanent = BitIOHelper.readStateToBitMapFromNBT(this.api, this.getHeldStack(), "blockToBitMapPermanent");
            } else {
                this.stateToBitMapPermanent = Configs.modelStateToBitMap;
                this.blockToBitMapPermanent = Configs.modelBlockToBitMap;
            }
            this.stateToBitMapPermanent = this.getSortedLinkedBitMap(this.stateToBitMapPermanent);
            this.blockToBitMapPermanent = this.getSortedLinkedBitMap(this.blockToBitMapPermanent);
            this.field_146292_n.add(this.buttonSettings);
            this.field_146292_n.add(this.buttonBitMapPerTool);
            this.field_146292_n.add(this.buttonOverwriteStackMapsWithConfig);
            this.field_146292_n.add(this.buttonOverwriteConfigMapsWithStack);
            this.field_146292_n.add(this.buttonRestoreConfigMaps);
            this.field_146292_n.add(this.buttonClearStackMaps);
            this.stateMap = new HashMap<IBlockState, Integer>();
            this.stateArray = new IBlockState[16][16][16];
            BitIOHelper.readStatesFromNBT(ItemStackHelper.getNBTOrNew(this.getHeldStack()), this.stateMap, this.stateArray);
            this.constructStateToBitCountArray();
            for (int i = 0; i < this.tabButtons.length; ++i) {
                ItemStack iconStack = i == 0 ? this.previewStack : (i == 1 ? ItemStack.field_190927_a : (i == 2 ? new ItemStack((Block)Blocks.field_150349_c) : ItemStack.field_190927_a));
                float u = 0.0f;
                float v = 0.0f;
                int uWidth = 0;
                int vHeight = 0;
                if (i == 1 || i == 3) {
                    u = i == 1 ? 104.0f : 67.0f;
                    v = 219.0f;
                    uWidth = 36;
                    vHeight = 36;
                }
                GuiButtonTab tab = new GuiButtonTab(i, this.field_147003_i, this.field_147009_r + 21 + i * 25, 24, 25, TAB_HOVER_TEXT[i], iconStack, u, v, uWidth, vHeight, 141, 219, 256, GUI_TEXTURE);
                if (i == this.savedTab) {
                    tab.selected = true;
                }
                this.tabButtons[i] = tab;
                this.field_146292_n.add(tab);
            }
            int x = this.field_147003_i + 42;
            y = this.field_147009_r + 122;
            int colorSelected = -16726016;
            int colorDeselected = -8882056;
            this.buttonStates = new GuiButtonSelect(4, x, y, 37, 12, "States", "Map bits to individual block states", colorSelected, colorDeselected);
            this.buttonBlocks = new GuiButtonSelect(5, x + 37, y, 36, 12, "Blocks", "Map bits to all posible states of a given block", colorSelected, colorDeselected);
            this.buttonStates.field_146124_l = !this.tabButtons[2].selected;
            this.buttonBlocks.field_146124_l = !this.isResultsTabSelected();
            int selectedTab = this.getSelectedTab();
            this.buttonStates.selected = buttonStatesSlected = selectedTab > 1 ? selectedTab == 3 : this.stateMauallySelected;
            this.buttonBlocks.selected = !buttonStatesSlected;
            this.field_146292_n.add(this.buttonStates);
            this.field_146292_n.add(this.buttonBlocks);
        }
        this.bitMappingList = new GuiListBitMapping(this, 150, this.field_146295_m, this.field_147009_r + 21, this.field_147009_r + 121, slotHeight, this.designMode);
        this.constructManualMaps();
        this.refreshList();
    }

    private boolean isResultsTabSelected() {
        return this.designMode || this.tabButtons[3].selected;
    }

    private LinkedHashMap getSortedLinkedBitMap(Map bitMap) {
        return BitInventoryHelper.getSortedLinkedHashMap(bitMap, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                return this.getName(object1).compareTo(this.getName(object2));
            }

            private String getName(Object object) {
                IBlockState state = (IBlockState)((Map.Entry)object).getKey();
                Block block = state.func_177230_c();
                ResourceLocation regName = block.getRegistryName();
                return regName == null ? "" : regName.func_110624_b() + regName.func_110623_a() + block.func_176201_c(state);
            }
        });
    }

    private void updateButtons() {
        if (this.designMode) {
            return;
        }
        this.buttonRestoreConfigMaps.field_146125_m = this.buttonClearStackMaps.field_146125_m = this.showSettings;
        this.buttonOverwriteConfigMapsWithStack.field_146125_m = this.buttonClearStackMaps.field_146125_m;
        this.buttonOverwriteConfigMapsWithStack.field_146125_m = this.buttonClearStackMaps.field_146125_m;
        this.buttonOverwriteStackMapsWithConfig.field_146125_m = this.buttonClearStackMaps.field_146125_m;
        this.buttonBitMapPerTool.field_146125_m = this.buttonClearStackMaps.field_146125_m;
        if (!this.showSettings) {
            return;
        }
        LinkedHashMap stateToBitMapSorted = this.getSortedLinkedBitMap(Configs.modelStateToBitMap);
        LinkedHashMap blockToBitMapSorted = this.getSortedLinkedBitMap(Configs.modelBlockToBitMap);
        this.buttonOverwriteConfigMapsWithStack.field_146124_l = !BitIOHelper.areSortedBitMapsIdentical(stateToBitMapSorted, this.getSortedLinkedBitMap(BitIOHelper.readStateToBitMapFromNBT(this.api, this.getHeldStack(), "stateToBitMapPermanent"))) || !BitIOHelper.areSortedBitMapsIdentical(blockToBitMapSorted, this.getSortedLinkedBitMap(BitIOHelper.readStateToBitMapFromNBT(this.api, this.getHeldStack(), "blockToBitMapPermanent")));
        this.buttonOverwriteStackMapsWithConfig.field_146124_l = this.buttonOverwriteConfigMapsWithStack.field_146124_l;
        this.buttonRestoreConfigMaps.field_146124_l = !BitIOHelper.areSortedBitMapsIdentical(stateToBitMapSorted, this.getSortedLinkedBitMap(BitIOHelper.getModelBitMapFromEntryStrings(ConfigHandlerExtraBitManipulation.STATE_TO_BIT_MAP_DEFAULT_VALUES))) || !BitIOHelper.areSortedBitMapsIdentical(blockToBitMapSorted, this.getSortedLinkedBitMap(BitIOHelper.getModelBitMapFromEntryStrings(ConfigHandlerExtraBitManipulation.BLOCK_TO_BIT_MAP_DEFAULT_VALUES)));
        this.buttonClearStackMaps.field_146124_l = BitIOHelper.hasBitMapsInNbt(this.getHeldStack());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.refreshList();
            this.searchText = this.searchField.func_146179_b();
        } else if (Keyboard.isKeyDown((int)46)) {
            this.previewStackTranslation = Vec3d.field_186680_a;
        } else if (this.showSettings) {
            if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                this.buttonSettings.selected = false;
                this.showSettings = false;
                this.updateButtons();
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (!this.previewStackBoxClicked) {
            this.bitMappingList.func_178039_p();
        }
        Pair<Vec3d, Float> pair = GuiHelper.scaleObjectWithMouseWheel((GuiScreen)this, this.previewStackBox, this.previewStackTranslation, this.previewStackScale, 30.0f, 0.0f);
        this.previewStackTranslation = (Vec3d)pair.getLeft();
        this.previewStackScale = ((Float)pair.getRight()).floatValue();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (!this.previewStackBoxClicked) {
            return;
        }
        float deltaX = this.mouseInitialX - mouseX;
        float deltaY = this.mouseInitialY - mouseY;
        if (clickedMouseButton == 0) {
            this.mouseInitialX = mouseX;
            this.mouseInitialY = mouseY;
        }
        Triple<Vec3d, Vec3d, Float> triple = GuiHelper.dragObject(clickedMouseButton, deltaX, deltaY, this.previewStackTranslationInitial, this.previewStackRotation, this.previewStackScale, 30.0f, 4.5f, 4.5f, true);
        this.previewStackTranslation = (Vec3d)triple.getLeft();
        this.previewStackRotation = (Vec3d)triple.getMiddle();
        this.previewStackScale = ((Float)triple.getRight()).floatValue();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchField.func_146178_a();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        this.bitMappingList.func_148179_a(mouseX, mouseY, mouseButton);
        this.previewStackBoxClicked = GuiHelper.isCursorInsideBox(this.previewStackBox, mouseX, mouseY);
        this.mouseInitialX = mouseX;
        this.mouseInitialY = mouseY;
        this.previewStackTranslationInitial = new Vec3d(this.previewStackTranslation.field_72450_a, this.previewStackTranslation.field_72448_b, 0.0);
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && mouseButton == 2 && this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.previewStackBoxClicked) {
            ItemStack previewStack = this.getPreviewStack();
            if (previewStack.func_190926_b()) {
                return;
            }
            ItemStack stack = previewStack.func_77946_l();
            this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(stack);
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCursorStack(stack));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.bitMappingList.func_148181_b(mouseX, mouseY, state);
        this.updateButtons();
        this.mouseInitialX = 0;
        this.mouseInitialY = 0;
        this.previewStackBoxClicked = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.previewStackBoxClicked) {
            return;
        }
        this.func_191948_b(mouseX, mouseY);
        for (int i = 0; i < this.bitMappingList.func_148127_b(); ++i) {
            GuiListBitMappingEntry entry = this.bitMappingList.getListEntry(i);
            if (mouseY < this.bitMappingList.field_148153_b || mouseY > this.bitMappingList.field_148154_c) continue;
            RenderHelper.func_74520_c();
            int slotWidth = 19;
            int k = this.bitMappingList.field_148152_e + this.bitMappingList.field_148155_a / 2 - this.bitMappingList.field_148155_a / 2 + 5;
            int l = this.bitMappingList.field_148153_b + 4 + i * this.bitMappingList.field_148149_f - this.bitMappingList.func_148148_g();
            AxisAlignedBB slot = new AxisAlignedBB((double)k, (double)l, -1.0, (double)(k + slotWidth), (double)(l + this.bitMappingList.field_148149_f - 5), 1.0);
            Vec3d mousePos = new Vec3d((double)mouseX, (double)mouseY, 0.0);
            if (slot.func_72317_d(38.0, 0.0, 0.0).func_72318_a(mousePos)) {
                ArrayList<String> hoverTextList = new ArrayList<String>();
                String unmappedText = "The blockstate is currently mapped to nothing, as it cannot be chiseled.";
                ArrayList<ItemModelingTool.BitCount> bitCountArray = entry.getBitCountArray();
                for (int j = 0; j < bitCountArray.size(); ++j) {
                    String text;
                    boolean isAir;
                    ItemModelingTool.BitCount bitCount = bitCountArray.get(j);
                    IBitBrush bit = bitCount.getBit();
                    ItemStack bitStack = bit != null ? bit.getItemStack(1) : ItemStack.field_190927_a;
                    boolean bl = isAir = bit != null && bit.isAir();
                    String string = !bitStack.func_190926_b() ? BitToolSettingsHelper.getBitName(bitStack) : (text = isAir ? "Empty / Air" : "The blockstate is currently mapped to nothing, as it cannot be chiseled.");
                    if (!bitStack.func_190926_b() || entry.isAir()) {
                        String text2 = TextFormatting.DARK_RED + (j == 0 ? "Bit:" : "\t") + " " + TextFormatting.RESET;
                        if (bitCountArray.size() > 1) {
                            text2 = (j == 0 ? "" : " ") + text2.replace("Bit:", "Bits:");
                        }
                        text = text2 + text;
                        if (this.designMode || !entry.isInteractive()) {
                            text = text + " (" + bitCount.getCount() + ")";
                        }
                    }
                    if (!this.designMode && (this.buttonStates.selected ? this.stateToBitMapPermanent.containsKey(entry.getState()) : this.blockToBitMapPermanent.containsKey(entry.getState()))) {
                        text = text + TextFormatting.BLUE + " (manually mapped)";
                    }
                    hoverTextList.add(text);
                }
                if (entry.getBitCountArray().isEmpty()) {
                    hoverTextList.add("The blockstate is currently mapped to nothing, as it cannot be chiseled.");
                }
                if (entry.isInteractive()) {
                    hoverTextList.add(!GuiBitMapping.func_146272_n() ? TextFormatting.AQUA + "  Hold SHIFT for usage instructions." : TextFormatting.AQUA + "  - Click with bit or block on cursor to add mapping.");
                    if (GuiBitMapping.func_146272_n()) {
                        hoverTextList.add(TextFormatting.AQUA + "  - Shift click with empty cursor to map to air.");
                        hoverTextList.add(TextFormatting.AQUA + "  - Control click with empty cursor to remove mapping.");
                        hoverTextList.add(TextFormatting.AQUA + "  - Middle mouse click blocks or bits in creative mode to get stack.");
                    }
                }
                this.drawHoveringText(hoverTextList, mouseX, mouseY, this.field_146297_k.field_71466_p);
            } else if (slot.func_72318_a(mousePos)) {
                boolean stateMode = this.designMode || this.buttonStates.selected;
                this.drawHoveringText(Arrays.asList(TextFormatting.DARK_RED + (stateMode ? "State" : "Block") + ": " + TextFormatting.RESET + (stateMode ? entry.getState().toString() : (Comparable)Block.field_149771_c.func_177774_c((Object)entry.getState().func_177230_c()))), mouseX, mouseY, this.field_146297_k.field_71466_p);
            }
            RenderHelper.func_74518_a();
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonBase)) continue;
            GuiButtonBase buttonBase = (GuiButtonBase)button;
            if (!button.func_146115_a() || !button.field_146125_m) continue;
            this.drawHoveringText(Arrays.asList(buttonBase.getHoverText()), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
        if (!this.designMode) {
            for (int i = 0; i < this.tabButtons.length; ++i) {
                if (!this.tabButtons[i].func_146115_a()) continue;
                this.drawHoveringText(Arrays.asList(this.tabButtons[i].getHoverText()), mouseX, mouseY, this.field_146297_k.field_71466_p);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientHelper.bindTexture(GUI_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.designMode) {
            this.func_73729_b(i + 12, j, 24, 0, this.field_146999_f - 24, this.field_147000_g);
        } else {
            this.func_73729_b(i - 12, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.bitMappingList.func_148128_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179140_f();
        this.searchField.func_146194_f();
        if (!this.searchField.func_146206_l() && this.searchField.func_146179_b().isEmpty()) {
            this.field_146289_q.func_78276_b("search", this.searchField.field_146209_f, this.searchField.field_146210_g, -10197916);
        }
        if (this.designMode) {
            this.field_146289_q.func_78276_b("Design", this.getGuiLeft() + 103, this.field_147009_r + 8, 0x404040);
            this.field_146289_q.func_78276_b(this.field_146297_k.field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.field_147003_i + 60, this.field_147009_r + this.field_147000_g - 96 + 2, 0x404040);
        } else {
            for (int i = 0; i < this.tabButtons.length; ++i) {
                GuiButtonTab tab = this.tabButtons[i];
                tab.renderIconStack();
                if (!tab.selected) continue;
                this.field_146289_q.func_78276_b(TAB_HOVER_TEXT[i], this.getGuiLeft() + 103, this.field_147009_r + 7, 0x404040);
            }
        }
        if (!this.designMode && this.showSettings) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            this.field_146289_q.func_78276_b("Map Per Tool", this.getGuiLeft() + 133, this.field_147009_r + 29, 0x404040);
            GlStateManager.func_179121_F();
        } else {
            ItemStack previewStack = this.getPreviewStack();
            if (!previewStack.func_190926_b()) {
                GL11.glEnable((int)3089);
                GuiHelper.glScissor((int)this.previewStackBox.field_72340_a, (int)this.previewStackBox.field_72338_b, (int)(this.previewStackBox.field_72336_d - this.previewStackBox.field_72340_a), (int)(this.previewStackBox.field_72337_e - this.previewStackBox.field_72338_b));
                RenderHelper.func_74520_c();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(0.5 + this.previewStackTranslation.field_72450_a), (double)this.previewStackTranslation.field_72448_b, (double)0.0);
                RenderState.renderStateModelIntoGUI(null, RenderState.getItemModelWithOverrides(previewStack), previewStack, false, this.field_147003_i + 167, this.field_147009_r + 61, (float)this.previewStackRotation.field_72450_a, (float)this.previewStackRotation.field_72448_b, this.previewStackScale);
                GlStateManager.func_179121_F();
                RenderHelper.func_74518_a();
                GuiHelper.glScissorDisable();
            } else {
                this.field_146289_q.func_78279_b("No Preview   Available", this.getGuiLeft() + 131, this.field_147009_r + 63, 60, 0x404040);
            }
        }
        if (this.bitMappingList.func_148127_b() == 0) {
            this.field_146289_q.func_78279_b("No " + (this.designMode || this.buttonStates.selected ? "States" : "Blocks") + "      Found", this.getGuiLeft() + 31, this.field_147009_r + 63, 60, 0x404040);
        }
        RenderHelper.func_74520_c();
        ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 800.0f;
        this.field_146296_j.field_77023_b = 800.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        int x = mouseX - 8;
        int y = mouseY - 8;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, null);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    private ItemStack getPreviewStack() {
        return !this.designMode && this.isResultsTabSelected() ? this.previewResultStack : this.previewStack;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.designMode) {
            if (button.field_146127_k == 0) {
                BitInventoryHelper.setHeldDesignStack((EntityPlayer)this.field_146297_k.field_71439_g, this.previewStack);
                this.stateToBitMapPermanent.clear();
                this.initDesignMode();
                this.constructManualMaps();
                this.refreshList();
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetDesign(this.previewStack));
            } else {
                super.func_146284_a(button);
            }
            return;
        }
        int id = button.field_146127_k;
        if (id >= 0 && id <= 5) {
            if (id > 3) {
                this.stateMauallySelected = id == 4;
                this.selectButtonStatesBlocks(this.stateMauallySelected);
                this.constructManualMaps();
                this.refreshList();
            } else {
                if (this.getSelectedTab() == id) {
                    return;
                }
                boolean allBlocksPrev = this.tabButtons[2].selected;
                boolean resultsPrev = this.isResultsTabSelected();
                for (GuiButtonTab tab : this.tabButtons) {
                    tab.selected = tab.field_146127_k == id;
                }
                this.savedTab = id;
                boolean allBlocks = this.tabButtons[2].selected;
                boolean results = this.isResultsTabSelected();
                this.buttonStates.field_146124_l = !allBlocks;
                boolean bl = this.buttonBlocks.field_146124_l = !results;
                if (allBlocks) {
                    this.selectButtonStatesBlocks(false);
                } else if (allBlocksPrev && this.stateMauallySelected) {
                    this.selectButtonStatesBlocks(true);
                }
                if (results) {
                    this.selectButtonStatesBlocks(true);
                } else if (resultsPrev && !this.stateMauallySelected) {
                    this.selectButtonStatesBlocks(false);
                }
                if (allBlocksPrev != allBlocks) {
                    this.constructManualMaps();
                }
                this.refreshList();
            }
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetTabAndStateBlockButton(this.getSelectedTab(), this.stateMauallySelected));
        } else if (id == 7) {
            this.showSettings ^= true;
            this.buttonSettings.selected = this.showSettings;
            this.updateButtons();
        } else if (id == 8) {
            this.bitMapPerTool ^= true;
            this.buttonBitMapPerTool.selected = this.bitMapPerTool;
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketBitMappingsPerTool(this.bitMapPerTool));
        } else if (id == 9) {
            ItemStack stack = this.getHeldStack();
            this.overwriteStackBitMappings(stack, Configs.modelBlockToBitMap, "blockToBitMapPermanent");
            this.overwriteStackBitMappings(stack, Configs.modelStateToBitMap, "stateToBitMapPermanent");
        } else if (id == 10 || id == 11) {
            Configs.modelBlockToBitMapEntryStrings = id == 10 ? this.overwriteConfigMapWithStackMap(Configs.modelBlockToBitMap, "blockToBitMapPermanent") : ConfigHandlerExtraBitManipulation.BLOCK_TO_BIT_MAP_DEFAULT_VALUES;
            String[] stringArray = Configs.modelStateToBitMapEntryStrings = id == 10 ? this.overwriteConfigMapWithStackMap(Configs.modelStateToBitMap, "stateToBitMapPermanent") : ConfigHandlerExtraBitManipulation.STATE_TO_BIT_MAP_DEFAULT_VALUES;
            if (id == 11) {
                BitToolSettingsHelper.setBitMapProperty(true, Configs.modelStateToBitMapEntryStrings);
                BitToolSettingsHelper.setBitMapProperty(false, Configs.modelBlockToBitMapEntryStrings);
            }
            Configs.initModelingBitMaps();
        } else if (id == 12) {
            BitIOHelper.clearAllBitMapsFromNbt(this.getHeldStack());
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketClearStackBitMappings());
        } else {
            super.func_146284_a(button);
            return;
        }
        if (id >= 8) {
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    private void initDesignMode() {
        this.stateMap = new HashMap<IBlockState, Integer>();
        this.stateArray = new IBlockState[16][16][16];
        IBitAccess pattern = this.api.createBitItem(this.getHeldStack());
        if (pattern == null) {
            pattern = this.api.createBitItem(ItemStack.field_190927_a);
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    IBlockState state;
                    IBitBrush bit = pattern.getBitAt(i, j, k);
                    this.stateArray[i][j][k] = state = bit.getState();
                    if (bit.isAir()) continue;
                    this.stateMap.put(state, 1 + (this.stateMap.containsKey(state) ? this.stateMap.get(state) : 0));
                }
            }
        }
        this.constructStateToBitCountArray();
    }

    private void overwriteStackBitMappings(ItemStack stack, Map<IBlockState, IBitBrush> bitMap, String key) {
        BitIOHelper.writeStateToBitMapToNBT(stack, key, bitMap, Configs.saveStatesById);
        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketOverwriteStackBitMappings(bitMap, key, Configs.saveStatesById));
    }

    private String[] overwriteConfigMapWithStackMap(Map<IBlockState, IBitBrush> bitMap, String key) {
        String[] entryStrings = BitIOHelper.getEntryStringsFromModelBitMap(BitIOHelper.readStateToBitMapFromNBT(this.api, this.getHeldStack(), key));
        BitToolSettingsHelper.setBitMapProperty(bitMap.equals(Configs.modelStateToBitMap), entryStrings);
        return entryStrings;
    }

    private int getSelectedTab() {
        for (GuiButtonTab tab : this.tabButtons) {
            if (!tab.selected) continue;
            return tab.field_146127_k;
        }
        return 0;
    }

    private void selectButtonStatesBlocks(boolean selectStates) {
        this.buttonStates.selected = selectStates;
        this.buttonBlocks.selected = !selectStates;
    }
}

