/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.render;

import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RenderState {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void renderStateIntoGUI(final IBlockState state, int x, int y) {
        boolean isVanillaChest;
        boolean emptyModel;
        IBakedModel model;
        BlockModelShapes blockModelShapes;
        block11: {
            blockModelShapes = ClientHelper.getBlockModelShapes();
            model = blockModelShapes.func_178125_b(state);
            try {
                boolean missingModel = RenderState.isMissingModel(blockModelShapes, model);
                boolean bl = emptyModel = missingModel || model.func_188616_a(state, null, 0L).isEmpty();
                if (missingModel || !emptyModel) break block11;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (model.func_188616_a(state, enumfacing, 0L).isEmpty()) continue;
                    emptyModel = false;
                    break;
                }
            }
            catch (Exception e) {
                emptyModel = true;
            }
        }
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block, 1, block.func_176201_c(state));
        if (RenderState.isNullItem(block, stack)) {
            stack = ItemStack.field_190927_a;
        }
        boolean bl = isVanillaChest = block == Blocks.field_150486_ae || block == Blocks.field_150477_bB || block == Blocks.field_150447_bR;
        if (!stack.func_190926_b() && emptyModel) {
            model = RenderState.getItemModelWithOverrides(stack);
            if (!isVanillaChest && RenderState.isMissingModel(blockModelShapes, model)) {
                stack = new ItemStack(block);
                if (RenderState.isNullItem(block, stack)) {
                    stack = ItemStack.field_190927_a;
                }
                if (!stack.func_190926_b()) {
                    model = RenderState.getItemModelWithOverrides(stack);
                }
            }
        }
        boolean renderAsTileEntity = !stack.func_190926_b() && (model.func_188618_c() || isVanillaChest);
        try {
            RenderState.renderStateModelIntoGUI(state, model, stack, renderAsTileEntity, x, y, 0.0f, 0.0f, -1.0f);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering block state in extrabitmanipulation bit mapping GUI");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block state being rendered");
            crashreportcategory.func_189529_a("Block State", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return String.valueOf(state);
                }
            });
            if (!stack.func_190926_b()) {
                final ItemStack stack2 = stack.func_77946_l();
                crashreportcategory.func_189529_a("State's Item Type", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        return String.valueOf(stack2.func_77973_b());
                    }
                });
                crashreportcategory.func_189529_a("State's Item Aux", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        return String.valueOf(stack2.func_77960_j());
                    }
                });
                crashreportcategory.func_189529_a("State's Item NBT", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        return String.valueOf(stack2.func_77978_p());
                    }
                });
                crashreportcategory.func_189529_a("State's Item Foil", (ICrashReportDetail)new ICrashReportDetail<String>(){

                    public String call() throws Exception {
                        return String.valueOf(stack2.func_77962_s());
                    }
                });
            }
            throw new ReportedException(crashreport);
        }
    }

    public static IBakedModel getItemModelWithOverrides(ItemStack stack) {
        return ClientHelper.getRenderItem().func_184393_a(stack, null, (EntityLivingBase)ClientHelper.getPlayer());
    }

    private static boolean isNullItem(Block block, ItemStack stack) {
        return stack.func_77973_b() == null || block == Blocks.field_180393_cK || block == Blocks.field_180401_cv;
    }

    private static boolean isMissingModel(BlockModelShapes blockModelShapes, IBakedModel model) {
        return model.equals(blockModelShapes.func_178126_b().func_174951_a());
    }

    public static void renderStateModelIntoGUI(IBlockState state, IBakedModel model, ItemStack stack, boolean renderAsTileEntity, int x, int y, float angleX, float angleY, float scale) {
        RenderState.renderStateModelIntoGUI(state, model, stack, 1.0f, false, renderAsTileEntity, x, y, angleX, angleY, scale);
    }

    public static void renderStateModelIntoGUI(IBlockState state, IBakedModel model, ItemStack stack, float alphaMultiplier, boolean transformFroGui, boolean renderAsTileEntity, int x, int y, float angleX, float angleY, float scale) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179094_E();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderState.setupGuiTransform(x, y, model);
        if (transformFroGui) {
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        }
        RenderState.renderState(state, model, stack, alphaMultiplier, renderAsTileEntity, angleX, angleY, scale);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public static void renderState(IBlockState state, IBakedModel model, ItemStack stack, float alphaMultiplier, boolean renderAsTileEntity, float angleX, float angleY, float scale) {
        boolean autoScale;
        boolean bl = autoScale = scale < 0.0f;
        if (autoScale) {
            scale = 1.0f;
        }
        GlStateManager.func_179094_E();
        if (autoScale) {
            try {
                float z;
                float y;
                float x;
                int[] data;
                int size;
                float minX = Float.POSITIVE_INFINITY;
                float minY = Float.POSITIVE_INFINITY;
                float minZ = Float.POSITIVE_INFINITY;
                float maxX = Float.NEGATIVE_INFINITY;
                float maxY = Float.NEGATIVE_INFINITY;
                float maxZ = Float.NEGATIVE_INFINITY;
                for (BakedQuad quad : model.func_188616_a(state, null, 0L)) {
                    size = quad.getFormat().func_181719_f();
                    data = quad.func_178209_a();
                    for (int i = 0; i < 4; ++i) {
                        int index = size * i;
                        x = Float.intBitsToFloat(data[index]);
                        if (x < minX) {
                            minX = x;
                        }
                        if (x > maxX) {
                            maxX = x;
                        }
                        if ((y = Float.intBitsToFloat(data[index + 1])) < minY) {
                            minY = y;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        if ((z = Float.intBitsToFloat(data[index + 2])) < minZ) {
                            minZ = z;
                        }
                        if (!(z > maxZ)) continue;
                        maxZ = z;
                    }
                }
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    for (BakedQuad quad : model.func_188616_a(state, enumfacing, 0L)) {
                        size = quad.getFormat().func_181719_f();
                        data = quad.func_178209_a();
                        for (int i = 0; i < 4; ++i) {
                            int index = size * i;
                            x = Float.intBitsToFloat(data[index]);
                            if (x < minX) {
                                minX = x;
                            }
                            if (x > maxX) {
                                maxX = x;
                            }
                            if ((y = Float.intBitsToFloat(data[index + 1])) < minY) {
                                minY = y;
                            }
                            if (y > maxY) {
                                maxY = y;
                            }
                            if ((z = Float.intBitsToFloat(data[index + 2])) < minZ) {
                                minZ = z;
                            }
                            if (!(z > maxZ)) continue;
                            maxZ = z;
                        }
                    }
                }
                scale = 1.0f / Math.max(1.0f, Math.max(maxX - minX, Math.max(maxY - minY, maxZ - minZ)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            scale *= 0.65f;
        }
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        if (renderAsTileEntity) {
            if (autoScale) {
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
        } else {
            if (autoScale) {
                GlStateManager.func_179114_b((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)30.0f, (float)-1.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            RenderState.renderModel(state, model, -1, alphaMultiplier, stack);
            if (stack.func_77962_s()) {
                RenderState.renderEffect(state, model);
            }
        }
        GlStateManager.func_179121_F();
    }

    private static void setupGuiTransform(int x, int y, IBakedModel model) {
        GlStateManager.func_179109_b((float)(x + 6), (float)(y + 2), (float)(100.0f + ClientHelper.getRenderItem().field_77023_b + 400.0f));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (model.func_177556_c()) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderModel(IBlockState state, IBakedModel model, int color, float alphaMultiplier, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        try {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                RenderState.renderQuads(buffer, model.func_188616_a(state, enumfacing, 0L), color, alphaMultiplier, stack);
            }
            RenderState.renderQuads(buffer, model.func_188616_a(state, null, 0L), color, alphaMultiplier, stack);
        }
        catch (Exception exception) {
        }
        finally {
            tessellator.func_78381_a();
        }
    }

    private static void renderEffect(IBlockState state, IBakedModel model) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        ClientHelper.bindTexture(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderState.renderModel(state, model, -8372020, 1.0f, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderState.renderModel(state, model, -8372020, 1.0f, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        ClientHelper.bindTexture(TextureMap.field_110575_b);
    }

    private static void renderQuads(BufferBuilder buffer, List<BakedQuad> quads, int color, float alphaMultiplier, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad quad = quads.get(i);
            int colorQuad = color;
            if (flag && quad.func_178212_b()) {
                colorQuad = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    colorQuad = TextureUtil.func_177054_c((int)colorQuad);
                }
                colorQuad |= 0xFF000000;
            }
            if (alphaMultiplier < 1.0f) {
                colorQuad = (int)((float)(color == -1 ? 255 : colorQuad >> 24) * alphaMultiplier) << 24 | colorQuad & 0xFFFFFF;
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)colorQuad);
        }
    }
}

