/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.entity;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.packet.PacketBitParticles;
import com.phylogeny.extrabitmanipulation.packet.PacketPlaceEntityBit;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBit
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    private ItemStack bitStack = ItemStack.field_190927_a;
    protected boolean inGround;
    public Entity shootingEntity;

    public EntityBit(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0625f, 0.0625f);
    }

    public EntityBit(World worldIn, double x, double y, double z, ItemStack bitStack) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.bitStack = bitStack.func_77946_l();
        this.bitStack.func_190920_e(1);
    }

    public EntityBit(World worldIn, EntityLivingBase shooter, ItemStack bitStack) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v, bitStack);
        this.shootingEntity = shooter;
    }

    protected void func_70088_a() {
    }

    public ItemStack getBitStack() {
        return this.bitStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double range = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(range)) {
            range = 4.0;
        }
        return distance < (range *= 64.0) * range;
    }

    public void setAim(Entity shooter, float pitch, float yaw, float velocity, float inaccuracy) {
        pitch = (float)Math.toRadians(pitch);
        yaw = (float)Math.toRadians(yaw);
        float x = -MathHelper.func_76126_a((float)yaw) * MathHelper.func_76134_b((float)pitch);
        float y = -MathHelper.func_76126_a((float)pitch);
        float z = MathHelper.func_76134_b((float)yaw) * MathHelper.func_76134_b((float)pitch);
        this.func_70186_c(x, y, z, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.setRotation(x, y, z);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private void setRotation(double x, double y, double z) {
        float f = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public void func_70071_h_() {
        Entity entity;
        if (this.inGround) {
            return;
        }
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.setRotation(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d end = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult result = this.field_70170_p.func_147447_a(start, end, false, true, false);
        start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        end = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (result != null) {
            end = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(start, end)) != null) {
            result = new RayTraceResult(entity);
        }
        if (result != null) {
            this.onHit(result);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float attenuation = 0.99f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            attenuation = 0.6f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)attenuation;
        this.field_70181_x *= (double)attenuation;
        this.field_70179_y *= (double)attenuation;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void onHit(RayTraceResult result) {
        if (this.bitStack.func_190926_b()) {
            return;
        }
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        boolean drop = true;
        boolean isLava = false;
        try {
            IBlockState state = api.createBrush(this.bitStack).getState();
            if (state != null) {
                isLava = state.func_185904_a() != Material.field_151586_h;
                drop = isLava && state.func_185904_a() != Material.field_151587_i;
            }
        }
        catch (APIExceptions.InvalidBitItem state) {
            // empty catch block
        }
        Entity entity = result.field_72308_g;
        if (entity != null) {
            if (!this.field_70170_p.field_72995_K) {
                if ((!isLava ? Configs.disableExtinguishEntities : Configs.disableIgniteEntities) || drop) {
                    if (!Configs.thrownBitDamageDisable) {
                        entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), Configs.thrownBitDamage);
                    }
                    drop = true;
                } else {
                    int flag;
                    if (isLava) {
                        this.func_184185_a(SoundEvents.field_187643_bs, 1.0f, 3.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    } else {
                        this.func_184185_a(this.func_184184_Z(), 0.2f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    }
                    int n = flag = isLava ? 0 : 1;
                    if (entity.func_70027_ad() != isLava) {
                        if (isLava) {
                            entity.func_70015_d(Configs.thrownLavaBitBurnTime);
                        } else {
                            entity.func_70066_B();
                            this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                            flag = 2;
                        }
                    }
                    if (!isLava && entity instanceof EntityBlaze) {
                        if (!Configs.thrownWaterBitBlazeDamageDisable) {
                            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), Configs.thrownWaterBitBlazeDamage);
                        }
                        flag = 2;
                    }
                    this.updateClients(new PacketBitParticles(flag, this, entity));
                }
            }
        } else {
            BlockPos pos = result.func_178782_a();
            if (!(!isLava ? Configs.disableExtinguishBlocks : Configs.disableIgniteBlocks) && !drop) {
                if (!this.field_70170_p.field_72995_K) {
                    pos = pos.func_177972_a(result.field_178784_b);
                    if (isLava) {
                        if (this.field_70170_p.func_175623_d(pos)) {
                            this.func_184185_a(SoundEvents.field_187643_bs, 1.0f, 3.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                            this.field_70170_p.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                        }
                    } else {
                        this.func_184185_a(this.func_184184_Z(), 0.2f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                        int flag = 3;
                        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
                            this.func_184185_a(SoundEvents.field_187646_bt, 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
                            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                            flag = 4;
                        }
                        Vec3d hit = result.field_72307_f.func_72441_c(0.0625 * (double)result.field_178784_b.func_96559_d() * 2.0, 0.0625 * (double)result.field_178784_b.func_82601_c() * 2.0, 0.0625 * (double)result.field_178784_b.func_82599_e() * 2.0);
                        this.updateClients(new PacketBitParticles(flag, hit, pos));
                    }
                    this.func_70106_y();
                }
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                SoundType soundType;
                float volume = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * 0.2f;
                if (volume > 1.0f) {
                    volume = 1.0f;
                }
                SoundEvent sound = SoundEvents.field_187770_dm;
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state != null && (soundType = state.func_177230_c().getSoundType(state, this.field_70170_p, pos, (Entity)this)) != null) {
                    sound = soundType.func_185842_g();
                }
                this.func_184185_a(sound, volume, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            }
            boolean bl = drop = !EntityBit.placeBit(this.field_70170_p, this.bitStack, pos, result.field_72307_f, result.field_178784_b, this.field_70170_p.field_72995_K);
            if (!this.field_70170_p.field_72995_K && !drop) {
                this.updateClients(new PacketPlaceEntityBit(this.bitStack, pos, result));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (drop) {
                this.func_70099_a(this.bitStack, 0.0f);
            }
            this.func_70106_y();
        }
    }

    private void updateClients(IMessage message) {
        ExtraBitManipulation.packetNetwork.sendToAllAround(message, new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0));
    }

    public static boolean placeBit(World world, ItemStack bitStack, BlockPos pos, Vec3d hitVec, EnumFacing sideHit, boolean simulate) {
        try {
            int z;
            int y;
            int x;
            IChiselAndBitsAPI api2 = ChiselsAndBitsAPIAccess.apiInstance;
            IBitLocation bitLoc = api2.getBitPos((float)hitVec.field_72450_a - (float)pos.func_177958_n(), (float)hitVec.field_72448_b - (float)pos.func_177956_o(), (float)hitVec.field_72449_c - (float)pos.func_177952_p(), sideHit, pos, false);
            Vec3d center = new Vec3d((double)bitLoc.getBitX() * 0.0625 + (double)pos.func_177958_n() + 0.0625 * (double)sideHit.func_82601_c(), (double)bitLoc.getBitY() * 0.0625 + (double)pos.func_177956_o() + 0.0625 * (double)sideHit.func_96559_d(), (double)bitLoc.getBitZ() * 0.0625 + (double)pos.func_177952_p() + 0.0625 * (double)sideHit.func_82599_e());
            pos = new BlockPos(center);
            IBitAccess bitAccess = api2.getBitAccess(world, pos);
            if (api2.canBeChiseled(world, pos) && bitAccess.getBitAt(x = (int)Math.ceil((int)((center.field_72450_a - (double)pos.func_177958_n()) / 0.0625)), y = (int)Math.ceil((int)((center.field_72448_b - (double)pos.func_177956_o()) / 0.0625)), z = (int)Math.ceil((int)((center.field_72449_c - (double)pos.func_177952_p()) / 0.0625))).isAir()) {
                bitAccess.setBitAt(x, y, z, api2.createBrush(bitStack));
                if (!simulate) {
                    bitAccess.commitChanges(true);
                }
                return true;
            }
        }
        catch (APIExceptions.CannotBeChiseled cannotBeChiseled) {
        }
        catch (APIExceptions.SpaceOccupied spaceOccupied) {
        }
        catch (APIExceptions.InvalidBitItem invalidBitItem) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == this.shootingEntity && this.field_70173_aa < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        NBTTagCompound nbt = new NBTTagCompound();
        this.bitStack.func_77955_b(nbt);
        compound.func_74782_a("stack", (NBTBase)nbt);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.bitStack = new ItemStack(compound.func_74775_l("stack"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bitStack);
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.bitStack = ByteBufUtils.readItemStack((ByteBuf)buffer);
        this.field_70159_w = buffer.readDouble();
        this.field_70181_x = buffer.readDouble();
        this.field_70179_y = buffer.readDouble();
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public boolean func_184186_bw() {
        return true;
    }
}

