/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.item.ItemBitWrench;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackHelper {
    public static void saveStackToNBT(NBTTagCompound nbt, ItemStack stack, String key) {
        NBTTagCompound nbt2 = new NBTTagCompound();
        stack.func_77955_b(nbt2);
        nbt.func_74782_a(key, (NBTBase)nbt2);
    }

    public static ItemStack loadStackFromNBT(NBTTagCompound nbt, String key) {
        ItemStack stack = ItemStack.field_190927_a;
        if (nbt.func_74764_b(key)) {
            stack = new ItemStack((NBTTagCompound)nbt.func_74781_a(key));
        }
        return stack;
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        return stack.func_77978_p();
    }

    public static NBTTagCompound getNBTOrNew(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }

    public static boolean isModelingToolStack(ItemStack stack) {
        return ItemStackHelper.isModelingToolItem(stack.func_77973_b());
    }

    public static boolean isModelingToolItem(Item item) {
        return item != null && item instanceof ItemModelingTool;
    }

    public static boolean isSculptingToolStack(ItemStack stack) {
        return ItemStackHelper.isSculptingToolItem(stack.func_77973_b());
    }

    public static boolean isSculptingToolItem(Item item) {
        return item != null && item instanceof ItemSculptingTool;
    }

    public static boolean isBitToolStack(ItemStack stack) {
        return ItemStackHelper.isBitToolItem(stack.func_77973_b());
    }

    public static boolean isBitToolItem(Item item) {
        return item != null && item instanceof ItemBitToolBase;
    }

    public static boolean isBitWrenchStack(ItemStack stack) {
        return ItemStackHelper.isBitWrenchItem(stack.func_77973_b());
    }

    public static boolean isBitWrenchItem(Item item) {
        return item != null && item instanceof ItemBitWrench;
    }

    public static boolean isChiseledArmorStack(ItemStack stack) {
        return ItemStackHelper.isChiseledArmorItem(stack.func_77973_b());
    }

    public static boolean isChiseledArmorItem(Item item) {
        return item != null && item instanceof ItemChiseledArmor;
    }

    public static boolean isDesignStack(ItemStack stack) {
        return ItemStackHelper.isDesignItemType(ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack));
    }

    public static boolean isDesignItemType(ItemType itemType) {
        return itemType == ItemType.MIRROR_DESIGN || itemType == ItemType.NEGATIVE_DESIGN || itemType == ItemType.POSITIVE_DESIGN;
    }

    public static NBTTagCompound getArmorData(NBTTagCompound armorNbt) {
        return armorNbt.func_74775_l("data");
    }

    public static ItemStack getChiseledArmorStack(EntityPlayer player, @Nullable EntityEquipmentSlot equipmentSlot, boolean mainArmor) {
        if (equipmentSlot == null) {
            return player.func_184614_ca();
        }
        if (mainArmor) {
            return player.func_184582_a(equipmentSlot);
        }
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        return cap == null ? ItemStack.field_190927_a : cap.getStackInSlot(3 - equipmentSlot.func_188454_b());
    }
}

