/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.init;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public enum KeyBindingsExtraBitManipulation implements IKeyConflictContext
{
    EDIT_DESIGN("design", 19){

        public boolean isActive() {
            return ItemStackHelper.isDesignStack(KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe());
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }
    }
    ,
    THROW_BIT("throw.bit", 19){

        public boolean isActive() {
            return ChiselsAndBitsAPIAccess.apiInstance.getItemType(KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe()) == ItemType.CHISLED_BIT;
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }
    }
    ,
    THROW_BIT_BIT_BAG("throw.bit.bitbag", 19){

        public boolean isActive() {
            return ChiselsAndBitsAPIAccess.apiInstance.getItemType(KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe()) == ItemType.BIT_BAG;
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }
    }
    ,
    OPEN_CHISELED_ARMOR_GUI_MAIN("chiseledarmor.main", 34){

        public boolean isActive() {
            return true;
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }
    }
    ,
    OPEN_CHISELED_ARMOR_GUI_VANITY("chiseledarmor.vanity", 34){

        public boolean isActive() {
            return true;
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }

        @Override
        protected KeyModifier getModifier() {
            return KeyModifier.SHIFT;
        }
    }
    ,
    OPEN_CHISELED_ARMOR_SLOTS_GUI("chiseledarmor.slots", 35){

        public boolean isActive() {
            return true;
        }

        @Override
        public boolean conflicts(IKeyConflictContext other) {
            return this.conflictsInGame(other);
        }
    }
    ,
    OPEN_BIT_MAPPING_GUI("bitmapping", 19, false){

        public boolean isActive() {
            return ItemStackHelper.isModelingToolStack(KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe());
        }
    }
    ,
    SHIFT("Shift", 0, true){

        @Override
        public boolean isKeyDown() {
            return this.isKeyDown(GuiScreen.func_146272_n());
        }

        public boolean isActive() {
            ItemStack stack = KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe();
            return ItemStackHelper.isSculptingToolStack(stack) || ItemStackHelper.isModelingToolStack(stack) || ItemStackHelper.isBitWrenchStack(stack);
        }
    }
    ,
    CONTROL("Control", 0, true){

        @Override
        public boolean isKeyDown() {
            return this.isKeyDown(GuiScreen.func_146271_m());
        }

        public boolean isActive() {
            ItemStack stack = KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe();
            return ItemStackHelper.isSculptingToolStack(stack) || ItemStackHelper.isModelingToolStack(stack) || ItemStackHelper.isChiseledArmorStack(stack);
        }
    }
    ,
    ALT("Alt", 45, false){

        @Override
        public boolean isKeyDown() {
            return this.isKeyDown(GuiScreen.func_175283_s());
        }

        public boolean isActive() {
            ItemStack stack = KeyBindingsExtraBitManipulation.getHeldItemMainhandSafe();
            return ItemStackHelper.isSculptingToolStack(stack) || ItemStackHelper.isChiseledArmorStack(stack);
        }

        @Override
        public String getText() {
            return this.keyBinding.func_151463_i() == 0 ? this.description.toUpperCase() : "[" + this.keyBinding.getDisplayName() + "]";
        }
    };

    protected KeyBinding keyBinding;
    protected String description;
    private int defaultKeyCode;
    private boolean anyConflicts;

    private KeyBindingsExtraBitManipulation(String description, int defaultKeyCode) {
        this(description, defaultKeyCode, false);
    }

    private KeyBindingsExtraBitManipulation(String description, int defaultKeyCode, boolean anyConflicts) {
        this.description = description;
        this.defaultKeyCode = defaultKeyCode;
        this.anyConflicts = anyConflicts;
    }

    public boolean isKeyDown() {
        return this.getKeyBinding().func_151470_d();
    }

    protected boolean isKeyDown(boolean defaultCheck) {
        return this.getKeyBinding().func_151463_i() == 0 ? defaultCheck : this.getKeyBinding().func_151470_d();
    }

    public static void init() {
        for (KeyBindingsExtraBitManipulation keyBinding : KeyBindingsExtraBitManipulation.values()) {
            keyBinding.registerKeyBinding();
        }
    }

    protected KeyModifier getModifier() {
        return KeyModifier.NONE;
    }

    private void registerKeyBinding() {
        this.keyBinding = new KeyBinding("keybinding.extrabitmanipulation." + this.description.toLowerCase(), (IKeyConflictContext)this, this.getModifier(), this.defaultKeyCode, "itemGroup.extrabitmanipulation");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
    }

    public String getText() {
        return this.keyBinding.isSetToDefaultValue() ? this.description.toUpperCase() : "[" + this.keyBinding.getDisplayName() + "]";
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    public boolean conflicts(IKeyConflictContext other) {
        return this.conflictsInGame(other) || other == SHIFT || other == CONTROL || this.anyConflicts && (other == ALT || other == OPEN_BIT_MAPPING_GUI);
    }

    protected boolean conflictsInGame(IKeyConflictContext other) {
        return other == this || other == KeyConflictContext.IN_GAME;
    }

    private static ItemStack getHeldItemMainhandSafe() {
        return ClientHelper.getPlayer() == null ? ItemStack.field_190927_a : ClientHelper.getHeldItemMainhand();
    }
}

