/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.item;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.config.ConfigProperty;
import com.phylogeny.extrabitmanipulation.helper.BitAreaHelper;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.KeyBindingsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.AsymmetricalShape;
import com.phylogeny.extrabitmanipulation.shape.Cone;
import com.phylogeny.extrabitmanipulation.shape.ConeElliptic;
import com.phylogeny.extrabitmanipulation.shape.Cube;
import com.phylogeny.extrabitmanipulation.shape.Cuboid;
import com.phylogeny.extrabitmanipulation.shape.Cylinder;
import com.phylogeny.extrabitmanipulation.shape.CylinderElliptic;
import com.phylogeny.extrabitmanipulation.shape.Ellipsoid;
import com.phylogeny.extrabitmanipulation.shape.PrismIsoscelesTriangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidIsoscelesTriangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidRectangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidSquare;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import com.phylogeny.extrabitmanipulation.shape.Sphere;
import com.phylogeny.extrabitmanipulation.shape.SymmetricalShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemSculptingTool
extends ItemBitToolBase {
    public static final String[] MODE_TITLES = new String[]{"Local", "Global", "Drawn"};
    private boolean curved;
    private boolean removeBits;

    public ItemSculptingTool(boolean curved, boolean removeBits, String name) {
        super(name);
        this.curved = curved;
        this.removeBits = removeBits;
    }

    public boolean isCurved() {
        return this.curved;
    }

    public boolean removeBits() {
        return this.removeBits;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemStackHelper.hasKey(stack, "remainingUses") && ItemStackHelper.getNBT(stack).func_74762_e("remainingUses") < ((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).maxDamage;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getDurability(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)((float)(Math.max(0.0, this.getDurability(stack)) / 3.0)), (float)1.0f, (float)1.0f);
    }

    private double getDurability(ItemStack stack) {
        return (double)ItemStackHelper.getNBTOrNew(stack).func_74762_e("remainingUses") / (double)((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).maxDamage;
    }

    @Override
    public boolean initialize(ItemStack stack) {
        super.initialize(stack);
        NBTTagCompound nbt = stack.func_77978_p();
        this.initInt(nbt, "remainingUses", ((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).maxDamage);
        return true;
    }

    public NBTTagCompound initialize(ItemStack stack, BitToolSettingsHelper.SculptingData sculptingData) {
        NBTTagCompound nbt = BitToolSettingsHelper.initNBT(stack);
        this.initInt(nbt, "remainingUses", ((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).maxDamage);
        this.initInt(nbt, "sculptingMode", sculptingData.getSculptMode());
        this.initInt(nbt, "sculptSemiDiameter", sculptingData.getSemiDiameter());
        this.initInt(nbt, "direction", sculptingData.getDirection());
        this.initBoolean(nbt, "targetBitGridVertexes", sculptingData.isBitGridTargeted());
        this.initInt(nbt, "shapeType", sculptingData.getShapeType());
        this.initBoolean(nbt, "sculptHollowShape", sculptingData.isHollowShape());
        this.initBoolean(nbt, "openEnds", sculptingData.areEndsOpen());
        this.initInt(nbt, "wallThickness", sculptingData.getWallThickness());
        if (!nbt.func_74764_b("setBit") && !sculptingData.getBitStack().func_190926_b()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            sculptingData.getBitStack().func_77955_b(nbt2);
            nbt.func_74782_a("setBit", (NBTBase)nbt2);
        }
        this.initBoolean(nbt, "offsetShape", sculptingData.isShapeOffset());
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sculptBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, Vec3d hit, Vec3d drawnStartPoint, BitToolSettingsHelper.SculptingData sculptingData) {
        block49: {
            AxisAlignedBB box;
            Shape shape;
            float hitZ;
            float hitY;
            float hitX;
            IBitLocation bitLoc;
            boolean globalMode;
            ItemStack setBitStack = sculptingData.getBitStack();
            if (setBitStack.func_190926_b() && !this.removeBits) {
                return false;
            }
            if (!world.field_72995_K) {
                this.initialize(stack);
                player.field_71069_bz.func_75142_b();
            }
            NBTTagCompound nbt = this.initialize(stack, sculptingData);
            IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
            boolean inside = ItemSculptingTool.wasInsideClicked(side, hit, pos);
            if (!this.removeBits && !inside) {
                pos = pos.func_177972_a(side);
            }
            boolean bl = globalMode = sculptingData.getSculptMode() == 1;
            if (drawnStartPoint == null && !globalMode && !this.isValidBlock(api, world, pos) || (bitLoc = api.getBitPos(hitX = (float)hit.field_72450_a - (float)pos.func_177958_n(), hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false)) == null) break block49;
            int direction = sculptingData.getDirection();
            int shapeType = sculptingData.getShapeType();
            boolean hollowShape = sculptingData.isHollowShape();
            boolean openEnds = sculptingData.areEndsOpen();
            float wallThickness = (float)sculptingData.getWallThickness() * 0.0625f;
            float padding = sculptingData.getSemiDiameterPadding();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float x2 = (float)x + (float)bitLoc.getBitX() * 0.0625f;
            float y2 = (float)y + (float)bitLoc.getBitY() * 0.0625f;
            float z2 = (float)z + (float)bitLoc.getBitZ() * 0.0625f;
            if (shapeType != 4 && shapeType != 5) {
                direction %= 6;
            }
            if (drawnStartPoint != null) {
                switch (shapeType) {
                    case 1: {
                        shape = new CylinderElliptic();
                        break;
                    }
                    case 2: {
                        shape = new ConeElliptic();
                        break;
                    }
                    case 3: {
                        shape = new Cuboid();
                        break;
                    }
                    case 4: {
                        shape = new PrismIsoscelesTriangular();
                        break;
                    }
                    case 5: {
                        shape = new PyramidIsoscelesTriangular();
                        break;
                    }
                    case 6: {
                        shape = new PyramidRectangular();
                        break;
                    }
                    default: {
                        shape = new Ellipsoid();
                    }
                }
                float x3 = (float)drawnStartPoint.field_72450_a;
                float y3 = (float)drawnStartPoint.field_72448_b;
                float z3 = (float)drawnStartPoint.field_72449_c;
                float minX = this.addPaddingToMin(x2, x3, padding);
                float minY = this.addPaddingToMin(y2, y3, padding);
                float minZ = this.addPaddingToMin(z2, z3, padding);
                float maxX = this.addPaddingToMax(x2, x3, padding);
                float maxY = this.addPaddingToMax(y2, y3, padding);
                float maxZ = this.addPaddingToMax(z2, z3, padding);
                box = new AxisAlignedBB(Math.floor(minX), Math.floor(minY), Math.floor(minZ), Math.ceil(maxX), Math.ceil(maxY), Math.ceil(maxZ));
                float f = 0.5f;
                ((AsymmetricalShape)shape).init((maxX *= f) + (minX *= f), (maxY *= f) + (minY *= f), (maxZ *= f) + (minZ *= f), maxX - minX, maxY - minY, maxZ - minZ, direction, hollowShape, wallThickness, openEnds);
            } else {
                int blockSemiDiameter;
                switch (shapeType) {
                    case 1: {
                        shape = new Cylinder();
                        break;
                    }
                    case 2: {
                        shape = new Cone();
                        break;
                    }
                    case 3: {
                        shape = new Cube();
                        break;
                    }
                    case 4: {
                        shape = new PrismIsoscelesTriangular();
                        break;
                    }
                    case 5: {
                        shape = new PyramidIsoscelesTriangular();
                        break;
                    }
                    case 6: {
                        shape = new PyramidSquare();
                        break;
                    }
                    default: {
                        shape = new Sphere();
                    }
                }
                int semiDiameter = sculptingData.getSemiDiameter();
                int n = blockSemiDiameter = globalMode ? (int)Math.ceil((double)semiDiameter / 16.0) : 0;
                if (sculptingData.isShapeOffset() && !this.removeBits) {
                    int offsetX = side.func_82601_c();
                    int offsetY = side.func_96559_d();
                    int offsetZ = side.func_82599_e();
                    x2 += (float)offsetX * 0.0625f * (float)semiDiameter;
                    y2 += (float)offsetY * 0.0625f * (float)semiDiameter;
                    z2 += (float)offsetZ * 0.0625f * (float)semiDiameter;
                    x += offsetX * blockSemiDiameter;
                    y += offsetY * blockSemiDiameter;
                    z += offsetZ * blockSemiDiameter;
                }
                box = new AxisAlignedBB((double)(x - blockSemiDiameter), (double)(y - blockSemiDiameter), (double)(z - blockSemiDiameter), (double)(x + blockSemiDiameter), (double)(y + blockSemiDiameter), (double)(z + blockSemiDiameter));
                float f = 0.0f;
                Vec3d vecOffset = new Vec3d(0.0, 0.0, 0.0);
                if (sculptingData.isBitGridTargeted()) {
                    f = 0.03125f;
                    vecOffset = BitAreaHelper.getBitGridOffset(side, inside, hitX, hitY, hitZ, this.removeBits);
                }
                if (shapeType == 4 || shapeType == 5) {
                    AsymmetricalShape asymmetricalShape = shape;
                    asymmetricalShape.setEquilateral(true);
                    float radius = this.addPadding(semiDiameter, padding) - f;
                    asymmetricalShape.init(x2 + f * (float)vecOffset.field_72450_a, y2 + f * (float)vecOffset.field_72448_b, z2 + f * (float)vecOffset.field_72449_c, radius, radius, radius, direction, hollowShape, wallThickness, openEnds);
                } else {
                    ((SymmetricalShape)shape).init(x2 + f * (float)vecOffset.field_72450_a, y2 + f * (float)vecOffset.field_72448_b, z2 + f * (float)vecOffset.field_72449_c, this.addPadding(semiDiameter, padding) - f, direction, hollowShape, wallThickness, openEnds);
                }
            }
            boolean creativeMode = player.field_71075_bZ.field_75098_d;
            HashMap<IBlockState, Integer> bitTypes = null;
            if (this.removeBits && !world.field_72995_K && !creativeMode) {
                bitTypes = new HashMap<IBlockState, Integer>();
            }
            int initialpossibleUses = Integer.MAX_VALUE;
            IBitBrush setBit = null;
            try {
                setBit = api.createBrush(setBitStack);
                if (!this.removeBits && !creativeMode) {
                    initialpossibleUses = BitInventoryHelper.countInventoryBits(api, player, setBitStack);
                }
            }
            catch (APIExceptions.InvalidBitItem asymmetricalShape) {
                // empty catch block
            }
            int remainingUses = nbt.func_74762_e("remainingUses");
            if (!creativeMode && initialpossibleUses > remainingUses) {
                initialpossibleUses = remainingUses;
            }
            int possibleUses = initialpossibleUses;
            boolean changed = false;
            try {
                api.beginUndoGroup(player);
                int i = (int)box.field_72340_a;
                while ((double)i <= box.field_72336_d) {
                    int j = (int)box.field_72338_b;
                    while ((double)j <= box.field_72337_e) {
                        int k = (int)box.field_72339_c;
                        while ((double)k <= box.field_72334_f) {
                            if (possibleUses > 0) {
                                possibleUses = this.sculptBlock(api, player, world, new BlockPos(i, j, k), shape, bitTypes, possibleUses, setBit);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                api.endUndoGroup(player);
                if (!world.field_72995_K && !Configs.dropBitsPerBlock) {
                    BitInventoryHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
                }
                int change = initialpossibleUses - possibleUses;
                int newRemainingUses = remainingUses - (((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).takesDamage ? change : 0);
                if (!world.field_72995_K && !creativeMode) {
                    nbt.func_74768_a("remainingUses", newRemainingUses);
                    if (!this.removeBits) {
                        BitInventoryHelper.removeOrAddInventoryBits(api, player, setBitStack, change, false);
                    }
                    if (newRemainingUses <= 0) {
                        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)player.func_184600_cs());
                    }
                    player.field_71069_bz.func_75142_b();
                }
                if (!creativeMode && newRemainingUses <= 0) {
                    player.func_70669_a(stack);
                }
                boolean bl2 = changed = possibleUses < initialpossibleUses;
                if (changed) {
                    ItemSculptingTool.playPlacementSound(player, world, pos, 8.0f);
                }
                throw throwable;
            }
            api.endUndoGroup(player);
            if (!world.field_72995_K && !Configs.dropBitsPerBlock) {
                BitInventoryHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
            }
            int change = initialpossibleUses - possibleUses;
            int newRemainingUses = remainingUses - (((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).takesDamage ? change : 0);
            if (!world.field_72995_K && !creativeMode) {
                nbt.func_74768_a("remainingUses", newRemainingUses);
                if (!this.removeBits) {
                    BitInventoryHelper.removeOrAddInventoryBits(api, player, setBitStack, change, false);
                }
                if (newRemainingUses <= 0) {
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)player.func_184600_cs());
                }
                player.field_71069_bz.func_75142_b();
            }
            if (!creativeMode && newRemainingUses <= 0) {
                player.func_70669_a(stack);
            }
            boolean bl3 = changed = possibleUses < initialpossibleUses;
            if (changed) {
                ItemSculptingTool.playPlacementSound(player, world, pos, 8.0f);
            }
            return changed;
        }
        return false;
    }

    public static void playPlacementSound(EntityPlayer player, World world, BlockPos pos, float volumeReduction) {
        SoundType sound = Blocks.field_150348_b.func_185467_w();
        world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, sound.func_185843_a() / volumeReduction, sound.func_185847_b() * 0.8f);
    }

    private float addPadding(float value, float padding) {
        return (value + padding) * 0.0625f;
    }

    private float addPaddingToMin(float value1, float value2, float padding) {
        return Math.min(value1, value2) - padding * 0.0625f;
    }

    private float addPaddingToMax(float value1, float value2, float padding) {
        return Math.max(value1, value2) + padding * 0.0625f;
    }

    public static boolean wasInsideClicked(EnumFacing dir, Vec3d hit, BlockPos pos) {
        if (hit != null) {
            switch (dir.ordinal()) {
                case 0: {
                    return hit.field_72448_b > (double)pos.func_177956_o();
                }
                case 1: {
                    return hit.field_72448_b < (double)(pos.func_177956_o() + 1);
                }
                case 2: {
                    return hit.field_72449_c > (double)pos.func_177952_p();
                }
                case 3: {
                    return hit.field_72449_c < (double)(pos.func_177952_p() + 1);
                }
                case 4: {
                    return hit.field_72450_a > (double)pos.func_177958_n();
                }
                case 5: {
                    return hit.field_72450_a < (double)(pos.func_177958_n() + 1);
                }
            }
        }
        return false;
    }

    private int sculptBlock(IChiselAndBitsAPI api, EntityPlayer player, World world, BlockPos pos, Shape shape, Map<IBlockState, Integer> bitTypes, int remainingUses, IBitBrush setBit) {
        if (this.isValidBlock(api, world, pos)) {
            IBitAccess bitAccess;
            try {
                bitAccess = api.getBitAccess(world, pos);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                return remainingUses;
            }
            boolean byPassBitChecks = shape.isBlockInsideShape(pos);
            int initialRemainingUses = remainingUses;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        IBitBrush bit = bitAccess.getBitAt(i, j, k);
                        if (!(this.removeBits ? !bit.isAir() && (setBit == null || setBit.isAir() || setBit.getState().equals(bit.getState())) : bit.isAir()) || !byPassBitChecks && !shape.isPointInsideShape(pos, i, j, k)) continue;
                        if (bitTypes != null) {
                            IBlockState state = bit.getState();
                            if (!bitTypes.containsKey(state)) {
                                bitTypes.put(state, 1);
                            } else {
                                bitTypes.put(state, bitTypes.get(state) + 1);
                            }
                        }
                        try {
                            bitAccess.setBitAt(i, j, k, this.removeBits ? null : setBit);
                            --remainingUses;
                        }
                        catch (APIExceptions.SpaceOccupied spaceOccupied) {
                            // empty catch block
                        }
                        if (remainingUses != 0) continue;
                        bitAccess.commitChanges(true);
                        return remainingUses;
                    }
                }
            }
            if (!world.field_72995_K && Configs.dropBitsPerBlock) {
                BitInventoryHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
            }
            if (remainingUses < initialRemainingUses) {
                bitAccess.commitChanges(true);
            }
        }
        return remainingUses;
    }

    private boolean isValidBlock(IChiselAndBitsAPI api, World world, BlockPos pos) {
        return api.canBeChiseled(world, pos) && (!this.removeBits || !world.func_175623_d(pos));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        boolean shiftDown = GuiScreen.func_146272_n();
        boolean ctrlDown = GuiScreen.func_146271_m();
        ItemSculptingTool.addColorInformation(tooltip, shiftDown);
        NBTTagCompound nbt = stack.func_77978_p();
        int mode = BitToolSettingsHelper.getSculptMode(nbt);
        if (shiftDown) {
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getSculptModeText(mode), Configs.sculptMode));
        }
        ItemStack setBitStack = BitToolSettingsHelper.getBitStack(nbt, this.removeBits);
        if (!ctrlDown || shiftDown) {
            String bitType = "Bit Type To " + (this.removeBits ? "Remove" : "Add") + ": ";
            if (!setBitStack.func_190926_b()) {
                String name;
                String bitStateName = "N/A";
                IBlockState state = ModUtil.getStateById((int)ItemChiseledBit.getStackState((ItemStack)setBitStack));
                if (state != null && (name = ItemChiseledBit.getBitStateName((IBlockState)state)) != null) {
                    bitStateName = name;
                }
                bitType = bitType + bitStateName;
            } else {
                bitType = bitType + (this.removeBits ? "any" : "none");
            }
            tooltip.add(ItemSculptingTool.colorSettingText(bitType, this.removeBits ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade));
        }
        if (shiftDown) {
            int shapeType = BitToolSettingsHelper.getShapeType(nbt, this.curved);
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getDirectionText(nbt, shapeType == 4 || shapeType == 5), Configs.sculptDirection));
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getShapeTypeText(shapeType), this.removeBits ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat));
            boolean targetBits = BitToolSettingsHelper.isBitGridTargeted(nbt);
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getBitGridTargetedText(targetBits), Configs.sculptTargetBitGridVertexes) + (targetBits ? " (corners)" : " (centers)"));
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getSemiDiameterText(nbt), Configs.sculptSemiDiameter));
            if (!this.removeBits) {
                tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getOffsetShapeText(nbt), Configs.sculptOffsetShape));
            }
            tooltip.add(ItemSculptingTool.colorSettingText(BitToolSettingsHelper.getHollowShapeText(nbt, this), this.removeBits ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade));
            tooltip.add(ItemSculptingTool.colorSettingText("  - " + BitToolSettingsHelper.getOpenEndsText(nbt), Configs.sculptOpenEnds));
            tooltip.add(ItemSculptingTool.colorSettingText("  - " + BitToolSettingsHelper.getWallThicknessText(nbt), Configs.sculptWallThickness));
        } else if (ctrlDown) {
            String toFromText;
            String shiftText = ItemSculptingTool.getColoredKeyBindText(KeyBindingsExtraBitManipulation.SHIFT);
            String removeAddText = this.removeBits ? "remove" : "add";
            String string = toFromText = this.removeBits ? "from" : "to";
            if (mode == 2) {
                tooltip.add("Left click point on block, drag");
                tooltip.add("    to another point, then");
                tooltip.add("    release to " + removeAddText + " bits " + toFromText);
                tooltip.add("    all intersecting blocks.");
            } else {
                String shapeControlText = "Left click block to " + removeAddText + " bits";
                if (mode == 0) {
                    shapeControlText = shapeControlText + ".";
                }
                tooltip.add(shapeControlText);
                if (mode != 0) {
                    String areaText = toFromText;
                    tooltip.add("    " + areaText + " all intersecting blocks.");
                }
            }
            tooltip.add("Right click to cycle modes.");
            if (!this.removeBits) {
                tooltip.add(shiftText + " left click bit to set bit type.");
            }
            tooltip.add(shiftText + " mouse wheel to change");
            tooltip.add("    " + (this.removeBits ? "removal" : "addition") + (Configs.displayNameDiameter ? " " : " semi-") + "diameter.");
            tooltip.add("");
            String controlText = ItemSculptingTool.getColoredKeyBindText(KeyBindingsExtraBitManipulation.CONTROL);
            tooltip.add(controlText + " right click to");
            tooltip.add("    change shape.");
            tooltip.add(controlText + " left click to toggle");
            tooltip.add("    target between");
            tooltip.add("    bits & vertecies.");
            tooltip.add(controlText + " mouse wheel to");
            tooltip.add("    change direction.");
            tooltip.add("");
            String altText = ItemSculptingTool.getColoredKeyBindText(KeyBindingsExtraBitManipulation.ALT);
            tooltip.add(altText + " right click to toggle");
            tooltip.add("    shapes solid or hollow.");
            tooltip.add(altText + " left click to toggle hollow");
            tooltip.add("    shapes open or closed.");
            tooltip.add(altText + " mouse wheel to change hollow");
            tooltip.add("    shape wall thickness.");
            ItemSculptingTool.addKeybindReminders(tooltip, KeyBindingsExtraBitManipulation.SHIFT, KeyBindingsExtraBitManipulation.CONTROL, KeyBindingsExtraBitManipulation.ALT);
        } else {
            ItemSculptingTool.addKeyInformation(tooltip, true);
        }
    }
}

