/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketChangeChiseledArmorList;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChangeGlOperationList
extends PacketChangeChiseledArmorList {
    private String nbtKey;

    public PacketChangeGlOperationList() {
    }

    public PacketChangeGlOperationList(NBTTagCompound nbt, String nbtKey, EntityEquipmentSlot equipmentSlot, boolean mainArmor, int partIndex, int armorItemIndex, int selectedEntry, boolean refreshLists) {
        super(nbt, equipmentSlot, mainArmor, partIndex, armorItemIndex, selectedEntry, refreshLists);
        this.nbtKey = nbtKey;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.nbtKey);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.nbtKey = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketChangeGlOperationList, IMessage> {
        public IMessage onMessage(final PacketChangeGlOperationList message, final MessageContext ctx) {
            final boolean serverSide = ctx.side == Side.SERVER;
            IThreadListener mainThread = serverSide ? (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p : ClientHelper.getThreadListener();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Object player = serverSide ? ctx.getServerHandler().field_147369_b : ClientHelper.getPlayer();
                    ItemStack stack = ItemStackHelper.getChiseledArmorStack(player, message.equipmentSlot, message.mainArmor);
                    if (!ItemStackHelper.isChiseledArmorStack(stack)) {
                        return;
                    }
                    message.initData(message, stack);
                    NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
                    NBTTagCompound data = message.getData(nbt, serverSide);
                    NBTTagList glOperationList = message.nbt.func_150295_c(message.nbtKey, 10);
                    if (message.nbtKey.equals("glOperations")) {
                        NBTTagList movingParts = data.func_150295_c("partData", 9);
                        NBTBase nbtBase = movingParts.func_179238_g(message.partIndex);
                        if (nbtBase.func_74732_a() != 9) {
                            return;
                        }
                        NBTTagList itemList = (NBTTagList)nbtBase;
                        NBTTagCompound armorItemNbt = itemList.func_150305_b(message.armorItemIndex);
                        armorItemNbt.func_74782_a(message.nbtKey, (NBTBase)glOperationList);
                        itemList.func_150304_a(message.armorItemIndex, (NBTBase)armorItemNbt);
                        data.func_74782_a("partData", (NBTBase)movingParts);
                    } else {
                        data.func_74782_a(message.nbtKey, (NBTBase)glOperationList);
                    }
                    message.finalizeDataChange(message, stack, nbt, data, serverSide, false, false, -1);
                    if (serverSide) {
                        ExtraBitManipulation.packetNetwork.sendTo((IMessage)new PacketChangeGlOperationList(message.nbt, message.nbtKey, message.equipmentSlot, message.mainArmor, message.partIndex, message.armorItemIndex, message.selectedEntry, message.refreshLists), (EntityPlayerMP)player);
                    }
                }
            });
            return null;
        }
    }
}

