/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.entity.EntityBit;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlaceEntityBit
implements IMessage {
    private ItemStack bitStack;
    private BlockPos pos;
    private Vec3d hitVec;
    private EnumFacing sideHit;

    public PacketPlaceEntityBit() {
    }

    public PacketPlaceEntityBit(ItemStack bitStack, BlockPos pos, RayTraceResult result) {
        this.bitStack = bitStack;
        this.pos = pos;
        this.hitVec = result.field_72307_f;
        this.sideHit = result.field_178784_b;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bitStack);
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeDouble(this.hitVec.field_72450_a);
        buffer.writeDouble(this.hitVec.field_72448_b);
        buffer.writeDouble(this.hitVec.field_72449_c);
        buffer.writeInt(this.sideHit.ordinal());
    }

    public void fromBytes(ByteBuf buffer) {
        this.bitStack = ByteBufUtils.readItemStack((ByteBuf)buffer);
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.hitVec = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.sideHit = EnumFacing.func_82600_a((int)buffer.readInt());
    }

    public static class Handler
    implements IMessageHandler<PacketPlaceEntityBit, IMessage> {
        public IMessage onMessage(final PacketPlaceEntityBit message, MessageContext ctx) {
            ClientHelper.getThreadListener().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityBit.placeBit(ClientHelper.getWorld(), message.bitStack, message.pos, message.hitVec, message.sideHit, false);
                }
            });
            return null;
        }
    }
}

