/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketEquipmentSlot;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetArmorScale
extends PacketEquipmentSlot {
    private int scale;

    public PacketSetArmorScale() {
    }

    public PacketSetArmorScale(int scale, @Nullable EntityEquipmentSlot equipmentSlot, boolean mainArmor) {
        super(equipmentSlot, mainArmor);
        this.scale = scale;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.scale);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.scale = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketSetArmorScale, IMessage> {
        public IMessage onMessage(final PacketSetArmorScale message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = ItemStackHelper.getChiseledArmorStack((EntityPlayer)player, message.equipmentSlot, message.mainArmor);
                    if (ItemStackHelper.isChiseledArmorStack(stack)) {
                        BitToolSettingsHelper.setArmorScale((EntityPlayer)player, stack, message.scale, null, message.equipmentSlot, message.mainArmor);
                    }
                }
            });
            return null;
        }
    }
}

