/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class EntityFXFacingParticle
extends EntityComplexFX {
    public static final BindableResource staticFlareTex = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "flarestatic");
    private double x;
    private double y;
    private double z;
    private double oldX;
    private double oldY;
    private double oldZ;
    private double yGravity = 0.004;
    private float scale = 1.0f;
    private EntityComplexFX.AlphaFunction fadeFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private EntityComplexFX.RenderOffsetController renderOffsetController = null;
    private float alphaMultiplier = 1.0f;
    private float colorRed = 1.0f;
    private float colorGreen = 1.0f;
    private float colorBlue = 1.0f;
    private double motionX = 0.0;
    private double motionY = 0.0;
    private double motionZ = 0.0;

    public EntityFXFacingParticle(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.oldX = x;
        this.oldY = y;
        this.oldZ = z;
    }

    public EntityFXFacingParticle updatePosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public EntityFXFacingParticle offset(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public EntityFXFacingParticle enableAlphaFade(@Nonnull EntityComplexFX.AlphaFunction function) {
        this.fadeFunction = function;
        return this;
    }

    public EntityFXFacingParticle setRenderOffsetController(EntityComplexFX.RenderOffsetController renderOffsetController) {
        this.renderOffsetController = renderOffsetController;
        return this;
    }

    public EntityFXFacingParticle motion(double x, double y, double z) {
        this.motionX = x;
        this.motionY = y;
        this.motionZ = z;
        return this;
    }

    public EntityFXFacingParticle gravity(double yGrav) {
        this.yGravity -= yGrav;
        return this;
    }

    public EntityFXFacingParticle scale(float scale) {
        this.scale = scale;
        return this;
    }

    public EntityFXFacingParticle setAlphaMultiplier(float alphaMul) {
        this.alphaMultiplier = alphaMul;
        return this;
    }

    public EntityFXFacingParticle setColor(Color color) {
        this.colorRed = (float)color.getRed() / 255.0f;
        this.colorGreen = (float)color.getGreen() / 255.0f;
        this.colorBlue = (float)color.getBlue() / 255.0f;
        return this;
    }

    public Vector3 getPosition() {
        return new Vector3(this.x, this.y, this.z);
    }

    @Override
    public void tick() {
        super.tick();
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldZ = this.z;
        this.x += this.motionX;
        this.y += this.motionY - this.yGravity;
        this.z += this.motionZ;
    }

    public static <T extends EntityFXFacingParticle> void renderFast(float parTicks, List<T> particles) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        staticFlareTex.bind();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (EntityFXFacingParticle particle : new ArrayList<T>(particles)) {
            if (particle == null) continue;
            particle.renderFast(parTicks, vb);
        }
        t.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
    }

    public void renderFast(float pTicks, BufferBuilder vbDrawing) {
        float alpha = this.fadeFunction.getAlpha(this.age, this.maxAge);
        alpha *= this.alphaMultiplier;
        double intX = RenderingUtils.interpolate(this.oldX, this.x, pTicks);
        double intY = RenderingUtils.interpolate(this.oldY, this.y, pTicks);
        double intZ = RenderingUtils.interpolate(this.oldZ, this.z, pTicks);
        if (this.renderOffsetController != null) {
            Vector3 result = this.renderOffsetController.changeRenderPosition(this, new Vector3(intX, intY, intZ), new Vector3(this.motionX, this.motionY - this.yGravity, this.motionZ), pTicks);
            intX = result.getX();
            intY = result.getY();
            intZ = result.getZ();
        }
        RenderingUtils.renderFacingFullQuadVB(vbDrawing, intX, intY, intZ, pTicks, this.scale, 0.0f, this.colorRed, this.colorGreen, this.colorBlue, alpha);
    }

    @Override
    public void render(float pTicks) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        float alpha = this.fadeFunction.getAlpha(this.age, this.maxAge);
        GL11.glColor4f((float)this.colorRed, (float)this.colorGreen, (float)this.colorBlue, (float)(alpha *= this.alphaMultiplier));
        staticFlareTex.bind();
        RenderingUtils.renderFacingQuad(this.interpolate(this.oldX, this.x, pTicks), this.interpolate(this.oldY, this.y, pTicks), this.interpolate(this.oldZ, this.z, pTicks), pTicks, this.scale, 0.0f, 0.0, 0.0, 1.0, 1.0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
    }

    private double interpolate(double oldP, double newP, float partial) {
        return oldP + (newP - oldP) * (double)partial;
    }
}

