/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

public class ScalingPoint {
    private double posX;
    private double posY;
    private double scaledX;
    private double scaledY;

    ScalingPoint() {
    }

    public static ScalingPoint createPoint(double posX, double posY, double scale, boolean arePositionsScaled) {
        ScalingPoint sp = new ScalingPoint();
        if (arePositionsScaled) {
            sp.updateScaledPos(posX, posY, scale);
        } else {
            sp.updatePos(posX, posY, scale);
        }
        return sp;
    }

    public void updatePos(double posX, double posY, double scale) {
        this.posX = posX;
        this.posY = posY;
        this.scaledX = scale * this.posX;
        this.scaledY = scale * this.posY;
    }

    public void updateScaledPos(double scaledX, double scaledY, double scale) {
        this.scaledX = scaledX;
        this.scaledY = scaledY;
        this.posX = this.scaledX / scale;
        this.posY = this.scaledY / scale;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getScaledPosX() {
        return this.scaledX;
    }

    public double getScaledPosY() {
        return this.scaledY;
    }

    public void rescale(double newScale) {
        this.scaledX = this.posX * newScale;
        this.scaledY = this.posY * newScale;
    }
}

