/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.base.sets.OreEntry;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.ConfigDataAdapter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreTypes
implements ConfigDataAdapter<OreEntry> {
    public static final OreTypes RITUAL_MINERALIS = new OreTypes("mineralis_ritual");
    public static final OreTypes AEVITAS_ORE_PERK = new OreTypes("aevitas_ore_perk");
    public static final OreTypes TREASURE_SHRINE_GEN = new OreTypes("treasure_shrine");
    private List<OreEntry> oreDictWeights = new LinkedList<OreEntry>();
    private double totalWeight = 0.0;
    private final String name;

    private OreTypes(String name) {
        this.name = name;
    }

    @Override
    public Iterable<OreEntry> getDefaultDataSets() {
        LinkedList<OreEntry> entries = new LinkedList<OreEntry>();
        entries.add(new OreEntry("oreCoal", 5200));
        entries.add(new OreEntry("oreIron", 2500));
        entries.add(new OreEntry("oreGold", 550));
        entries.add(new OreEntry("oreLapis", 140));
        entries.add(new OreEntry("oreRedstone", 700));
        entries.add(new OreEntry("oreDiamond", 180));
        entries.add(new OreEntry("oreEmerald", 100));
        entries.add(new OreEntry("oreAluminum", 600));
        entries.add(new OreEntry("oreCopper", 1100));
        entries.add(new OreEntry("oreTin", 1500));
        entries.add(new OreEntry("oreLead", 1000));
        entries.add(new OreEntry("oreCertusQuartz", 500));
        entries.add(new OreEntry("oreNickel", 270));
        entries.add(new OreEntry("orePlatinum", 90));
        entries.add(new OreEntry("oreSilver", 180));
        entries.add(new OreEntry("oreMithril", 1));
        entries.add(new OreEntry("oreRuby", 400));
        entries.add(new OreEntry("oreSapphire", 400));
        entries.add(new OreEntry("oreUranium", 550));
        entries.add(new OreEntry("oreYellorite", 560));
        entries.add(new OreEntry("oreZinc", 300));
        entries.add(new OreEntry("oreSulfur", 600));
        entries.add(new OreEntry("oreOsmium", 950));
        return entries;
    }

    private void appendOreEntry(OreEntry entry) {
        this.oreDictWeights.add(entry);
        this.totalWeight += (double)entry.weight;
    }

    @Nonnull
    public ItemStack getRandomOre(Random random) {
        ItemStack result = ItemStack.field_190927_a;
        int runs = 0;
        while (result.func_190926_b() && runs < 150) {
            String key = null;
            double randWeight = (double)random.nextFloat() * this.totalWeight;
            for (OreEntry entry : this.oreDictWeights) {
                if (!((randWeight -= (double)entry.weight) <= 0.0)) continue;
                key = entry.oreName;
                break;
            }
            if (key == null) {
                ++runs;
                continue;
            }
            NonNullList ores = OreDictionary.getOres(key);
            for (ItemStack stack : ores) {
                String className;
                Item i;
                String regModid;
                if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a || Config.modidOreGenBlacklist.contains(regModid = (i = stack.func_77973_b()).getRegistryName().func_110624_b()) || (className = i.getClass().getName()).toLowerCase().contains("greg")) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
                result = stack;
            }
            ++runs;
        }
        return result;
    }

    @Override
    public String getDataFileName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Defines random ore-selection data. Items with higher weight are more likely to be selected overall. Format: <oreDictionaryName>;<integerWeight>";
    }

    @Override
    @Nullable
    public Optional<OreEntry> appendDataSet(String str) {
        OreEntry entry = OreEntry.deserialize(str);
        if (entry == null) {
            return null;
        }
        this.appendOreEntry(entry);
        return Optional.of(entry);
    }
}

