/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLens
extends BlockStarlightNetwork
implements BlockVariants {
    private static final AxisAlignedBB boxLens = new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.90625, 0.84375);
    public static PropertyBool RENDER_FULLY = PropertyBool.func_177716_a((String)"render");

    public BlockLens() {
        super(Material.field_151576_e, MapColor.field_151646_E);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149752_b(12.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RENDER_FULLY, (Comparable)Boolean.valueOf(true)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        ItemStack stack = new ItemStack((Block)this);
        CrystalProperties.applyCrystalProperties(stack, CrystalProperties.getMaxCelestialProperties());
        list.add((Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        CrystalProperties.addPropertyTooltip(CrystalProperties.getCrystalProperties(stack), tooltip, 900);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boxLens;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCrystalLens();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{RENDER_FULLY});
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(this.func_176221_a(state, (IBlockAccess)world, pos), target, world, pos, player);
        TileCrystalLens lens = MiscUtils.getTileAt((IBlockAccess)world, pos, TileCrystalLens.class, true);
        if (lens != null && lens.getCrystalProperties() != null) {
            CrystalProperties.applyCrystalProperties(stack, lens.getCrystalProperties());
        } else {
            CrystalProperties.applyCrystalProperties(stack, CrystalProperties.getMaxCelestialProperties());
        }
        return stack;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileCrystalLens lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalLens.class, true);
        if (lens != null && !worldIn.field_72995_K && !player.func_184812_l_()) {
            ItemStack drop;
            if (lens.getLensColor() != null) {
                drop = lens.getLensColor().asStack();
                ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            }
            drop = new ItemStack((Block)BlocksAS.lens);
            CrystalProperties.applyCrystalProperties(drop, lens.getCrystalProperties());
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileCrystalLens lens;
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && (lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalLens.class, true)) != null && lens.getLensColor() != null) {
            ItemStack drop = lens.getLensColor().asStack();
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            SoundHelper.playSoundAround((SoundEvent)Sounds.clipSwitch, worldIn, (Vec3i)pos, 0.8f, 1.5f);
            lens.setLensColor(null);
            return true;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)RENDER_FULLY, (Comparable)Boolean.valueOf(false));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCrystalLens te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalLens.class, true);
        if (te == null) {
            return;
        }
        te.onPlace(CrystalProperties.getCrystalProperties(stack));
    }

    @Override
    public List<IBlockState> getValidStates() {
        return Arrays.asList(this.func_176223_P().func_177226_a((IProperty)RENDER_FULLY, (Comparable)Boolean.valueOf(false)), this.func_176223_P().func_177226_a((IProperty)RENDER_FULLY, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)RENDER_FULLY)).toString();
    }
}

