/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CapeArmorEffect
extends ConfigEntry {
    protected static final Random rand = new Random();
    private NBTTagCompound data = new NBTTagCompound();

    protected CapeArmorEffect(NBTTagCompound cmp, String key) {
        super(ConfigEntry.Section.CAPE, key);
        this.data = cmp;
    }

    public abstract IConstellation getAssociatedConstellation();

    @SideOnly(value=Side.CLIENT)
    public abstract void playActiveParticleTick(EntityPlayer var1);

    @Override
    public String getConfigurationSection() {
        return super.getConfigurationSection() + "." + this.getKey();
    }

    public final NBTTagCompound getData() {
        return this.data;
    }

    public final void flush(EntityLivingBase entity) {
        ItemStack is = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!is.func_190926_b()) {
            NBTTagCompound cmp = NBTHelper.getPersistentData(is);
            this.flush(cmp);
        }
    }

    public final void flush(NBTTagCompound out) {
        for (String key : this.data.func_150296_c()) {
            out.func_74782_a(key, out.func_74781_a(key));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playConstellationCapeSparkles(EntityPlayer pl, float strength) {
        Color c;
        if (rand.nextFloat() < strength && (c = this.getAssociatedConstellation().getConstellationColor()) != null) {
            double x = pl.field_70165_t + (double)(rand.nextFloat() * pl.field_70130_N) - (double)(pl.field_70130_N / 2.0f);
            double y = pl.field_70163_u + (double)(rand.nextFloat() * (pl.field_70131_O / 2.0f)) + 0.2;
            double z = pl.field_70161_v + (double)(rand.nextFloat() * pl.field_70130_N) - (double)(pl.field_70130_N / 2.0f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.5f + 0.3f);
            if (rand.nextInt(3) == 0) {
                p.setColor(IConstellation.weak);
            }
            p.setMaxAge(30 + rand.nextInt(20));
            if (rand.nextFloat() < 0.8f) {
                p = EffectHelper.genericFlareParticle(x, y, z);
                p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                p.scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setMaxAge(20 + rand.nextInt(10));
            }
        }
    }
}

