/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectHorologium
extends CapeArmorEffect {
    private static float effectRange = 20.0f;
    private static int duration = 180;
    private static int cooldown = 1000;
    private static float chanceProc = 0.4f;

    public CapeEffectHorologium(NBTTagCompound cmp) {
        super(cmp, "horologium");
    }

    public void onHurt(EntityPlayer player) {
        if (player.func_184811_cZ().func_185141_a((Item)ItemsAS.armorImbuedCape)) {
            return;
        }
        if (rand.nextFloat() < chanceProc) {
            TimeStopController.freezeWorldAt((Entity)player, player.field_70170_p, player.func_180425_c(), effectRange, duration);
            player.func_184811_cZ().func_185145_a((Item)ItemsAS.armorImbuedCape, cooldown);
        }
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.horologium;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        float perc = 0.2f;
        if (!pl.func_184811_cZ().func_185141_a((Item)ItemsAS.armorImbuedCape)) {
            perc = 0.35f;
        }
        this.playConstellationCapeSparkles(pl, perc);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        effectRange = cfg.getFloat(this.getKey() + "FreezeRange", this.getConfigurationSection(), effectRange, 4.0f, 64.0f, "Defines the range of the time-freeze effect");
        duration = cfg.getInt(this.getKey() + "Duration", this.getConfigurationSection(), duration, 40, 50000, "Defines the duration of the time-freeze bubble");
        cooldown = cfg.getInt(this.getKey() + "Cooldown", this.getConfigurationSection(), cooldown, 40, 70000, "Defines the cooldown for the time-freeze effect after it triggered (should be longer than duration!)");
        chanceProc = cfg.getFloat(this.getKey() + "TriggerChance", this.getConfigurationSection(), chanceProc, 0.0f, 1.0f, "Defines the chance for the time-freeze effect to trigger when being hit");
    }
}

