/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.distribution;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRequestSeed;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConstellationSkyHandler
implements ITickHandler {
    public static final int SOLAR_ECLIPSE_HALF_DUR = 2400;
    public static final int LUNAR_ECLIPSE_HALF_DUR = 2400;
    private static final ConstellationSkyHandler instance = new ConstellationSkyHandler();
    private static int activeSession = 0;
    private Map<Integer, Long> cacheSeedLookup = new HashMap<Integer, Long>();
    private Map<Integer, WorldSkyHandler> worldHandlersServer = new HashMap<Integer, WorldSkyHandler>();
    private Map<Integer, WorldSkyHandler> worldHandlersClient = new HashMap<Integer, WorldSkyHandler>();

    private ConstellationSkyHandler() {
    }

    public static ConstellationSkyHandler getInstance() {
        return instance;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        if (type == TickEvent.Type.WORLD) {
            World w = (World)context[0];
            if (!w.field_72995_K) {
                WorldSkyHandler handle = this.worldHandlersServer.get(w.field_73011_w.getDimension());
                if (handle == null) {
                    handle = new WorldSkyHandler(new Random(w.func_72905_C()).nextLong());
                    this.worldHandlersServer.put(w.field_73011_w.getDimension(), handle);
                }
                handle.tick(w);
            }
        } else {
            this.handleClientTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientTick() {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w != null) {
            WorldSkyHandler handle = this.worldHandlersClient.get(w.field_73011_w.getDimension());
            if (handle == null) {
                int dim = w.field_73011_w.getDimension();
                if (!this.cacheSeedLookup.containsKey(dim)) {
                    PktRequestSeed req = new PktRequestSeed(activeSession, dim);
                    PacketChannel.CHANNEL.sendToServer((IMessage)req);
                    return;
                }
                long seed = this.cacheSeedLookup.get(dim);
                handle = new WorldSkyHandler(seed);
                this.worldHandlersClient.put(dim, handle);
            }
            handle.tick((World)w);
        }
    }

    public void updateSeedCache(int dimId, int session, long seed) {
        if (activeSession == session) {
            this.cacheSeedLookup.put(dimId, seed);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Optional<Long> getSeedIfPresent(World world) {
        return this.getSeedIfPresent(world.field_73011_w.getDimension());
    }

    @SideOnly(value=Side.CLIENT)
    public Optional<Long> getSeedIfPresent(int dim) {
        if (!this.cacheSeedLookup.containsKey(dim)) {
            PktRequestSeed req = new PktRequestSeed(activeSession, dim);
            PacketChannel.CHANNEL.sendToServer((IMessage)req);
            return Optional.empty();
        }
        return Optional.of(this.cacheSeedLookup.get(dim));
    }

    public float getCurrentDaytimeDistribution(World world) {
        float dayPart = world.func_72820_D() % 24000L;
        if (dayPart < 11000.0f) {
            return 0.0f;
        }
        if (dayPart < 15000.0f) {
            return (dayPart - 11000.0f) / 4000.0f;
        }
        if (dayPart > 20000.0f) {
            return 1.0f - (dayPart - 20000.0f) / 4000.0f;
        }
        return 1.0f;
    }

    public boolean isNight(World world) {
        return (double)this.getCurrentDaytimeDistribution(world) >= 0.65;
    }

    public boolean isDay(World world) {
        return !this.isNight(world);
    }

    @Nullable
    public WorldSkyHandler getWorldHandler(World world) {
        Map<Integer, WorldSkyHandler> handlerMap = world.field_72995_K ? this.worldHandlersClient : this.worldHandlersServer;
        return handlerMap.get(world.field_73011_w.getDimension());
    }

    public void clientClearCache() {
        ++activeSession;
        this.cacheSeedLookup.clear();
        this.worldHandlersClient.clear();
    }

    public void informWorldUnload(World world) {
        this.worldHandlersServer.remove(world.field_73011_w.getDimension());
        this.worldHandlersClient.remove(world.field_73011_w.getDimension());
        this.cacheSeedLookup.remove(world.field_73011_w.getDimension());
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD, TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "ConstellationSkyhandler";
    }
}

