/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.controller.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.controller.OrbitalEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectLucerna
extends ConstellationEffect {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static double range = 256.0;
    private int rememberedTimeout = 0;

    public CEffectLucerna(@Nullable ILocatable origin) {
        super(origin, Constellations.lucerna, "lucerna");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (pedestal.getTicksExisted() % 20 == 0) {
            OrbitalEffectLucerna luc = new OrbitalEffectLucerna();
            OrbitalEffectController ctrl = EffectHandler.getInstance().orbital(luc, luc, luc);
            ctrl.setOffset(new Vector3(pos).add(0.5, 0.5, 0.5));
            ctrl.setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7);
            ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS);
            ctrl.setTicksPerRotation(20 + rand.nextInt(20));
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        int toAdd = 1 + rand.nextInt(3);
        WorldBlockPos at = new WorldBlockPos(world, pos);
        TickTokenizedMap.SimpleTickToken token = (TickTokenizedMap.SimpleTickToken)EventHandlerEntity.spawnDenyRegions.get((Object)at);
        if (token != null) {
            int next = token.getRemainingTimeout() + toAdd;
            if (next > 400) {
                next = 400;
            }
            token.setTimeout(next);
            this.rememberedTimeout = next;
        } else {
            this.rememberedTimeout = Math.min(400, this.rememberedTimeout + toAdd);
            EventHandlerEntity.spawnDenyRegions.put(at, new TickTokenizedMap.SimpleTickToken<Double>(range, this.rememberedTimeout));
        }
        return true;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        super.readFromNBT(cmp);
        this.rememberedTimeout = cmp.func_74762_e("rememberedTimeout");
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        super.writeToNBT(cmp);
        cmp.func_74768_a("rememberedTimeout", this.rememberedTimeout);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        range = cfg.getFloat(this.getKey() + "DenyRange", this.getConfigurationSection(), 256.0f, 2.0f, 2048.0f, "Defines the range in which the ritual will prevent mobspawning.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

