/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectPelotrio
extends CEffectPositionListGen<GenListEntries.PelotrioSpawnListEntry> {
    private static AxisAlignedBB proximityCheckBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(24.0);
    private static boolean enabled = true;
    private static float potencyMultiplier = 1.0f;
    private static int searchRange = 8;
    private static float selectChance = 0.1f;
    private static int proximityAmount = 40;

    public CEffectPelotrio(@Nullable ILocatable origin) {
        super(origin, Constellations.pelotrio, "pelotrio", searchRange, 5, (w, pos) -> GenListEntries.PelotrioSpawnListEntry.createEntry(w, pos) != null, GenListEntries.PelotrioSpawnListEntry::new);
    }

    @Override
    public GenListEntries.PelotrioSpawnListEntry newElement(World world, BlockPos at) {
        return GenListEntries.PelotrioSpawnListEntry.createEntry(world, at);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        for (int i = 0; i < 1 + rand.nextInt(3); ++i) {
            Vector3 particlePos = new Vector3((float)(pos.func_177958_n() - 3) + rand.nextFloat() * 7.0f, (float)pos.func_177956_o() + rand.nextFloat() * 2.0f, (float)(pos.func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            Vector3 dir = particlePos.clone().subtract((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(new Color(29, 123, 59));
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        List entities;
        if (!enabled) {
            return false;
        }
        if ((percStrength *= potencyMultiplier) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        GenListEntries.PelotrioSpawnListEntry entry = (GenListEntries.PelotrioSpawnListEntry)this.getRandomElement(rand);
        if (entry != null) {
            ++entry.counter;
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_SPAWN_PREPARE_EFFECTS, (Vec3i)entry.getPos());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)entry.getPos(), 24.0));
            if (entry.counter >= 30) {
                entry.spawn(world);
                this.removeElement(entry);
            }
        }
        if ((entities = world.func_175647_a(EntityLivingBase.class, proximityCheckBox.func_186670_a(pos), e -> e != null && !e.field_70128_L)).size() > proximityAmount) {
            return false;
        }
        boolean update = false;
        if (rand.nextFloat() < selectChance && this.findNewPosition(world, pos)) {
            update = true;
        }
        return update;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), searchRange, 1, 32, "Defines the radius (in blocks) in which the ritual will search for potential spawn points for entities.");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), enabled, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), potencyMultiplier, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
        selectChance = cfg.getFloat(this.getKey() + "SpawnSearchChance", this.getConfigurationSection(), selectChance, 0.0f, 1.0f, "Defines the per-tick chance that a new position for a entity-spawn will be searched for.");
        proximityAmount = cfg.getInt(this.getKey() + "ProximityCheck", this.getConfigurationSection(), proximityAmount, 1, 256, "Defines the threshold at which the ritual will stop spawning mobs. If there are more or equal amount of mobs near this ritual, the ritual will not spawn more mobs. Mainly to reduce potential server lag.");
    }

    @SideOnly(value=Side.CLIENT)
    public static void playSpawnPrepareEffects(PktParticleEvent pktParticleEvent) {
        Vector3 at = pktParticleEvent.getVec().add(0.5, 0.0, 0.5);
        for (int i = 0; i < 1; ++i) {
            Vector3 dir = new Vector3(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1) * 0.05f, rand.nextFloat() * 0.05f, rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1) * 0.05f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f);
            if (rand.nextBoolean()) {
                p.setColor(new Color(29, 123, 59));
                continue;
            }
            p.setColor(new Color(78, 1, 109));
        }
    }
}

