/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class ConstellationPerkMap {
    private HashMap<ConstellationPerks, Position> perks = new HashMap();
    private HashMap<ConstellationPerks, PerkOrder> perkOrderMap = new HashMap();
    private List<Dependency> perkDependencies = new LinkedList<Dependency>();

    public ConstellationPerkMap addPerk(ConstellationPerks perk, PerkOrder obtainOrder, int x, int y, ConstellationPerks ... dependencies) {
        if (this.perks.containsKey((Object)perk)) {
            AstralSorcery.log.warn("[AstralSorcery] Tried to register the same perk (id=" + perk.ordinal() + ") twice to a perk map! Skipping registration...");
            return this;
        }
        Position p = new Position(x % 15, y % 15);
        this.perks.put(perk, p);
        this.perkOrderMap.put(perk, obtainOrder);
        for (ConstellationPerks from : dependencies) {
            if (this.perks.containsKey((Object)from)) {
                boolean found = false;
                for (Dependency c : this.perkDependencies) {
                    if ((!c.from.equals((Object)from) || !c.to.equals((Object)perk)) && (!c.to.equals((Object)from) || !c.from.equals((Object)perk))) continue;
                    found = true;
                }
                if (!found) {
                    this.perkDependencies.add(new Dependency(from, perk));
                    continue;
                }
                AstralSorcery.log.warn("[AstralSorcery] Tried to register a perk-dependency that already exists! Skipping registration...");
                continue;
            }
            AstralSorcery.log.warn("[AstralSorcery] Tried to register a perk-dependency from a non-registered perk! Skipping registration...");
        }
        return this;
    }

    public List<Dependency> getPerkDependencies() {
        return Collections.unmodifiableList(this.perkDependencies);
    }

    @Nullable
    public Position getPosition(ConstellationPerks perk) {
        return this.perks.get((Object)perk);
    }

    public Map<ConstellationPerks, Position> getPerks() {
        return Collections.unmodifiableMap(this.perks);
    }

    @Deprecated
    public List<ConstellationPerks> getAvailablePerksFor(EntityPlayer player, PerkOrder availableOrder, boolean client) {
        PlayerProgress prog;
        PlayerProgress playerProgress = prog = client ? ResearchManager.clientProgress : ResearchManager.getProgress(player);
        if (prog == null) {
            return null;
        }
        Map<ConstellationPerk, Integer> appliedPerks = prog.getAppliedPerks();
        LinkedList<ConstellationPerks> available = new LinkedList<ConstellationPerks>();
        for (ConstellationPerks entry : this.perkOrderMap.keySet()) {
            PerkOrder order = this.perkOrderMap.get((Object)entry);
            if (order.ordinal() > availableOrder.ordinal()) continue;
            available.add(entry);
        }
        for (ConstellationPerk perk : appliedPerks.keySet()) {
            Iterator iterator = available.iterator();
            while (iterator.hasNext()) {
                ConstellationPerks av = (ConstellationPerks)((Object)iterator.next());
                if (!av.isInstanceOfThis(perk)) continue;
                iterator.remove();
            }
        }
        return available;
    }

    public static class Position {
        public final int x;
        public final int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Dependency {
        public final ConstellationPerks from;
        public final ConstellationPerks to;

        public Dependency(ConstellationPerks from, ConstellationPerks to) {
            this.from = from;
            this.to = to;
        }
    }

    public static enum PerkOrder {
        DEFAULT;

    }
}

