/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;

public class PerkCreationStoneEnrichment
extends ConstellationPerk {
    private static final BlockStateCheck stoneCheck = new CleanStoneCheck();
    private static int enrichmentRadius = 3;
    private static int chanceToEnrich = 70;

    public PerkCreationStoneEnrichment() {
        super("CRE_ORES", ConstellationPerk.Target.PLAYER_TICK);
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER && rand.nextInt(chanceToEnrich) == 0) {
            IBlockState state;
            ItemStack blockStack;
            BlockPos pos = player.func_180425_c().func_177982_a(rand.nextInt(enrichmentRadius * 2) - enrichmentRadius, rand.nextInt(enrichmentRadius * 2) - enrichmentRadius, rand.nextInt(enrichmentRadius * 2) - enrichmentRadius);
            if (stoneCheck.isStateValid(player.func_130014_f_(), pos, player.func_130014_f_().func_180495_p(pos)) && !(blockStack = OreTypes.AEVITAS_ORE_PERK.getRandomOre(rand)).func_190926_b() && (state = ItemUtils.createBlockState(blockStack)) != null) {
                player.func_130014_f_().func_175656_a(pos, state);
                this.addAlignmentCharge(player, 0.45);
            }
        }
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        enrichmentRadius = cfg.getInt(this.getKey() + "GenRadius", this.getConfigurationSection(), 3, 2, 50, "Defines the radius where a random position to generate a ore at is searched");
        chanceToEnrich = cfg.getInt(this.getKey() + "GenChance", this.getConfigurationSection(), 70, 10, 2000000, "Sets the chance (Random.nextInt(chance) == 0) to try to see if a random stone next to the player should get turned into an ore");
    }

    private static class CleanStoneCheck
    implements BlockStateCheck {
        private CleanStoneCheck() {
        }

        @Override
        public boolean isStateValid(World world, BlockPos pos, IBlockState state) {
            return state.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)).equals((Object)BlockStone.EnumType.STONE);
        }
    }
}

