/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class PerkDefensiveDamageReduction
extends ConstellationPerk {
    private static float dmgReductionMultiplier = 0.9f;

    public PerkDefensiveDamageReduction() {
        super("DEF_DMGREDUCTION", ConstellationPerk.Target.ENTITY_HURT);
    }

    @Override
    public float onEntityHurt(EntityPlayer hurt, DamageSource source, float dmgIn) {
        this.addAlignmentCharge(hurt, 0.08 * (double)Math.max(0.0f, dmgIn));
        return dmgIn * dmgReductionMultiplier;
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        dmgReductionMultiplier = cfg.getFloat(this.getKey() + "DmgReduction", this.getConfigurationSection(), 0.9f, 0.0f, 1.0f, "Defines the multiplier for the damage reduction when a player was hit");
    }
}

