/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;

public class PerkDefensiveNoArmor
extends ConstellationPerk {
    private static float multiplierDamageReduction = 0.3f;
    private static float healPerSec = 0.15f;

    public PerkDefensiveNoArmor() {
        super("DEF_NOARMOR", ConstellationPerk.Target.ENTITY_HURT, ConstellationPerk.Target.PLAYER_TICK);
    }

    @Override
    public float onEntityHurt(EntityPlayer hurt, DamageSource source, float dmgIn) {
        int eq = 0;
        for (ItemStack stack : hurt.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            ++eq;
        }
        if (eq <= 2) {
            this.addAlignmentCharge(hurt, 0.3 * (double)Math.max(0.0f, dmgIn));
            dmgIn *= multiplierDamageReduction;
        }
        return dmgIn;
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER) {
            if (player.field_70173_aa % 20 != 0) {
                return;
            }
            int eq = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                ++eq;
            }
            if (eq <= 2) {
                player.func_70691_i(healPerSec);
            }
        }
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        multiplierDamageReduction = cfg.getFloat(this.getKey() + "NoArmorDmgReductionMultiplier", this.getConfigurationSection(), 0.3f, 0.001f, 1.0f, "Defines the damage reduction multiplier if the player has less than 2 or 2 armor pieces equipped");
        healPerSec = cfg.getFloat(this.getKey() + "NoArmorHealPerSecond", this.getConfigurationSection(), 0.15f, 0.001f, 50.0f, "Defines the amount that the player is healed for each second if he has less than 2 or 2 armor pieces equipped");
    }
}

