/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.starmap;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.potion.Potion;

public class ConstellationMapEffectRegistry {
    private static Map<IConstellation, MapEffect> effectRegistry = new HashMap<IConstellation, MapEffect>();

    @Nullable
    static MapEffect getEffects(IConstellation c) {
        return effectRegistry.get(c);
    }

    public static MapEffect registerMapEffect(IConstellation c, Collection<EnchantmentMapEffect> enchantmentEffects, Collection<PotionMapEffect> potionEffects) {
        MapEffect me = new MapEffect(enchantmentEffects, potionEffects);
        effectRegistry.put(c, me);
        return me;
    }

    public static class EnchantmentMapEffect {
        public final Enchantment ench;
        public final int minEnchLevel;
        public final int maxEnchLevel;

        public EnchantmentMapEffect(Enchantment ench) {
            this.ench = ench;
            this.maxEnchLevel = ench.func_77325_b();
            this.minEnchLevel = ench.func_77319_d();
        }

        public EnchantmentMapEffect(Enchantment ench, int min, int max) {
            this.ench = ench;
            this.maxEnchLevel = max;
            this.minEnchLevel = min;
        }
    }

    public static class PotionMapEffect {
        public final Potion potion;
        public final int minPotionAmplifier;
        public final int maxPotionAmplifier;

        public PotionMapEffect(Potion potion) {
            this.potion = potion;
            this.minPotionAmplifier = 0;
            this.maxPotionAmplifier = 2;
        }

        public PotionMapEffect(Potion potion, int min, int max) {
            this.potion = potion;
            this.minPotionAmplifier = min;
            this.maxPotionAmplifier = max;
        }
    }

    public static class MapEffect {
        public final Collection<EnchantmentMapEffect> enchantmentEffects;
        public final Collection<PotionMapEffect> potionEffects;

        private MapEffect(Collection<EnchantmentMapEffect> enchantments, Collection<PotionMapEffect> potions) {
            this.enchantmentEffects = Collections.unmodifiableCollection(enchantments);
            this.potionEffects = Collections.unmodifiableCollection(potions);
        }
    }
}

