/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting;

import hellfirepvp.astralsorcery.common.crafting.helper.BasePlainRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ShapedLightProximityRecipe
extends BasePlainRecipe {
    public static BlockPos clientWorkbenchPosition = null;
    private final ItemStack out;
    private final ShapeMap.Baked grid;

    public ShapedLightProximityRecipe(ResourceLocation name, ItemStack out, ShapeMap.Baked grid) {
        super(name);
        this.out = out;
        this.grid = grid;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (!this.vanillaMatch(inv, world)) {
            return false;
        }
        Container c = inv.field_70465_c;
        if (!(c instanceof ContainerWorkbench)) {
            return false;
        }
        ContainerWorkbench workbench = (ContainerWorkbench)c;
        BlockPos pos = workbench.field_178145_h;
        if (pos == null) {
            return false;
        }
        if (world.field_72995_K) {
            GuiScreen sc = Minecraft.func_71410_x().field_71462_r;
            if (sc == null || !(sc instanceof GuiCrafting) || clientWorkbenchPosition == null) {
                return false;
            }
            if (!((DataLightBlockEndpoints)SyncDataHolder.getDataClient("StarlightNetworkEndpoints")).doesPositionReceiveStarlightClient(world, clientWorkbenchPosition)) {
                return false;
            }
        } else if (!((DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints")).doesPositionReceiveStarlightServer(world, pos)) {
            return false;
        }
        return true;
    }

    private boolean vanillaMatch(InventoryCrafting inv, World worldIn) {
        for (int x = 0; x <= 3 - this.grid.getWidth(); ++x) {
            for (int y = 0; y <= 3 - this.grid.getHeight(); ++y) {
                if (!this.checkMatch(inv, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                Ingredient target;
                int subX = x - startX;
                int subY = y - startY;
                if (subX < 0 || subY < 0 || subX >= this.grid.getWidth() || subY >= this.grid.getHeight() || (target = (Ingredient)this.grid.get((Object)ShapedRecipeSlot.getByRowColumnIndex(subX, subY))).apply(inv.func_70463_b(y, x))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.out.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.grid.getWidth() && height >= this.grid.getHeight();
    }

    public ItemStack func_77571_b() {
        return this.out.func_77946_l();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.grid.getRawIngredientList();
    }
}

