/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class AltarRecipeRegistry {
    private static Map<ItemStack, ISpecialCraftingEffects> effectRecoveryMap = new HashMap<ItemStack, ISpecialCraftingEffects>();
    public static Map<TileAltar.AltarLevel, List<AbstractAltarRecipe>> mtRecipes = new HashMap<TileAltar.AltarLevel, List<AbstractAltarRecipe>>();
    public static Map<TileAltar.AltarLevel, List<AbstractAltarRecipe>> recipes = new HashMap<TileAltar.AltarLevel, List<AbstractAltarRecipe>>();
    private static AbstractAltarRecipe[] compiledRecipeArray = null;
    private static Map<TileAltar.AltarLevel, List<AbstractAltarRecipe>> localFallbackCache = new HashMap<TileAltar.AltarLevel, List<AbstractAltarRecipe>>();

    public static void compileRecipes() {
        compiledRecipeArray = null;
        int totalNeeded = 0;
        for (TileAltar.AltarLevel level : recipes.keySet()) {
            totalNeeded += recipes.get((Object)level).size();
        }
        for (TileAltar.AltarLevel level : mtRecipes.keySet()) {
            totalNeeded += mtRecipes.get((Object)level).size();
        }
        int i = 0;
        compiledRecipeArray = new AbstractAltarRecipe[totalNeeded];
        for (TileAltar.AltarLevel l : TileAltar.AltarLevel.values()) {
            AbstractAltarRecipe rec;
            List<AbstractAltarRecipe> recipeList = recipes.get((Object)l);
            Iterator<AbstractAltarRecipe> iterator = recipeList.iterator();
            while (iterator.hasNext()) {
                AltarRecipeRegistry.compiledRecipeArray[i] = rec = iterator.next();
                rec.updateUniqueId(i);
                ++i;
            }
            recipeList = mtRecipes.get((Object)l);
            iterator = recipeList.iterator();
            while (iterator.hasNext()) {
                AltarRecipeRegistry.compiledRecipeArray[i] = rec = iterator.next();
                rec.updateUniqueId(i);
                ++i;
            }
        }
    }

    public static void cacheLocalRecipes() {
        if (localFallbackCache.isEmpty()) {
            for (TileAltar.AltarLevel al : TileAltar.AltarLevel.values()) {
                localFallbackCache.put(al, new LinkedList());
                localFallbackCache.get((Object)al).addAll((Collection<AbstractAltarRecipe>)recipes.get((Object)al));
            }
        }
    }

    public static void loadFromFallback() {
        if (!localFallbackCache.isEmpty()) {
            for (TileAltar.AltarLevel al : TileAltar.AltarLevel.values()) {
                recipes.get((Object)al).addAll((Collection<AbstractAltarRecipe>)localFallbackCache.get((Object)al));
            }
        }
    }

    @Nullable
    public static AbstractAltarRecipe getRecipe(int id) {
        if (id < 0 || id >= compiledRecipeArray.length) {
            return null;
        }
        return compiledRecipeArray[id];
    }

    public static List<AbstractAltarRecipe> getAltarRecipesByOutput(ItemStack output, TileAltar.AltarLevel altarLevel) {
        ItemStack out;
        LinkedList<AbstractAltarRecipe> list = new LinkedList<AbstractAltarRecipe>();
        for (AbstractAltarRecipe recipe : recipes.get((Object)altarLevel)) {
            out = recipe.getOutputForMatching();
            if (out.func_190926_b() || !ItemUtils.matchStacksStrict(out, output)) continue;
            list.add(recipe);
        }
        for (AbstractAltarRecipe recipe : mtRecipes.get((Object)altarLevel)) {
            out = recipe.getOutputForMatching();
            if (out.func_190926_b() || !ItemUtils.matchStacksStrict(out, output)) continue;
            list.add(recipe);
        }
        return list;
    }

    @Nullable
    public static AbstractAltarRecipe removeFindRecipeByOutputAndLevel(ItemStack output, TileAltar.AltarLevel altarLevel) {
        Iterator<AbstractAltarRecipe> iterator = recipes.get((Object)altarLevel).iterator();
        while (iterator.hasNext()) {
            AbstractAltarRecipe rec = iterator.next();
            ItemStack out = rec.getOutputForMatching();
            if (out.func_190926_b() || !ItemUtils.matchStackLoosely(rec.getOutputForMatching(), output)) continue;
            iterator.remove();
            return rec;
        }
        return null;
    }

    public static TraitRecipe registerTraitRecipe(AccessibleRecipeAdapater recipe) {
        TraitRecipe tr = new TraitRecipe(recipe);
        AltarRecipeRegistry.registerAltarRecipe(tr);
        return tr;
    }

    public static ConstellationRecipe registerConstellationRecipe(AccessibleRecipeAdapater recipe) {
        ConstellationRecipe dr = new ConstellationRecipe(recipe);
        AltarRecipeRegistry.registerAltarRecipe(dr);
        return dr;
    }

    public static AttunementRecipe registerAttenuationRecipe(AccessibleRecipeAdapater recipe) {
        AttunementRecipe dr = new AttunementRecipe(recipe);
        AltarRecipeRegistry.registerAltarRecipe(dr);
        return dr;
    }

    public static DiscoveryRecipe registerDiscoveryRecipe(AccessibleRecipeAdapater recipe) {
        DiscoveryRecipe dr = new DiscoveryRecipe(recipe);
        AltarRecipeRegistry.registerAltarRecipe(dr);
        return dr;
    }

    public static <T extends AbstractAltarRecipe> T registerAltarRecipe(T recipe) {
        TileAltar.AltarLevel level = recipe.getNeededLevel();
        recipes.get((Object)level).add(recipe);
        if (recipe instanceof ISpecialCraftingEffects) {
            AltarRecipeRegistry.registerSpecialEffects(recipe);
        }
        if (CraftingAccessManager.hasCompletedSetup()) {
            CraftingAccessManager.compile();
        }
        return recipe;
    }

    private static void registerSpecialEffects(AbstractAltarRecipe ar) {
        ItemStack out = ar.getOutputForMatching();
        if (out.func_190926_b()) {
            return;
        }
        boolean has = false;
        for (ItemStack i : effectRecoveryMap.keySet()) {
            if (!ItemUtils.matchStackLoosely(out, i)) continue;
            has = true;
        }
        if (!has) {
            effectRecoveryMap.put(out, (ISpecialCraftingEffects)((Object)ar));
        }
    }

    @Nullable
    public static ISpecialCraftingEffects shouldHaveSpecialEffects(AbstractAltarRecipe ar) {
        if (ar == null || ar instanceof ISpecialCraftingEffects) {
            return null;
        }
        ItemStack match = ar.getOutputForMatching();
        if (match.func_190926_b()) {
            return null;
        }
        for (ItemStack i : effectRecoveryMap.keySet()) {
            if (!ItemUtils.matchStackLoosely(match, i)) continue;
            return effectRecoveryMap.get(i);
        }
        return null;
    }

    public static Collection<AbstractAltarRecipe> getRecipesForLevel(TileAltar.AltarLevel al) {
        LinkedList cache = Lists.newLinkedList();
        cache.addAll((Collection)recipes.get((Object)al));
        cache.addAll((Collection)mtRecipes.get((Object)al));
        return cache;
    }

    @Nullable
    public static AbstractAltarRecipe findMatchingRecipe(TileAltar ta, boolean ignoreStarlightRequirement) {
        TileAltar.AltarLevel lvl;
        int i;
        TileAltar.AltarLevel lowestAllowed = TileAltar.AltarLevel.DISCOVERY;
        for (i = ta.getAltarLevel().ordinal(); i >= 0; --i) {
            lvl = TileAltar.AltarLevel.values()[i];
            if (!lvl.getMatcher().mbAllowsForCrafting(ta)) continue;
            lowestAllowed = lvl;
            break;
        }
        for (i = lowestAllowed.ordinal(); i >= 0; --i) {
            lvl = TileAltar.AltarLevel.values()[i];
            List<AbstractAltarRecipe> validRecipes = recipes.get((Object)lvl);
            if (validRecipes != null) {
                for (AbstractAltarRecipe rec : validRecipes) {
                    if (!ta.doesRecipeMatch(rec, ignoreStarlightRequirement)) continue;
                    return rec;
                }
            }
            if ((validRecipes = mtRecipes.get((Object)lvl)) == null) continue;
            for (AbstractAltarRecipe rec : validRecipes) {
                if (!ta.doesRecipeMatch(rec, ignoreStarlightRequirement)) continue;
                return rec;
            }
        }
        return null;
    }

    static {
        for (TileAltar.AltarLevel al : TileAltar.AltarLevel.values()) {
            recipes.put(al, new LinkedList());
            mtRecipes.put(al, new LinkedList());
        }
    }
}

