/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataLightBlockEndpoints
extends AbstractData {
    private Map<Integer, List<BlockPos>> clientPositions = new HashMap<Integer, List<BlockPos>>();
    private Map<Integer, List<BlockPos>> serverPositions = new HashMap<Integer, List<BlockPos>>();
    private Map<Integer, LinkedList<Tuple<BlockPos, Boolean>>> serverChangeBuffer = new HashMap<Integer, LinkedList<Tuple<BlockPos, Boolean>>>();
    private final Object lock = new Object();
    private NBTTagCompound clientReadBuffer = new NBTTagCompound();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewEndpoint(int dimId, BlockPos pos) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<Object, Boolean>> list = this.serverChangeBuffer.get(dimId);
            if (list == null) {
                list = new LinkedList();
                this.serverChangeBuffer.put(dimId, list);
            }
            list.add(new Tuple<BlockPos, Boolean>(pos, true));
            List<BlockPos> posBuffer = this.serverPositions.get(dimId);
            if (posBuffer == null) {
                posBuffer = new LinkedList<BlockPos>();
                this.serverPositions.put(dimId, posBuffer);
            }
            posBuffer.add(pos);
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewEndpoints(int dimId, List<BlockPos> newPositions) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<Object, Boolean>> list = this.serverChangeBuffer.get(dimId);
            if (list == null) {
                list = new LinkedList();
                this.serverChangeBuffer.put(dimId, list);
            }
            for (BlockPos pos : newPositions) {
                list.add(new Tuple<BlockPos, Boolean>(pos, true));
            }
            List<BlockPos> posBuffer = this.serverPositions.get(dimId);
            if (posBuffer == null) {
                posBuffer = new LinkedList<BlockPos>();
                this.serverPositions.put(dimId, posBuffer);
            }
            posBuffer.addAll(newPositions);
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoints(int dimId, List<BlockPos> positions) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<Object, Boolean>> list = this.serverChangeBuffer.get(dimId);
            if (list == null) {
                list = new LinkedList();
                this.serverChangeBuffer.put(dimId, list);
            }
            for (BlockPos pos : positions) {
                list.add(new Tuple<BlockPos, Boolean>(pos, false));
            }
            List<BlockPos> posBuffer = this.serverPositions.get(dimId);
            if (posBuffer == null) {
                posBuffer = new LinkedList<BlockPos>();
                this.serverPositions.put(dimId, posBuffer);
            }
            posBuffer.removeAll(positions);
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDimensionEndpoints(int dimId) {
        this.serverPositions.remove(dimId);
        Object object = this.lock;
        synchronized (object) {
            this.serverChangeBuffer.remove(dimId);
            this.serverChangeBuffer.put(dimId, new LinkedList());
            this.serverChangeBuffer.get(dimId).add(new Tuple<Object, Boolean>(null, false));
        }
        this.markDirty();
    }

    public boolean doesPositionReceiveStarlightClient(World world, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        return this.clientPositions.containsKey(dim) && this.clientPositions.get(dim).contains(pos);
    }

    public boolean doesPositionReceiveStarlightServer(World world, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        return this.serverPositions.containsKey(dim) && this.serverPositions.get(dim).contains(pos);
    }

    public void clientClean() {
        this.clientPositions.clear();
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        for (int dimId : this.serverPositions.keySet()) {
            List<BlockPos> dat = this.serverPositions.get(dimId);
            NBTTagList dataList = new NBTTagList();
            for (BlockPos pos : dat) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.func_74772_a("pos", pos.func_177986_g());
                cmp.func_74757_a("s", true);
                dataList.func_74742_a((NBTBase)cmp);
            }
            compound.func_74782_a("" + dimId, (NBTBase)dataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToPacket(NBTTagCompound compound) {
        Object object = this.lock;
        synchronized (object) {
            for (int dimId : this.serverChangeBuffer.keySet()) {
                LinkedList<Tuple<BlockPos, Boolean>> changes = this.serverChangeBuffer.get(dimId);
                if (changes.isEmpty()) continue;
                NBTTagList list = new NBTTagList();
                for (Tuple tuple : changes) {
                    if (tuple.key == null) {
                        list = new NBTTagList();
                        NBTTagCompound cm = new NBTTagCompound();
                        cm.func_74757_a("clear", true);
                        list.func_74742_a((NBTBase)cm);
                        break;
                    }
                    NBTTagCompound cmp = new NBTTagCompound();
                    cmp.func_74772_a("pos", ((BlockPos)tuple.key).func_177986_g());
                    cmp.func_74757_a("s", ((Boolean)tuple.value).booleanValue());
                    list.func_74742_a((NBTBase)cmp);
                }
                compound.func_74782_a("" + dimId, (NBTBase)list);
            }
            this.serverChangeBuffer.clear();
        }
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.clientReadBuffer = compound;
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (!(serverData instanceof DataLightBlockEndpoints)) {
            return;
        }
        for (String dimStr : ((DataLightBlockEndpoints)serverData).clientReadBuffer.func_150296_c()) {
            int dimId = Integer.parseInt(dimStr);
            NBTTagList list = ((DataLightBlockEndpoints)serverData).clientReadBuffer.func_150295_c(dimStr, 10);
            List<BlockPos> positions = this.clientPositions.get(dimId);
            if (positions == null) {
                positions = new LinkedList<BlockPos>();
                this.clientPositions.put(dimId, positions);
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound connection = list.func_150305_b(i);
                if (connection.func_74764_b("clear")) {
                    this.clientPositions.remove(dimId);
                    break;
                }
                BlockPos position = BlockPos.func_177969_a((long)connection.func_74763_f("pos"));
                boolean set = connection.func_74767_n("s");
                if (set) {
                    positions.add(position);
                    continue;
                }
                positions.remove(position);
            }
            if (!positions.isEmpty()) continue;
            this.clientPositions.remove(dimId);
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataLightBlockEndpoints> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataLightBlockEndpoints provideNewInstance() {
            return new DataLightBlockEndpoints();
        }
    }
}

