/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureGenBuffer
extends CachedWorldData {
    private Map<StructureType, List<BlockPos>> generatedStructures = new HashMap<StructureType, List<BlockPos>>();

    public StructureGenBuffer() {
        super(WorldCacheManager.SaveKey.STRUCTURE_GEN);
        for (StructureType type : StructureType.values()) {
            this.generatedStructures.put(type, new LinkedList());
        }
    }

    public void markStructureGeneration(BlockPos pos, StructureType type) {
        this.generatedStructures.get((Object)type).add(pos);
        this.markDirty();
    }

    public double getDstToClosest(StructureType type, BlockPos dstTo) {
        double closest = Double.MAX_VALUE;
        int x = dstTo.func_177958_n();
        int y = dstTo.func_177956_o();
        int z = dstTo.func_177952_p();
        for (BlockPos position : this.generatedStructures.get((Object)type)) {
            double dst = position.func_185332_f(x, y, z);
            if (!(dst < closest)) continue;
            closest = dst;
        }
        return closest;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        for (StructureType type : StructureType.values()) {
            this.generatedStructures.get((Object)type).clear();
        }
        for (StructureType type : StructureType.values()) {
            NBTTagList list = compound.func_150295_c(type.name().toLowerCase(), 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound cmp = list.func_150305_b(i);
                BlockPos pos = NBTUtils.readBlockPosFromNBT(cmp);
                this.generatedStructures.get((Object)type).add(pos);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        for (StructureType type : StructureType.values()) {
            NBTTagList list = new NBTTagList();
            for (BlockPos pos : this.generatedStructures.get((Object)type)) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTUtils.writeBlockPosToNBT(pos, tag);
                list.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a(type.name().toLowerCase(), (NBTBase)list);
        }
    }

    @Override
    public void updateTick(World world) {
    }

    public static enum StructureType {
        MOUNTAIN,
        DESERT,
        SMALL,
        TREASURE;

    }
}

