/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.CelestialStrike;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStarburst
extends EntityThrowable {
    private static final AxisAlignedBB searchBox = new AxisAlignedBB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).func_186662_g(17.0);
    private static final double descendingDst = 17.0;
    private int targetId = -1;

    public EntityStarburst(World worldIn) {
        super(worldIn);
    }

    public EntityStarburst(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityStarburst(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_184538_a((Entity)throwerIn, throwerIn.field_70125_A, throwerIn.field_70177_z, 0.0f, 0.7f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.playEffects();
        } else {
            if (this.targetId == -1) {
                EntityLivingBase closest;
                AxisAlignedBB box = searchBox.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                List entities = this.field_70170_p.func_175647_a(EntityLivingBase.class, box, EntitySelectors.field_94557_a);
                if (!(this.field_70170_p instanceof WorldServer) || !this.field_70170_p.func_73046_m().func_71219_W()) {
                    entities.removeIf(e -> e instanceof EntityPlayer);
                }
                if (this.func_85052_h() != null) {
                    entities.remove(this.func_85052_h());
                }
                if ((closest = EntityUtils.selectClosest(entities, entityLivingBase -> entityLivingBase.func_70068_e((Entity)this))) != null) {
                    this.targetId = closest.func_145782_y();
                }
            }
            if (this.targetId != -1) {
                Entity e2 = this.field_70170_p.func_73045_a(this.targetId);
                if (e2 == null || e2.field_70128_L || !(e2 instanceof EntityLivingBase)) {
                    this.targetId = -1;
                } else {
                    EntityLivingBase entity = (EntityLivingBase)e2;
                    Vector3 thisPos = Vector3.atEntityCorner((Entity)this);
                    Vector3 targetEntity = Vector3.atEntityCorner((Entity)entity);
                    Vector3 dirMotion = targetEntity.clone().subtract(thisPos);
                    Vector3 currentMotion = new Vector3(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    double dst = thisPos.distance(targetEntity);
                    if (dst < 17.0) {
                        double originalPart = dst / 17.0;
                        double length = currentMotion.length();
                        currentMotion = dirMotion.multiply(1.0 - originalPart).add(currentMotion.clone().multiply(originalPart));
                        currentMotion.normalize().multiply(length);
                    }
                    this.field_70159_w = currentMotion.getX();
                    this.field_70181_x = currentMotion.getY();
                    this.field_70179_y = currentMotion.getZ();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        EntityFXFacingParticle particle;
        block20: for (int i = 0; i < 2; ++i) {
            particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.motion(this.field_70146_Z.nextFloat() * 0.03f - this.field_70146_Z.nextFloat() * 0.06f, this.field_70146_Z.nextFloat() * 0.03f - this.field_70146_Z.nextFloat() * 0.06f, this.field_70146_Z.nextFloat() * 0.03f - this.field_70146_Z.nextFloat() * 0.06f).scale(0.3f);
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    particle.setColor(Color.WHITE);
                    continue block20;
                }
                case 1: {
                    particle.setColor(new Color(6927871));
                    continue block20;
                }
                case 2: {
                    particle.setColor(new Color(30975));
                }
            }
        }
        if (this.field_70173_aa % 12 == 0) {
            for (Vector3 pos : MiscUtils.getCirclePositions(Vector3.atEntityCenter((Entity)this), new Vector3(this.field_70159_w, this.field_70181_x, this.field_70179_y), 1.0, 25 + this.field_70146_Z.nextInt(14))) {
                particle = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ()).gravity(0.004);
                particle.scale(0.4f).setAlphaMultiplier(0.5f);
                particle.motion(this.field_70146_Z.nextFloat() * 0.02f - this.field_70146_Z.nextFloat() * 0.04f, this.field_70146_Z.nextFloat() * 0.02f - this.field_70146_Z.nextFloat() * 0.04f, this.field_70146_Z.nextFloat() * 0.02f - this.field_70146_Z.nextFloat() * 0.04f);
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        particle.setColor(Color.WHITE);
                        break;
                    }
                    case 1: {
                        particle.setColor(new Color(6398719));
                        break;
                    }
                    case 2: {
                        particle.setColor(new Color(3820221));
                    }
                }
            }
        }
        particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        particle.scale(0.6f);
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                particle.setColor(Color.WHITE);
                break;
            }
            case 1: {
                particle.setColor(new Color(6927871));
                break;
            }
            case 2: {
                particle.setColor(new Color(30975));
            }
        }
        particle = EffectHelper.genericFlareParticle(this.field_70165_t + this.field_70159_w / 2.0, this.field_70163_u + this.field_70181_x / 2.0, this.field_70161_v + this.field_70179_y / 2.0);
        particle.scale(0.6f);
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                particle.setColor(Color.WHITE);
                break;
            }
            case 1: {
                particle.setColor(new Color(6927871));
                break;
            }
            case 2: {
                particle.setColor(new Color(30975));
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (result.field_72308_g.equals((Object)this.func_85052_h())) {
                    return;
                }
                CelestialStrike.play(this.func_85052_h(), this.field_70170_p, Vector3.atEntityCenter(result.field_72308_g), Vector3.atEntityCenter(result.field_72308_g));
            }
            this.func_70106_y();
        }
    }
}

