/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.BaseAltarRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class AltarRecipeTrait
extends BaseAltarRecipe {
    @Nullable
    private IConstellation focusRequiredConstellation;

    AltarRecipeTrait() {
        super(null, null, 0, 0);
        this.focusRequiredConstellation = null;
    }

    public AltarRecipeTrait(ItemHandle[] inputs, ItemStack output, int starlightRequired, int craftingTickTime, @Nullable IConstellation focus) {
        super(inputs, output, starlightRequired, craftingTickTime);
        this.focusRequiredConstellation = focus;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.ALTAR_T4_ADD;
    }

    @Override
    public void read(ByteBuf buf) {
        super.read(buf);
        this.focusRequiredConstellation = buf.readBoolean() ? ConstellationRegistry.getConstellationByName(ByteBufUtils.readString(buf)) : null;
    }

    @Override
    public void write(ByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.focusRequiredConstellation == null);
        if (this.focusRequiredConstellation != null) {
            ByteBufUtils.writeString(buf, this.focusRequiredConstellation.getUnlocalizedName());
        }
    }

    @Override
    public void applyRecipe() {
        AbstractAltarRecipe aar = this.buildRecipeUnsafe(TileAltar.AltarLevel.TRAIT_CRAFT, this.starlightRequired, this.craftingTickTime, this.output, this.inputs);
        if (aar instanceof TraitRecipe && this.focusRequiredConstellation != null) {
            ((TraitRecipe)aar).setRequiredConstellation(this.focusRequiredConstellation);
        }
        CraftingAccessManager.registerMTAltarRecipe(aar);
    }
}

