/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class WellRecipeRemove
implements SerializeableRecipe {
    private ItemStack matchIn;
    private Fluid fluidOut;

    WellRecipeRemove() {
    }

    public WellRecipeRemove(ItemStack matchIn, @Nullable Fluid fluidOut) {
        this.matchIn = matchIn;
        this.fluidOut = fluidOut;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.WELL_REMOVE;
    }

    @Override
    public void read(ByteBuf buf) {
        this.matchIn = ByteBufUtils.readItemStack(buf);
        this.fluidOut = buf.readBoolean() ? FluidRegistry.getFluid((String)ByteBufUtils.readString(buf)) : null;
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack(buf, this.matchIn);
        boolean defined = this.fluidOut != null;
        buf.writeBoolean(defined);
        if (defined) {
            ByteBufUtils.writeString(buf, this.fluidOut.getName());
        }
    }

    @Override
    public void applyRecipe() {
        CraftingAccessManager.removeMTLiquefaction(this.matchIn, this.fluidOut);
    }
}

