/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.block.BlockAttunementRelay;
import hellfirepvp.astralsorcery.common.block.BlockBlackMarble;
import hellfirepvp.astralsorcery.common.block.BlockBore;
import hellfirepvp.astralsorcery.common.block.BlockBoreHead;
import hellfirepvp.astralsorcery.common.block.BlockCelestialCrystals;
import hellfirepvp.astralsorcery.common.block.BlockCelestialGateway;
import hellfirepvp.astralsorcery.common.block.BlockChalice;
import hellfirepvp.astralsorcery.common.block.BlockCustomFlower;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.BlockCustomSandOre;
import hellfirepvp.astralsorcery.common.block.BlockDynamicColor;
import hellfirepvp.astralsorcery.common.block.BlockFakeTree;
import hellfirepvp.astralsorcery.common.block.BlockFlareLight;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.block.BlockMapDrawingTable;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.block.BlockMarbleDoubleSlab;
import hellfirepvp.astralsorcery.common.block.BlockMarbleSlab;
import hellfirepvp.astralsorcery.common.block.BlockMarbleStairs;
import hellfirepvp.astralsorcery.common.block.BlockRitualLink;
import hellfirepvp.astralsorcery.common.block.BlockStarlightInfuser;
import hellfirepvp.astralsorcery.common.block.BlockStructural;
import hellfirepvp.astralsorcery.common.block.BlockTranslucentBlock;
import hellfirepvp.astralsorcery.common.block.BlockTreeBeacon;
import hellfirepvp.astralsorcery.common.block.BlockVanishing;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.block.BlockWorldIlluminator;
import hellfirepvp.astralsorcery.common.block.fluid.FluidBlockLiquidStarlight;
import hellfirepvp.astralsorcery.common.block.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.block.network.BlockAttunementAltar;
import hellfirepvp.astralsorcery.common.block.network.BlockCelestialCollectorCrystal;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystal;
import hellfirepvp.astralsorcery.common.block.network.BlockLens;
import hellfirepvp.astralsorcery.common.block.network.BlockPrism;
import hellfirepvp.astralsorcery.common.block.network.BlockRitualPedestal;
import hellfirepvp.astralsorcery.common.block.network.BlockWell;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationGeolosys;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.TileBore;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileFakeTree;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import hellfirepvp.astralsorcery.common.tile.TileIlluminator;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileOreGenerator;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.tile.TileStructuralConnector;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.TileVanishing;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalPrismLens;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class RegistryBlocks {
    public static List<Block> defaultItemBlocksToRegister = new LinkedList<Block>();
    public static List<Block> customNameItemBlocksToRegister = new LinkedList<Block>();
    public static List<BlockDynamicColor> pendingIBlockColorBlocks = new LinkedList<BlockDynamicColor>();

    public static void init() {
        RegistryBlocks.registerFluids();
        RegistryBlocks.registerBlocks();
        RegistryBlocks.registerTileEntities();
        if (Mods.GEOLOSYS.isPresent() && Mods.ORESTAGES.isPresent()) {
            ModIntegrationGeolosys.registerGeolosysSampleBlock();
        }
    }

    private static void registerFluids() {
        FluidLiquidStarlight f = new FluidLiquidStarlight();
        FluidRegistry.registerFluid((Fluid)f);
        BlocksAS.fluidLiquidStarlight = FluidRegistry.getFluid((String)f.getName());
        BlocksAS.blockLiquidStarlight = new FluidBlockLiquidStarlight();
        CommonProxy.registryPrimer.register(BlocksAS.blockLiquidStarlight.func_149663_c(((Object)((Object)BlocksAS.blockLiquidStarlight)).getClass().getSimpleName().toLowerCase()).setRegistryName(((Object)((Object)BlocksAS.blockLiquidStarlight)).getClass().getSimpleName().toLowerCase()));
        BlocksAS.fluidLiquidStarlight.setBlock((Block)BlocksAS.blockLiquidStarlight);
        FluidRegistry.addBucketForFluid((Fluid)BlocksAS.fluidLiquidStarlight);
    }

    private static void registerBlocks() {
        BlocksAS.customOre = RegistryBlocks.registerBlock(new BlockCustomOre());
        RegistryBlocks.queueCustomNameItemBlock(BlocksAS.customOre);
        BlocksAS.customSandOre = RegistryBlocks.registerBlock(new BlockCustomSandOre());
        RegistryBlocks.queueCustomNameItemBlock((Block)BlocksAS.customSandOre);
        BlocksAS.customFlower = RegistryBlocks.registerBlock(new BlockCustomFlower());
        RegistryBlocks.queueCustomNameItemBlock(BlocksAS.customFlower);
        BlocksAS.blockMarble = RegistryBlocks.registerBlock(new BlockMarble());
        RegistryBlocks.queueCustomNameItemBlock(BlocksAS.blockMarble);
        BlocksAS.blockMarbleStairs = RegistryBlocks.registerBlock(new BlockMarbleStairs());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockMarbleStairs);
        BlocksAS.blockMarbleSlab = RegistryBlocks.registerBlock(new BlockMarbleSlab());
        BlocksAS.blockMarbleDoubleSlab = RegistryBlocks.registerBlock(new BlockMarbleDoubleSlab());
        BlocksAS.blockBlackMarble = RegistryBlocks.registerBlock(new BlockBlackMarble());
        RegistryBlocks.queueCustomNameItemBlock(BlocksAS.blockBlackMarble);
        BlocksAS.blockVolatileLight = RegistryBlocks.registerBlock(new BlockFlareLight());
        RegistryBlocks.queueDefaultItemBlock(BlocksAS.blockVolatileLight);
        BlocksAS.blockVanishing = RegistryBlocks.registerBlock(new BlockVanishing());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockVanishing);
        BlocksAS.blockChalice = RegistryBlocks.registerBlock(new BlockChalice());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockChalice);
        BlocksAS.blockBore = RegistryBlocks.registerBlock(new BlockBore());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockBore);
        BlocksAS.blockBoreHead = RegistryBlocks.registerBlock(new BlockBoreHead());
        RegistryBlocks.queueCustomNameItemBlock(BlocksAS.blockBoreHead);
        BlocksAS.blockAltar = RegistryBlocks.registerBlock(new BlockAltar());
        BlocksAS.attunementAltar = RegistryBlocks.registerBlock(new BlockAttunementAltar());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.attunementAltar);
        BlocksAS.attunementRelay = RegistryBlocks.registerBlock(new BlockAttunementRelay());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.attunementRelay);
        BlocksAS.ritualPedestal = RegistryBlocks.registerBlock(new BlockRitualPedestal());
        BlocksAS.blockWell = RegistryBlocks.registerBlock(new BlockWell());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockWell);
        BlocksAS.blockIlluminator = RegistryBlocks.registerBlock(new BlockWorldIlluminator());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockIlluminator);
        BlocksAS.blockMachine = RegistryBlocks.registerBlock(new BlockMachine());
        RegistryBlocks.queueCustomNameItemBlock((Block)BlocksAS.blockMachine);
        BlocksAS.blockFakeTree = RegistryBlocks.registerBlock(new BlockFakeTree());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.blockFakeTree);
        BlocksAS.starlightInfuser = RegistryBlocks.registerBlock(new BlockStarlightInfuser());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.starlightInfuser);
        BlocksAS.ritualLink = RegistryBlocks.registerBlock(new BlockRitualLink());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.ritualLink);
        BlocksAS.treeBeacon = RegistryBlocks.registerBlock(new BlockTreeBeacon());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.treeBeacon);
        BlocksAS.translucentBlock = RegistryBlocks.registerBlock(new BlockTranslucentBlock());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.translucentBlock);
        BlocksAS.drawingTable = RegistryBlocks.registerBlock(new BlockMapDrawingTable());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.drawingTable);
        BlocksAS.celestialGateway = RegistryBlocks.registerBlock(new BlockCelestialGateway());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.celestialGateway);
        BlocksAS.lens = RegistryBlocks.registerBlock(new BlockLens());
        BlocksAS.lensPrism = RegistryBlocks.registerBlock(new BlockPrism());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.lens);
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksAS.lensPrism);
        BlocksAS.celestialCrystals = RegistryBlocks.registerBlock(new BlockCelestialCrystals());
        RegistryBlocks.queueCustomNameItemBlock((Block)BlocksAS.celestialCrystals);
        BlocksAS.collectorCrystal = RegistryBlocks.registerBlock(new BlockCollectorCrystal());
        BlocksAS.celestialCollectorCrystal = RegistryBlocks.registerBlock(new BlockCelestialCollectorCrystal());
        BlocksAS.blockStructural = RegistryBlocks.registerBlock(new BlockStructural());
        RegistryBlocks.queueCustomNameItemBlock((Block)BlocksAS.blockStructural);
    }

    public static void initRenderRegistry() {
        RegistryBlocks.registerBlockRender(BlocksAS.blockMarble);
        RegistryBlocks.registerBlockRender(BlocksAS.blockBlackMarble);
        RegistryBlocks.registerBlockRender((Block)BlocksAS.blockAltar);
        RegistryBlocks.registerBlockRender(BlocksAS.blockBoreHead);
        RegistryBlocks.registerBlockRender(BlocksAS.customOre);
        RegistryBlocks.registerBlockRender((Block)BlocksAS.customSandOre);
        RegistryBlocks.registerBlockRender(BlocksAS.customFlower);
        RegistryBlocks.registerBlockRender((Block)BlocksAS.blockStructural);
        RegistryBlocks.registerBlockRender((Block)BlocksAS.blockMachine);
        RegistryBlocks.registerBlockRender((Block)BlocksAS.treeBeacon);
    }

    private static void registerTileEntities() {
        RegistryBlocks.registerTile(TileAltar.class);
        RegistryBlocks.registerTile(TileRitualPedestal.class);
        RegistryBlocks.registerTile(TileCollectorCrystal.class);
        RegistryBlocks.registerTile(TileCelestialCrystals.class);
        RegistryBlocks.registerTile(TileWell.class);
        RegistryBlocks.registerTile(TileIlluminator.class);
        RegistryBlocks.registerTile(TileTelescope.class);
        RegistryBlocks.registerTile(TileGrindstone.class);
        RegistryBlocks.registerTile(TileStructuralConnector.class);
        RegistryBlocks.registerTile(TileFakeTree.class);
        RegistryBlocks.registerTile(TileAttunementAltar.class);
        RegistryBlocks.registerTile(TileStarlightInfuser.class);
        RegistryBlocks.registerTile(TileTreeBeacon.class);
        RegistryBlocks.registerTile(TileRitualLink.class);
        RegistryBlocks.registerTile(TileTranslucent.class);
        RegistryBlocks.registerTile(TileAttunementRelay.class);
        RegistryBlocks.registerTile(TileMapDrawingTable.class);
        RegistryBlocks.registerTile(TileCelestialGateway.class);
        RegistryBlocks.registerTile(TileOreGenerator.class);
        RegistryBlocks.registerTile(TileVanishing.class);
        RegistryBlocks.registerTile(TileChalice.class);
        RegistryBlocks.registerTile(TileBore.class);
        RegistryBlocks.registerTile(TileCrystalLens.class);
        RegistryBlocks.registerTile(TileCrystalPrismLens.class);
    }

    public static void queueCustomNameItemBlock(Block block) {
        customNameItemBlocksToRegister.add(block);
    }

    public static void queueDefaultItemBlock(Block block) {
        defaultItemBlocksToRegister.add(block);
    }

    private static <T extends Block> T registerBlock(T block, String name) {
        CommonProxy.registryPrimer.register(block.func_149663_c(name).setRegistryName(name));
        if (block instanceof BlockDynamicColor) {
            pendingIBlockColorBlocks.add((BlockDynamicColor)block);
        }
        return block;
    }

    public static <T extends Block> T registerBlock(T block) {
        return RegistryBlocks.registerBlock(block, block.getClass().getSimpleName().toLowerCase());
    }

    private static void registerBlockRender(Block block) {
        if (block instanceof BlockVariants) {
            for (IBlockState state : ((BlockVariants)block).getValidStates()) {
                String unlocName = ((BlockVariants)block).getBlockName(state);
                String name = unlocName + "_" + ((BlockVariants)block).getStateName(state);
                AstralSorcery.proxy.registerVariantName(Item.func_150898_a((Block)block), name);
                AstralSorcery.proxy.registerBlockRender(block, block.func_176201_c(state), name);
            }
        } else {
            AstralSorcery.proxy.registerVariantName(Item.func_150898_a((Block)block), block.func_149739_a());
            AstralSorcery.proxy.registerBlockRender(block, 0, block.func_149739_a());
        }
    }

    private static void registerTile(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        RegistryBlocks.registerTile(tile, tile.getSimpleName().toLowerCase());
    }

    public static class FluidCustomModelMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        private final ModelResourceLocation res;

        public FluidCustomModelMapper(Fluid f) {
            this.res = new ModelResourceLocation("astralsorcery".toLowerCase() + ":blockfluids", f.getName());
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.res;
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return this.res;
        }
    }
}

