/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base;

import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimpleTransmissionNode
implements ITransmissionNode {
    private boolean ignoreBlockCollision = false;
    private boolean nextReachable = false;
    private BlockPos nextPos = null;
    private double dstToNextSq = 0.0;
    private RaytraceAssist assistNext = null;
    private BlockPos thisPos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public SimpleTransmissionNode(BlockPos thisPos) {
        this.thisPos = thisPos;
    }

    @Override
    public BlockPos getPos() {
        return this.thisPos;
    }

    public void updateIgnoreBlockCollisionState(World world, boolean ignoreBlockCollision) {
        this.ignoreBlockCollision = ignoreBlockCollision;
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(world);
        if (this.assistNext != null && handle != null) {
            boolean oldState = this.nextReachable;
            boolean bl = this.nextReachable = ignoreBlockCollision || this.assistNext.isClear(world);
            if (this.nextReachable != oldState) {
                handle.notifyTransmissionNodeChange(this);
            }
        }
    }

    public boolean ignoresBlockCollision() {
        return this.ignoreBlockCollision;
    }

    @Override
    public boolean notifyUnlink(World world, BlockPos to) {
        if (to.equals((Object)this.nextPos)) {
            this.nextPos = null;
            this.assistNext = null;
            this.dstToNextSq = 0.0;
            this.nextReachable = false;
            return true;
        }
        return false;
    }

    @Override
    public void notifyLink(World world, BlockPos pos) {
        this.addLink(world, pos, true, false);
    }

    private void addLink(World world, BlockPos pos, boolean doRayTest, boolean oldRayState) {
        this.nextPos = pos;
        this.assistNext = new RaytraceAssist(this.thisPos, this.nextPos);
        this.nextReachable = doRayTest ? this.assistNext.isClear(world) : oldRayState;
        this.dstToNextSq = pos.func_177954_c((double)this.thisPos.func_177958_n(), (double)this.thisPos.func_177956_o(), (double)this.thisPos.func_177952_p());
    }

    @Override
    public boolean notifyBlockChange(World world, BlockPos at) {
        if (this.nextPos == null) {
            return false;
        }
        double dstStart = this.thisPos.func_177954_c((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p());
        double dstEnd = this.nextPos.func_177954_c((double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p());
        if (dstStart > this.dstToNextSq || dstEnd > this.dstToNextSq) {
            return false;
        }
        boolean oldState = this.nextReachable;
        this.nextReachable = this.ignoreBlockCollision || this.assistNext.isClear(world);
        return this.nextReachable != oldState;
    }

    @Override
    public void notifySourceLink(World world, BlockPos source) {
        if (!this.sourcesToThis.contains(source)) {
            this.sourcesToThis.add(source);
        }
    }

    @Override
    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    @Override
    public NodeConnection<IPrismTransmissionNode> queryNextNode(WorldNetworkHandler handler) {
        if (this.nextPos == null) {
            return null;
        }
        return new NodeConnection<IPrismTransmissionNode>(handler.getTransmissionNode(this.nextPos), this.nextPos, this.nextReachable);
    }

    @Override
    public List<BlockPos> getSources() {
        return this.sourcesToThis.stream().collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public TransmissionClassRegistry.TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.thisPos = NBTUtils.readBlockPosFromNBT(compound);
        this.sourcesToThis.clear();
        this.ignoreBlockCollision = compound.func_74767_n("ignoreBlockCollision");
        NBTTagList list = compound.func_150295_c("sources", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.sourcesToThis.add(NBTUtils.readBlockPosFromNBT(list.func_150305_b(i)));
        }
        if (compound.func_74764_b("nextPos")) {
            NBTTagCompound tag = compound.func_74775_l("nextPos");
            BlockPos next = NBTUtils.readBlockPosFromNBT(tag);
            boolean oldRay = tag.func_74767_n("rayState");
            this.addLink(null, next, false, oldRay);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTUtils.writeBlockPosToNBT(this.thisPos, compound);
        compound.func_74757_a("ignoreBlockCollision", this.ignoreBlockCollision);
        NBTTagList sources = new NBTTagList();
        for (BlockPos source : this.sourcesToThis) {
            NBTTagCompound comp = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(source, comp);
            sources.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("sources", (NBTBase)sources);
        if (this.nextPos != null) {
            NBTTagCompound pos = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(this.nextPos, pos);
            pos.func_74757_a("rayState", this.nextReachable);
            compound.func_74782_a("nextPos", (NBTBase)pos);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTransmissionNode that = (SimpleTransmissionNode)o;
        return !(this.thisPos == null ? that.thisPos != null : !this.thisPos.equals((Object)that.thisPos));
    }

    public int hashCode() {
        return this.thisPos != null ? this.thisPos.hashCode() : 0;
    }

    public static class Provider
    implements TransmissionClassRegistry.TransmissionProvider {
        @Override
        public IPrismTransmissionNode provideEmptyNode() {
            return new SimpleTransmissionNode(null);
        }

        @Override
        public String getIdentifier() {
            return "astralsorcery:SimpleTransmissionNode";
        }
    }
}

