/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base;

import hellfirepvp.astralsorcery.common.auxiliary.link.ILinkableTile;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.transmission.TransmissionNetworkHelper;
import hellfirepvp.astralsorcery.common.tile.base.TileNetwork;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileTransmissionBase
extends TileNetwork
implements IStarlightTransmission,
ILinkableTile {
    private final boolean singleLink = this.getClass() == TileCrystalLens.class;
    private List<BlockPos> positions = new LinkedList<BlockPos>();

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.positions.clear();
        if (compound.func_74764_b("linked")) {
            NBTTagList list = compound.func_150295_c("linked", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.positions.add(NBTUtils.readBlockPosFromNBT(tag));
            }
        }
    }

    @Override
    public World getLinkWorld() {
        return this.getTrWorld();
    }

    @Override
    public BlockPos getLinkPos() {
        return this.getTrPos();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.positions) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(pos, tag);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("linked", (NBTBase)list);
    }

    @Override
    public void onLinkCreate(EntityPlayer player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return;
        }
        if (TransmissionNetworkHelper.createTransmissionLink(this, other)) {
            if (this.singleLink) {
                this.positions.clear();
            }
            if (this.singleLink || !this.positions.contains(other)) {
                this.positions.add(other);
                this.markForUpdate();
            }
        }
    }

    @Override
    @Nonnull
    public BlockPos getTrPos() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public World getTrWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean tryLink(EntityPlayer player, BlockPos other) {
        return !other.equals((Object)this.func_174877_v()) && TransmissionNetworkHelper.canCreateTransmissionLink(this, other);
    }

    @Override
    public boolean tryUnlink(EntityPlayer player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return false;
        }
        if (TransmissionNetworkHelper.hasTransmissionLink(this, other)) {
            TransmissionNetworkHelper.removeTransmissionLink(this, other);
            this.positions.remove(other);
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return this.positions;
    }
}

