/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.network.packet.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBreakAssist {
    private static final Map<Integer, TickTokenizedMap<BlockPos, BreakEntry>> breakMap = new HashMap<Integer, TickTokenizedMap<BlockPos, BreakEntry>>();

    public static BreakEntry addProgress(World world, BlockPos pos, float expectedHardness, float percStrength) {
        BreakEntry breakProgress;
        TickTokenizedMap<Object, BreakEntry> map = breakMap.get(world.field_73011_w.getDimension());
        if (map == null) {
            map = new TickTokenizedMap(TickEvent.Type.SERVER, new TickEvent.Type[0]);
            TickManager.getInstance().register(map);
            breakMap.put(world.field_73011_w.getDimension(), map);
        }
        if ((breakProgress = (BreakEntry)map.get(pos)) == null) {
            breakProgress = new BreakEntry(Float.valueOf(expectedHardness), world, pos, world.func_180495_p(pos));
            map.put(pos, breakProgress);
        }
        BreakEntry breakEntry = breakProgress;
        breakEntry.breakProgress = breakEntry.breakProgress - percStrength;
        breakProgress.idleTimeout = 0;
        return breakProgress;
    }

    @SideOnly(value=Side.CLIENT)
    public static void blockBreakAnimation(PktPlayEffect pktPlayEffect) {
        RenderingUtils.playBlockBreakParticles(pktPlayEffect.pos, Block.func_176220_d((int)pktPlayEffect.data));
    }

    public static class BreakEntry
    implements TickTokenizedMap.TickMapToken<Float>,
    CEffectPositionListGen.CEffectGenListEntry {
        private float breakProgress;
        private final World world;
        private BlockPos pos;
        private IBlockState expected;
        private int idleTimeout;

        public BreakEntry(World world) {
            this.world = world;
        }

        public BreakEntry(@Nonnull Float value, World world, BlockPos at, IBlockState expectedToBreak) {
            this.breakProgress = value.floatValue();
            this.world = world;
            this.pos = at;
            this.expected = expectedToBreak;
        }

        @Override
        public int getRemainingTimeout() {
            return this.breakProgress <= 0.0f || this.idleTimeout >= 20 ? 0 : 1;
        }

        @Override
        public void tick() {
            ++this.idleTimeout;
        }

        @Override
        public void onTimeout() {
            if (this.breakProgress > 0.0f) {
                return;
            }
            IBlockState nowAt = this.world.func_180495_p(this.pos);
            if (nowAt.func_177230_c().equals(this.expected.func_177230_c()) && nowAt.func_177230_c().func_176201_c(nowAt) == this.expected.func_177230_c().func_176201_c(this.expected)) {
                MiscUtils.breakBlockWithoutPlayer((WorldServer)this.world, this.pos, this.world.func_180495_p(this.pos), true, true, true);
            }
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.breakProgress);
        }

        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.breakProgress = nbt.func_74760_g("breakProgress");
            this.pos = NBTUtils.readBlockPosFromNBT(nbt);
            this.expected = Block.func_176220_d((int)nbt.func_74762_e("expectedStateId"));
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74776_a("breakProgress", this.breakProgress);
            NBTUtils.writeBlockPosToNBT(this.pos, nbt);
            nbt.func_74768_a("expectedStateId", Block.func_176210_f((IBlockState)this.expected));
        }
    }
}

