/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect.time;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopZone;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeStopEffectHelper {
    @Nonnull
    private BlockPos position;
    private float range;
    private boolean hasOwner;
    private int ownerEntityId;

    private TimeStopEffectHelper(@Nonnull BlockPos position, float range, boolean hasOwner, int ownerEntityId) {
        this.position = position;
        this.range = range;
        this.hasOwner = hasOwner;
        this.ownerEntityId = ownerEntityId;
    }

    static TimeStopEffectHelper fromZone(TimeStopZone zone) {
        return new TimeStopEffectHelper(zone.offset, zone.range, zone.hasOwner, zone.ownerId);
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.position;
    }

    public float getRange() {
        return this.range;
    }

    public boolean hasOwner() {
        return this.hasOwner;
    }

    public int getOwnerEntityId() {
        return this.ownerEntityId;
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientTickEffect() {
        Color c = new Color(0xDDDDDD);
        Random rand = new Random();
        List entities = Minecraft.func_71410_x().field_71441_e.func_175647_a(EntityLivingBase.class, new AxisAlignedBB((double)(-this.range), (double)(-this.range), (double)(-this.range), (double)this.range, (double)this.range, (double)this.range).func_72317_d((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p()), EntitySelectors.func_188443_a((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p(), (double)this.range));
        for (EntityLivingBase e : entities) {
            if (e == null || e.field_70128_L || this.hasOwner && e.func_145782_y() == this.ownerEntityId || rand.nextInt(3) != 0) continue;
            double x = e.field_70165_t - (double)e.field_70130_N + (double)(rand.nextFloat() * e.field_70130_N * 2.0f);
            double y = e.field_70163_u + (double)(rand.nextFloat() * e.field_70131_O);
            double z = e.field_70161_v - (double)e.field_70130_N + (double)(rand.nextFloat() * e.field_70130_N * 2.0f);
            Object p = EffectHelper.genericFlareParticle(x, y, z);
            ((EntityFXFacingParticle)p).setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            ((EntityFXFacingParticle)p).scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
            ((EntityComplexFX)p).setMaxAge(40 + rand.nextInt(20));
            if (!(rand.nextFloat() < 0.9f)) continue;
            p = EffectHelper.genericFlareParticle(x, y, z);
            ((EntityFXFacingParticle)p).setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            ((EntityFXFacingParticle)p).scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
            ((EntityComplexFX)p).setMaxAge(30 + rand.nextInt(10));
        }
        int minX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() - this.range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() + this.range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() - this.range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() + this.range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = Minecraft.func_71410_x().field_71441_e.func_72964_e(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry entry : map.entrySet()) {
                    TileEntity te;
                    if (rand.nextInt(3) != 0 || (te = (TileEntity)entry.getValue()) == null || !(te instanceof ITickable) || !(this.position.func_185332_f(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()) <= (double)this.range)) continue;
                    double x = (float)te.func_174877_v().func_177958_n() + rand.nextFloat();
                    double y = (float)te.func_174877_v().func_177956_o() + rand.nextFloat();
                    double z = (float)te.func_174877_v().func_177952_p() + rand.nextFloat();
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
                    p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
                    p.setMaxAge(40 + rand.nextInt(20));
                    if (!(rand.nextFloat() < 0.9f)) continue;
                    p = EffectHelper.genericFlareParticle(x, y, z);
                    p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
                    p.setMaxAge(30 + rand.nextInt(10));
                }
            }
        }
        Vector3 pos = null;
        for (int i = 0; i < 10; ++i) {
            pos = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.5f + 0.3f).gravity(0.004);
            p.setMaxAge(40 + rand.nextInt(20));
            if (!(rand.nextFloat() < 0.9f)) continue;
            p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.2f + 0.1f).gravity(0.004);
            p.setMaxAge(30 + rand.nextInt(10));
        }
        if (rand.nextInt(4) == 0) {
            Vector3 rand1 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            Vector3 rand2 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vec3i)this.position);
            AstralSorcery.proxy.fireLightning((World)Minecraft.func_71410_x().field_71441_e, rand1, rand2, c);
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound out = new NBTTagCompound();
        NBTUtils.writeBlockPosToNBT(this.position, out);
        out.func_74776_a("range", this.range);
        out.func_74757_a("hasOwner", this.hasOwner);
        out.func_74768_a("ownerEntityId", this.ownerEntityId);
        return out;
    }

    @Nonnull
    public static TimeStopEffectHelper deserializeNBT(NBTTagCompound cmp) {
        BlockPos at = NBTUtils.readBlockPosFromNBT(cmp);
        float range = cmp.func_74760_g("range");
        boolean hasOwner = cmp.func_74767_n("hasOwner");
        int ownerId = cmp.func_74762_e("ownerEntityId");
        return new TimeStopEffectHelper(at, range, hasOwner, ownerId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStopEffectHelper that = (TimeStopEffectHelper)o;
        return Float.compare(that.range, this.range) == 0 && this.hasOwner == that.hasOwner && this.ownerEntityId == that.ownerEntityId && this.position.equals((Object)that.position);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + (this.range != 0.0f ? Float.floatToIntBits(this.range) : 0);
        result = 31 * result + (this.hasOwner ? 1 : 0);
        result = 31 * result + this.ownerEntityId;
        return result;
    }
}

