/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.nbt;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    @Nonnull
    public static NBTTagCompound getPersistentData(Entity entity) {
        return NBTHelper.getPersistentData(entity.getEntityData());
    }

    @Nonnull
    public static NBTTagCompound getPersistentData(ItemStack item) {
        return NBTHelper.getPersistentData(NBTHelper.getData(item));
    }

    @Nonnull
    public static NBTTagCompound getPersistentData(NBTTagCompound base) {
        NBTTagCompound compound;
        if (NBTHelper.hasPersistentData(base)) {
            compound = base.func_74775_l("astralsorcery");
        } else {
            compound = new NBTTagCompound();
            base.func_74782_a("astralsorcery", (NBTBase)compound);
        }
        return compound;
    }

    public static boolean hasPersistentData(Entity entity) {
        return NBTHelper.hasPersistentData(entity.getEntityData());
    }

    public static boolean hasPersistentData(ItemStack item) {
        return item.func_77978_p() != null && NBTHelper.hasPersistentData(item.func_77978_p());
    }

    public static boolean hasPersistentData(NBTTagCompound base) {
        return base.func_74764_b("astralsorcery") && base.func_74781_a("astralsorcery") instanceof NBTTagCompound;
    }

    public static void removePersistentData(Entity entity) {
        NBTHelper.removePersistentData(entity.getEntityData());
    }

    public static void removePersistentData(ItemStack item) {
        if (item.func_77942_o()) {
            NBTHelper.removePersistentData(item.func_77978_p());
        }
    }

    public static void removePersistentData(NBTTagCompound base) {
        base.func_82580_o("astralsorcery");
    }

    public static NBTTagCompound getData(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public static void setStack(NBTTagCompound compound, String tag, ItemStack stack) {
        NBTTagCompound stackCompound = new NBTTagCompound();
        stack.func_77955_b(stackCompound);
        compound.func_74782_a(tag, (NBTBase)stackCompound);
    }

    public static void setUUID(NBTTagCompound compound, String tag, UUID uuid) {
        NBTTagCompound uuidComp = new NBTTagCompound();
        uuidComp.func_74772_a("mostSigBits", uuid.getMostSignificantBits());
        uuidComp.func_74772_a("leastSigBits", uuid.getLeastSignificantBits());
        compound.func_74782_a(tag, (NBTBase)uuidComp);
    }

    public static ItemStack getStack(NBTTagCompound compound, String tag) {
        return NBTHelper.getStack(compound, tag, ItemStack.field_190927_a);
    }

    public static UUID getUUID(NBTTagCompound compound, String tag) {
        return NBTHelper.getUUID(compound, tag, null);
    }

    public static ItemStack getStack(NBTTagCompound compound, String tag, ItemStack defaultValue) {
        if (compound.func_74764_b(tag)) {
            return new ItemStack(compound.func_74775_l(tag));
        }
        return defaultValue;
    }

    public static UUID getUUID(NBTTagCompound compound, String tag, UUID defaultValue) {
        if (compound.func_74764_b(tag)) {
            NBTTagCompound uuidComp = compound.func_74775_l(tag);
            return new UUID(uuidComp.func_74763_f("mostSigBits"), uuidComp.func_74763_f("leastSigBits"));
        }
        return defaultValue;
    }

    public static boolean getBoolean(NBTTagCompound compound, String tag, boolean defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74767_n(tag) : defaultValue;
    }

    public static String getString(NBTTagCompound compound, String tag, String defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74779_i(tag) : defaultValue;
    }

    public static int getInteger(NBTTagCompound compound, String tag, int defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74762_e(tag) : defaultValue;
    }

    public static double getDouble(NBTTagCompound compound, String tag, double defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74769_h(tag) : defaultValue;
    }

    public static float getFloat(NBTTagCompound compound, String tag, float defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74760_g(tag) : defaultValue;
    }

    public static byte getByte(NBTTagCompound compound, String tag, byte defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74771_c(tag) : defaultValue;
    }

    public static short getShort(NBTTagCompound compound, String tag, short defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74765_d(tag) : defaultValue;
    }

    public static long getLong(NBTTagCompound compound, String tag, long defaultValue) {
        return compound.func_74764_b(tag) ? compound.func_74763_f(tag) : defaultValue;
    }
}

