/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.struct;

import hellfirepvp.astralsorcery.common.base.TreeTypes;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeDiscoverer {
    @Nullable
    public static BlockArray tryCaptureTreeAt(World world, BlockPos origin, int xzLimit, boolean cornerSpread) {
        Tuple<BlockStateCheck, BlockStateCheck> treeChecks = TreeDiscoverer.discoverTreeLogAndLeaf(world, origin);
        BlockStateCheck logCheck = (BlockStateCheck)treeChecks.key;
        BlockStateCheck leafCheck = (BlockStateCheck)treeChecks.value;
        if (logCheck == null && leafCheck == null) {
            return null;
        }
        int xzLimitSq = xzLimit == -1 ? -1 : xzLimit * xzLimit;
        BlockArray out = new BlockArray();
        Tuple<BlockStateCheck, BlockStateCheck> checks = TreeDiscoverer.itDiscoverAndAdd(world, origin, logCheck, leafCheck, xzLimitSq, cornerSpread, out);
        if (checks.key == null || checks.value == null) {
            return null;
        }
        return out;
    }

    private static Tuple<BlockStateCheck, BlockStateCheck> itDiscoverAndAdd(World world, BlockPos origin, BlockStateCheck logCheck, BlockStateCheck leafCheck, int xzLimitSq, boolean cornerSpread, BlockArray out) {
        Stack<BlockPos> offsetPositions = new Stack<BlockPos>();
        offsetPositions.add(origin);
        while (!offsetPositions.isEmpty()) {
            BlockPos offset = (BlockPos)offsetPositions.pop();
            IBlockState atState = world.func_180495_p(offset);
            boolean successful = false;
            Tuple<BlockStateCheck, BlockStateCheck> atChecks = null;
            if (logCheck == null || leafCheck == null) {
                atChecks = TreeDiscoverer.discoverTreeLogAndLeaf(world, offset);
            }
            if (logCheck == null && atChecks.key != null) {
                logCheck = (BlockStateCheck)atChecks.key;
            }
            if (leafCheck == null && atChecks.value != null) {
                leafCheck = (BlockStateCheck)atChecks.value;
            }
            if (logCheck != null && logCheck.isStateValid(world, offset, atState)) {
                out.addBlock(offset, atState);
                successful = true;
            }
            if (leafCheck != null && leafCheck.isStateValid(world, offset, atState)) {
                out.addBlock(offset, atState);
                successful = true;
            }
            if (!successful) continue;
            if (cornerSpread) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int yy = -1; yy <= 1; ++yy) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            BlockPos newPos = offset.func_177982_a(xx, yy, zz);
                            if (xzLimitSq != -1 && !(TreeDiscoverer.flatDistanceSq((Vec3i)newPos, (Vec3i)origin) <= (double)xzLimitSq) || out.hasBlockAt(newPos)) continue;
                            offsetPositions.push(newPos);
                        }
                    }
                }
                continue;
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos newPos = offset.func_177972_a(face);
                if (xzLimitSq != -1 && !(TreeDiscoverer.flatDistanceSq((Vec3i)newPos, (Vec3i)origin) <= (double)xzLimitSq) || out.hasBlockAt(newPos)) continue;
                offsetPositions.push(newPos);
            }
        }
        return new Tuple<BlockStateCheck, BlockStateCheck>(logCheck, leafCheck);
    }

    private static double flatDistanceSq(Vec3i from, Vec3i to) {
        double xDiff = (double)from.func_177958_n() - (double)to.func_177958_n();
        double zDiff = (double)from.func_177952_p() - (double)to.func_177952_p();
        return xDiff * xDiff + zDiff * zDiff;
    }

    @Nonnull
    private static Tuple<BlockStateCheck, BlockStateCheck> discoverTreeLogAndLeaf(World world, BlockPos pos) {
        BlockStateCheck logCheck = null;
        BlockStateCheck leafCheck = null;
        TreeTypes t = TreeTypes.getTree(world, pos);
        if (t != null) {
            logCheck = t.getLogCheck();
            leafCheck = t.getLeavesCheck();
        } else {
            IBlockState at = world.func_180495_p(pos);
            if (at.func_177230_c() instanceof BlockLog) {
                logCheck = new BlockStateCheck.Block(at.func_177230_c());
            } else if (at.func_177230_c().isWood((IBlockAccess)world, pos)) {
                logCheck = new BlockStateCheck.Block(at.func_177230_c());
            }
            if (at.func_177230_c() instanceof BlockLeaves) {
                leafCheck = new BlockStateCheck.Block(at.func_177230_c());
            } else if (at.func_177230_c().isLeaves(at, (IBlockAccess)world, pos)) {
                leafCheck = new BlockStateCheck.Block(at.func_177230_c());
            }
        }
        return new Tuple<BlockStateCheck, BlockStateCheck>(logCheck, leafCheck);
    }
}

